//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <cool/Hash_Table.h>
#include <test.h>

DECLARE Hash_Table<int,double>;

void test_int_double_get_put(Hash_Table<int,double>& h0) {
  int i;
  double d;
  // get and put pass values by reference.  Cfront creates stack
  // temporaries for these values, which creates too many
  // nesting levels for the Microsoft C compiler.
  static int c1=1, c2=2, c3=3, c4=4, c5=5, c6=6, c7=7, c8=8, c9=9;
  TEST ("h0.reset()",(h0.reset(),c1),c1);
  TEST ("h0.put(1,2.5)", h0.put(c1,2.5),TRUE);
  TEST ("h0.value()", h0.value(), 2.5);
  TEST ("h0.get(1,d)", (h0.get(c1,d) == TRUE && d == 2.5), TRUE);
  TEST ("h0.length()", h0.length(), c1);
  TEST ("h0.value()", h0.value(), 2.5);
  TEST ("h0.put(2,3.5)", h0.put(c2,3.5),TRUE);
  TEST ("h0.get(2,d)", (h0.get(c2,d) == TRUE && d == 3.5), TRUE);
  TEST ("h0.put(3,4.5)", h0.put(c3,4.5),TRUE);
  TEST ("h0.get(3,d)", (h0.get(c3,d) == TRUE && d == 4.5), TRUE);
  TEST ("h0.put(4,5.5)", h0.put(c4,5.5),TRUE); 
  TEST ("h0.value()", h0.value(), 5.5);
  TEST ("h0.get(4,d)", (h0.get(c4,d) == TRUE && d == 5.5), TRUE);
  TEST ("h0.value()", h0.value(), 5.5);
  TEST ("h0.put(5,9.5)", h0.put(c5,6.5),TRUE);
  TEST ("h0.get(5,d)", (h0.get(c5,d) == TRUE && d == 6.5), TRUE);
  TEST ("h0.value()", h0.value(), 6.5);
  TEST ("h0.put(6,7.5)", h0.put(c6,7.5),TRUE);
  TEST ("h0.get(6,d)", (h0.get(c6,d) == TRUE && d == 7.5), TRUE);
  TEST ("h0.get_key(7.5,i)", h0.get_key(7.5,i), TRUE);
  TEST ("i == 6", (i == c6), 1);
  TEST ("h0.put(7,8.5)", h0.put(c7,8.5),TRUE);
  TEST ("h0.get(7,d)", (h0.get(c7,d) == TRUE && d == 8.5), TRUE);
  TEST ("h0.put(8,9.5)", h0.put(c8,9.5),TRUE);
  TEST ("h0.get(8,d)", (h0.get(c8,d) == TRUE && d == 9.5), TRUE);
  TEST ("h0.put(9,10.5)", h0.put(c9,10.5),TRUE);
  TEST ("h0.get(9,d)", (h0.get(c9,d) == TRUE && d == 10.5), TRUE);
  TEST ("h0.get_bucket_count()", h0.get_bucket_count(), 3);
  TEST ("h0.length()", h0.length(), 9);
  TEST ("h0.remove(1)", h0.remove(1), TRUE);
  TEST ("h0.length()", h0.length(), 8);
}

void test_int_double_next(Hash_Table<int,double>& h0) {
  TEST ("h0.reset()",(h0.reset(),1),1);
  TEST ("h0.next()",h0.next(),TRUE);
  TEST ("h0.next()",h0.next(),TRUE);
  TEST ("h0.next()",h0.next(),TRUE);
  TEST ("h0.next()",h0.next(),TRUE);
  TEST ("h0.next()",h0.next(),TRUE);
  TEST ("h0.next()",h0.next(),TRUE);
  TEST ("h0.next()",h0.next(),TRUE);
  TEST ("h0.next()",h0.next(),TRUE);
  TEST ("h0.next()",h0.next(),FALSE);
  TEST ("h0.prev()",h0.prev(),TRUE);
  TEST ("h0.prev()",h0.prev(),TRUE);
  TEST ("h0.prev()",h0.prev(),TRUE);
  TEST ("h0.prev()",h0.prev(),TRUE);
  TEST ("h0.prev()",h0.prev(),TRUE);
  TEST ("h0.prev()",h0.prev(),TRUE);
  TEST ("h0.prev()",h0.prev(),TRUE);
  TEST ("h0.prev()",h0.prev(),TRUE);
  TEST ("h0.prev()",h0.prev(),FALSE);
}

void test_int_double () {
  int i;
  double d;
  // get and put pass values by reference.  Cfront creates stack
  // temporaries for these values, which creates too many
  // nesting levels for the Microsoft C compiler.
  static int c2=2, c3=3, c4=4, c6=6, c7=7, c8=8, c9=9;
  Hash_Table<int,double> h0;
  TEST ("Hash_Table<int,double> h0",h0.get_bucket_count(),3);
  Hash_Table<int,double> h1(20);
  TEST ("Hash_Table<int,double> h1(20)",h1.get_bucket_count(),3);
  Hash_Table<int,double> h2(25);
  TEST ("Hash_Table<int,double> h2(25)",h2.get_bucket_count(),7);
  Hash_Table<int,double> h3(h2);
  TEST ("Hash_Table<int,double> h3(h2)",h3.get_bucket_count(),7);
  TEST ("h2==h3", (h2==h3), TRUE);
  TEST ("h2 == h3", (h2 == h3), TRUE);
  TEST ("h1 == h2", (h1 == h2), TRUE);
  TEST ("h1 != h3", (h1 != h3), FALSE);
  test_int_double_get_put(h0);
  test_int_double_next(h0);
  TEST ("h1=h0", (h1=h0,(h0==h1)), TRUE);
  h1.resize(30); //  TEST ("h1.resize(30)", h1.resize(30), TRUE);
  TEST ("h1.get(7,d)", (h1.get(c7,d) == TRUE && d == 8.5), TRUE);
  TEST ("h1.value()", h1.value(), 8.5);
  TEST ("h1.get(3,d)", (h1.get(c3,d) == TRUE && d == 4.5), TRUE);
  TEST ("h1.value()", h1.value(), 4.5);
  TEST ("h1.get(9,d)", (h1.get(c9,d) == TRUE && d == 10.5), TRUE);
  TEST ("h1.value()", h1.value(), 10.5);
  TEST ("h1.get_bucket_count()", h1.get_bucket_count(), 7);
  TEST ("h1.length()", h1.length(), 8);
  TEST ("h0.set_ratio(1.0)", (h0.set_ratio(1.0),1), 1);
  h0.resize(30); //  TEST ("h0.resize(30)", h0.resize(30), TRUE);
  TEST ("h0.get_bucket_count()", h0.get_bucket_count(), 7);
  TEST ("h0.get(2,d)", (h0.get(c2,d) == TRUE && d == 3.5), TRUE);
  TEST ("h0.get(4,d)", (h0.get(c4,d) == TRUE && d == 5.5), TRUE);
  TEST ("h0.get(6,d)", (h0.get(c6,d) == TRUE && d == 7.5), TRUE);
  TEST ("h0.get(8,d)", (h0.get(c8,d) == TRUE && d == 9.5), TRUE);
  h0.resize(60); // TEST ("h0.resize(60)", h0.resize(60), TRUE);
  TEST ("h0.get_bucket_count()", h0.get_bucket_count(), 19);
  TEST ("h0.get(2,d)", (h0.get(c2,d) == TRUE && d == 3.5), TRUE);
  TEST ("h0.value()", h0.value(), 3.5);
  TEST ("h0.get(4,d)", (h0.get(c4,d) == TRUE && d == 5.5), TRUE);
  TEST ("h0.value()", h0.value(), 5.5);
  TEST ("h0.get(6,d)", (h0.get(c6,d) == TRUE && d == 7.5), TRUE);
  TEST ("h0.value()", h0.value(), 7.5);
  TEST ("h0.get(8,d)", (h0.get(c8,d) == TRUE && d == 9.5), TRUE);
  TEST ("h0.get_key(9.5,i)", h0.get_key(9.5,i), TRUE);
  TEST ("i == 8", (i == 8), 1);
  TEST ("h0.value()", h0.value(), 9.5);
  TEST ("h0.clear()", (h0.clear(), h0.length()), 0);
  TEST ("h1.clear()", (h1.clear(), h1.length()), 0);
  TEST ("h3.clear()", (h3.clear(), h3.length()), 0);
  TEST ("for(i=0;i<100;i++) h3.put(i,double(i))",1,1);
  for(i = 0; i < 100; i++)
     h3.put(i, (double) i);
  TEST ("for(i=0;i<100;i++) h3.find(i)",1,1);
  for(i = 0; i < 100; i++)
    if(h3.find(i) == FALSE) {
      TEST ("for(i=0;i<100;i++) h3.find(i)",h3.find(i),TRUE);
      break;
    }
}
