//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: LGO 05/19/89 -- Initial design and implementation
//
// This header file includes EVERYTHING needed to create a generic  class.  The
// generic class definition is split out into  this seperate file to facilitate
// the bootstrapping process required  by the  circular references in the class
// hierarchy (e.g. Symbol uses Hash_Table which uses Base_Hash_Table which uses
// Generic, and Generic uses Symbol).
//
// If  the preprocessor symbol ERROR_CHECKING  is defined, the  Exception class
// header file is included and all COOL classes will then include conditionally
// compiled  code for of error   detection  and exception  handling. Note  that
// exception  handling requires run  time type  checking and  symbols, which is
// enabled if the preprocessor symbol GENERIC_TYPECHECK is defined.

// Note: we can't use GENERICH because AT&T #defines it in their generic.h
#ifndef GENERIC_H		// If we have not yet defined the Generic class
#define GENERIC_H		// Indicate class Generic has been included

#ifndef GEN_CLASSH		// If we have not yet defined the Generic class
#include <cool/Gen_class.h>	// include the Generic class header file
#endif

#ifndef SYMBOLH
#include <cool/Symbol.h>
#endif

// Setup the default COOL packages. The first creates a  package SYM to be kept
// in the file <COOL/sym_package.p>   that  will contain all   COOL   type name
// symbols. These are generated for any class that inherits from Generic.   The
// second creates a  package  ERR_MSG to be kept  in  <COOL/err_package.p> that
// will contain all COOL error symbols and their associated text message.  This
// can be modified to internationalize or customize a user application.

symbol_package (SYM, <sym_package.p>, nospace=1)
text_package (ERR_MSG, <err_package.p>)

#ifndef EXCEPTIONH
#include <cool/Exception.h>
#endif						// End ERROR_CHECKING

// Flag to IMPLEMENT_GENERIC that generic is defined
#define GENERIC_DEFINED

#endif						// End #ifdef of GENERIC_H


