//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 06/15/89 -- Initial design and implementation.
// Updated: MJF 02/22/90 -- Split into separate file.
// Updated: MJF 06/30/90 -- Added base class name to constructor initializer

// An overview of the structure of the IGNORE_ERRS macro and the Jump_Handler
// class can be found in the Ignore_Errs.h header file.

#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.
#include <cool/Ignore_Errs.h>   // include the Ignore_Errs header file.

// **********************************************************************
// Constructor for the Jump_Handler class
// **********************************************************************

// Jump_Handler(Jump_Handler_Function, Excp_Type)
//              -- a handler constructor which initializes
//                 with a specified Exception type and Handler function.
//
// Input:   An exception handler function and an exception type.
// Output:  None.

Jump_Handler::Jump_Handler(Jump_Handler_Function ehf, Excp_Type et)
#ifdef __cplusplus
 : Excp_Handler((Excp_Handler_Function)ehf, et) {}
#else
 : ((Excp_Handler_Function)ehf, et) {}
#endif
