(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Fri Feb  7 00:03:04 PST 1992 by muller     *)
(*      modified on Tue Jan 28 12:45:57 PST 1992 by kalsow     *)



(* The UnsafeRd interface is similar, but GetChar and Eof are the only
operations that are sufficiently performance-critical to be included: *)

UNSAFE INTERFACE UnsafeRd;
IMPORT Rd, Thread; 
FROM Thread IMPORT Alerted;
FROM Rd IMPORT Failure, EndOfFile;

REVEAL
  Rd.T <: Thread.Mutex;

PROCEDURE FastGetChar(rd: Rd.T): CHAR RAISES {EndOfFile, Failure, Alerted};
(* Like Rd.GetChar, but rd must be locked. *)

PROCEDURE FastEOF(rd: Rd.T): BOOLEAN RAISES {Failure, Alerted};
(* Like Rd.EOF, but rd must be locked. *)

PROCEDURE FastUnGetChar(rd: Rd.T) RAISES {};
(* Like Rd.UnGetChar, but rd must be locked. *)

PROCEDURE FastClose (rd: Rd.T) RAISES {Failure, Alerted};

END UnsafeRd.

