(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Tue Jun  9 14:10:37 PDT 1992 by kalsow     *)
(*      modified on Mon Nov 18 14:52:27 PST 1991 by muller     *)


UNSAFE MODULE FileIO;

IMPORT Unix, M3toC, IOFailure, Rd, Wr, UFileRd, UFileWr, Thread;

PROCEDURE OpenRead (nm: TEXT): Rd.T RAISES {Rd.Failure} =
  VAR fd: INTEGER;
  BEGIN
    fd:= Unix.open (M3toC.TtoS (nm), Unix.O_RDONLY + Unix.O_BINARY, Unix.Mrwrr);
    IF (fd < 0) THEN RAISE Rd.Failure (IOFailure.open); END;
    RETURN (UFileRd.New (fd));
  END OpenRead;

PROCEDURE OpenWrite (nm: TEXT): Wr.T RAISES {Wr.Failure} =
  CONST Mode = Unix.O_WRONLY + Unix.O_CREAT + Unix.O_TRUNC + Unix.O_BINARY;
  BEGIN
    RETURN OpenWriteOrAppend (nm, Mode);
  END OpenWrite;

PROCEDURE OpenAppend (nm: TEXT): Wr.T RAISES {Wr.Failure} =
  <*FATAL Thread.Alerted*>
  CONST Mode = Unix.O_WRONLY + Unix.O_CREAT + Unix.O_BINARY;
  VAR wr := OpenWriteOrAppend (nm, Mode);
  BEGIN
    Wr.Seek (wr, Wr.Length (wr)-2);
    RETURN wr;
  END OpenAppend;

PROCEDURE OpenWriteOrAppend (nm: TEXT;  flags: INTEGER): Wr.T
          RAISES {Wr.Failure} =
  VAR fd: INTEGER;
  BEGIN
    fd := Unix.open (M3toC.TtoS (nm), flags, Unix.Mrwrr);
    IF fd < 0 THEN RAISE Wr.Failure (IOFailure.open); END;
    RETURN (UFileWr.New (fd));
  END OpenWriteOrAppend;

BEGIN
END FileIO.
