MODULE Terminal;  (*27.02.1993. LB*)
(*Simple interactive I/O on the screen and keyboard*)

  IMPORT Stdio, Fmt, Rd, Wr, Scan;

(*(Weich)*)
     IMPORT Thread;
     <*FATAL Rd.Failure, Wr.Failure, Thread.Alerted*>

  PROCEDURE GetLine(): TEXT =
  (*Reads a line from the keyboard*)
  BEGIN
    RETURN
      Rd.GetLine(Stdio.stdin);
  END GetLine;

  PROCEDURE PutText(t: TEXT) =
  (*Displays a text on the screen*)
  BEGIN
    Wr.PutText(Stdio.stdout, t);
    Wr.Flush(Stdio.stdout);
  END PutText;

  PROCEDURE GetInt(): INTEGER =
  (*Reads a line containing an integer from the keyboard*)
  BEGIN
    LOOP
      TRY
        RETURN Scan.Int(GetLine());
      EXCEPT
        Scan.BadFormat => 
          PutText("This is not an integer, try again" & "\n");
      END; (*TRY*)
    END; (*LOOP*)
  END GetInt;

  PROCEDURE PutInt(i: INTEGER; length:= 3) =
  (*Displays an integer on the screen*)
  BEGIN
    PutText(Fmt.Pad(Fmt.Int(i), length));
  END PutInt;
 
  PROCEDURE CharsAvailable(): BOOLEAN =
  (*Returns TRUE if some characters are typed already, FALSE otherwise.*)
  BEGIN
    RETURN Rd.CharsReady(Stdio.stdin) > 0;
  END CharsAvailable;

BEGIN
END Terminal.
