(* Copyright (C) 1990, Digital Equipment Corporation.         *)
(* All rights reserved.                                       *)
(* See the file COPYRIGHT for a full description.             *)

(* Last modified on Thu Oct  8 08:56:12 PDT 1992 by mcjones   *)
(*      modified on Wed Oct  7 11:49:?? PST 1992 by muller    *)
(*      modified on Fri Feb 28 09:11:58 PST 1992 by kalsow    *)



INTERFACE Text;

TYPE T = TEXT;
(* A non-nil TEXT represents a zero-based sequence of characters.
   NIL does not represent any sequence of characters, it will not
   be returned from any procedure in this interface. It is a checked
   runtime error to pass NIL to any procedure in this interface. *)

PROCEDURE Cat (t, u: T): T;
(* Return the concatenation of t and u.  *)

PROCEDURE Equal (t, u: T): BOOLEAN;
(* Return TRUE if t and u have the same length and the same (case-sensitive)
   contents. *)

PROCEDURE GetChar (t: T; i: CARDINAL): CHAR;
(* Return character i of t.  A checked error if i >= Length(t). *)

PROCEDURE Length (t: T): CARDINAL;
(* Return the number of characters in t. *)

PROCEDURE Empty (t: T): BOOLEAN;
(* Equivalent to Length(t) = 0 *)

PROCEDURE Sub (t: T; start, length: CARDINAL): T;
(* Returns a sub-sequence of t. The result will be empty if start >= Length(t);
   otherwise the range of indexes of the subsequence is [start ..
   MIN(start+length, Length(t))-1]. *)

PROCEDURE SetChars (VAR a: ARRAY OF CHAR; t: T);
(* For each i in [0 .. MIN(LAST(a), Length(t) - 1)], set a[i] to GetChar(t, i).
   *)

PROCEDURE FromChar (c: CHAR): T;
(* Return a text containing the character c *)

PROCEDURE FromChars (READONLY a: ARRAY OF CHAR): T;
(* Return a text containing the characters of a. *)

PROCEDURE Hash (t: T): INTEGER;
(* Return a hash function of the contents of t. *)

(*--- Extension --- *)

PROCEDURE FindChar (t: T; c: CHAR; start := 0): INTEGER;
(* If c is one of t[i] for i IN [start .. Length(t)-1], returns the smallest
   such i; otherwise, returns -1 *)

PROCEDURE FindCharR (t: T; c: CHAR; start := LAST (INTEGER)-5): INTEGER;
(* If c is one of t[i] for i IN [0 .. MIN (start, Length (t)-1)], returns the
   largest such i; otherwise, returns -1.
   *** Note: the default value for start should be LAST (INTEGER);
       however, there is a bug in some C compilers and the - 5 fixes that. *)
      
PROCEDURE Compare (t1, t2: T): [-1..1];
(* Returns -1 if t1 is less than t2, 0 if t1=t2, +1 if t1 is greater than t2;
   comparaison are made using the lexigraphic ordering *)

END Text.
