(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Wed Nov  6 10:49:09 PST 1991 by kalsow         *)
(*      modified on Tue Feb 12 03:22:32 1991 by muller         *)

INTERFACE Stdio;

(* The interface Stdio provides streams for standard input, standard
output, and standard error: *)

IMPORT Rd, Wr, Thread;

VAR
  stdin:  Rd.T;
  stdout: Wr.T;
  stderr: Wr.T;
  bufferedStdout: Wr.T;  (* always buffered *)
  bufferedStderr: Wr.T;  (* always buffered *)

(* Of course, the standard and buffered versions of stdout and stderr
   should not both be used in the same program *)

PROCEDURE Close (n: INTEGER := 0) 
  RAISES {Rd.Failure, Thread.Alerted, Wr.Failure};

END Stdio.

(* The initialization of these streams depends on the underlying
operating system.  If the output streams are directed to terminals,
they should be unbuffered, so that explicit Wr.Flush calls are
unnecessary for interactive programs.  If the streams are directed to
or from random-access files, they should be seekable.  It is possible
that stderr = stdout; therefore, programs that perform seek operations
on stdout should take care not to destroy output data when writing
error messages. *)

