(* Copyright 1992 Digital Equipment Corporation. *)
(* Distributed only by permission. *)
(* RTWeakRef.i3 *)
(* Last modified on Wed Sep 23 12:42:06 PDT 1992 by jdd *)

(* This is the low-level ("runtime") interface for weak refs.  This
   interface is used by the higher-level WeakRef.  In fact, the
   abstractions are currently the same, except for a slight redefinition of
   the WeakRef object itself. *)

INTERFACE RTWeakRef;

TYPE WeakRef = ARRAY [0..7] OF BITS 8 FOR [0..255];

PROCEDURE WeakRefFromRef (r: REFANY; p: WeakRefCleanUpProc := NIL):
  WeakRef;

PROCEDURE WeakRefToRef (w: WeakRef): REFANY;

TYPE WeakRefCleanUpProc = PROCEDURE (READONLY w: WeakRef; r: REFANY);

END RTWeakRef.
