#ifndef _G_config_h
#define _G_config_h

// This files contains various system-dependent typedefs and defines.
// The file only defines names in the implementor's namespace.
// E.g. We define _G_size_t and not size_t.
// Thus other include files can safely use _G_size_t without clashes.
// In the long run, we should probably have a separate file
// for each configuration.


#ifndef _G_size_t
#ifdef size_t
#define _G_size_t size_t
#elif defined(__SIZE_TYPE__)
#define _G_size_t __SIZE_TYPE__
#else
#define _G_size_t unsigned long
#endif
#endif

#ifndef _G_time_t
#ifdef time_t
#define _G_time_t time_t
#elif defined(__ultrix)
#define _G_time_t int
#else
#define _G_time_t long
#endif
#endif

// Use _G_const for parameters that ought to be const,
// but might not be in the vendor include files.

#ifndef _G_const
#define _G_const const
#endif

#ifndef _G_va_list
#ifdef va_list
#define _G_va_list va_list
#else
#define _G_va_list char*
#endif
#endif

#ifndef _G_fpos_t
#ifdef fpos_t
#define _G_fpos_t fpos_t
#else
#define _G_fpos_t long
#endif
#endif

#ifndef _G_FOPEN_MAX
#ifdef FOPEN_MAX
#define _G_FOPEN_MAX FOPEN_MAX
#else
#define _G_FOPEN_MAX 16
#endif
#endif

#ifndef _G_FILENAME_MAX
#ifdef FILENAME_MAX
#define _G_FILENAME_MAX FILENAME_MAX
#else
#define _G_FILENAME_MAX 16
#endif
#endif

#endif /* !_G_config_h */
