#! /bin/zsh -f

# Written by SL Baur <steve@xemacs.org>
# December, 1998
# This file is part of XEmacs and is used by the maintainers
#  for creating distributions

# UpdateLogs:  Add a note that a formal distribution has been made
# Usage:  UpdateLogs MAJOR MINOR BUILD

setopt extendedglob
set -e # Exit at the first sign of trouble

if [ $# != 4 ]; then
	echo "Usage: $0: MAJOR MINOR BUILD commitflag"
	exit 1
fi

export MAJOR=$1
export MINOR=$2
export BUILD=$3
export commitflag=$4

# The following line does not with `export' and I don't know why
AUTHOR=$(date '+%Y-%m-%d  XEmacs Build Bot <builds@cvs.xemacs.org>')
export NEXT=${MAJOR}.${MINOR}.${BUILD}
export BUILDDIR=xemacs-${MAJOR}.${MINOR}

if [ ! -d ${BUILDDIR} ]; then
	echo "Error: ${BUILDDIR} does not exist"
	exit 1
fi

cd ${BUILDDIR}

for logfile in **/ChangeLog; do
	ed ${logfile} <<altair
1i
$AUTHOR

	* XEmacs $NEXT is released

.
w
q
altair
done

if [ "$commitflag" = t ]; then
	cvs commit -m "XEmacs Release ${NEXT}"
else
	echo "Would have executed:"
	echo cvs commit -m "XEmacs Release ${NEXT}"
fi

exit 0
