#! /bin/zsh -f

# Written by SL Baur <steve@xemacs.org>
# December, 1998
# This file is part of XEmacs and is used by the maintainers
#  for creating distributions

# MakeXEmacs:  Configure, compile and link XEmacs
# Usage:  MakeXEmacs BUILDDIR configureflag checkflag

setopt extendedglob
set -e

if [ $# != 3 ]; then
	echo "Usage: $0 BUILDDIR configureflag checkflag"
	exit 1
fi

if [ ! -d ${BUILDDIR} ]; then
	echo "${BUILDDIR}: does not exist"
	exit 1
fi

export BUILDDIR=$1
export configureflag=$2
export checkflag=$3
if [ ! "$PREFIX" ]; then
	export PREFIX=$(pwd)
fi

cd ${BUILDDIR}

if [ "$configureflag" = "t" ]; then
	./configure --prefix=${PREFIX} --cflags=-O --with-mule --without-x11 \
		--debug=no --error-checking=none

	# Rebuild only the binary, no further lisp or texinfo yet
	make xemacs
fi

if [ "$checkflag" = "t" ]; then
	# Build the full distribution
	make
	# Run Martin's beloved self-checker
	# If we make it through, we will consider the binary safe enough
	#  to commit to CVS for a formal release.
	make check
fi

exit 0
