/*
  File autogenerated by gengetopt version 2.0  
  generated with the following command:
  ../src/gengetopt -isample1.ggo -Fcmdline1 --long-help -u 
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
/* Check for configure's getopt check result.  */
#ifndef HAVE_GETOPT_LONG
#include "getopt.h"
#else
#include <getopt.h>
#endif

#include "cmdline1.h"

/* Don't define PACKAGE and VERSION if we use automake.  */
#define PACKAGE "sample1"
#define VERSION "2.0"


void
print_version (void)
{
  printf ("%s %s\n", PACKAGE, VERSION);
}

void
print_help (void)
{
  print_version ();
  printf ("Usage: %s -iINT|--int-opt=INT [-h|--help] [-V|--version] [-sSTRING|--str-opt=STRING] [-F|--funct-opt] [-x|--flag-opt]  [FILES]...\n\
   -h         --help            Print help and exit\n\
   -V         --version         Print version and exit\n\
   -sSTRING   --str-opt=STRING  A string option\n\
   -iINT      --int-opt=INT     A int option\n\
   -F         --funct-opt       A function option\n\
   -x         --flag-opt        A flag option (default=off)\n\
", PACKAGE);
}


char *
gengetopt_strdup (char * s)
{
  char * n, * pn, * ps = s;
  while (*ps) ps++;
  n = malloc (1 + ps - s);
  if (n != NULL)
    {
      for (ps=s,pn=n; *ps; ps++,pn++)
        *pn = *ps;
      *pn = 0;
    }
  return n;
}


int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;	

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->str_opt_given = 0 ;
  args_info->int_opt_given = 0 ;
  args_info->funct_opt_given = 0 ;
  args_info->flag_opt_given = 0 ;

#define clear_args()
{ \
  args_info->str_opt_arg = NULL; \
  args_info->flag_opt_flag = 0;\
}

  clear_args();

  args_info->inputs = NULL;
  args_info->inputs_num = 0;

  while (1)
    {
      int option_index = 0;
      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "str-opt",	1, NULL, 's' },
        { "int-opt",	1, NULL, 'i' },
        { "funct-opt",	0, NULL, 'F' },
        { "flag-opt",	0, NULL, 'x' },
        { NULL,	0, NULL, 0 }
      };

      c = getopt_long (argc, argv, "hVs:i:Fx", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          clear_args ();
          print_help ();
          exit (0);

        case 'V':	/* Print version and exit.  */
          clear_args ();
          print_version ();
          exit (0);

        case 's':	/* A string option.  */
          if (args_info->str_opt_given)
            {
              fprintf (stderr, "%s: `--str-opt' (`-s') option given more than once\n", PACKAGE);
              clear_args ();
              print_help ();
              exit (1);
            }
          args_info->str_opt_given = 1;
          args_info->str_opt_arg = gengetopt_strdup (optarg);
          break;

        case 'i':	/* A int option.  */
          if (args_info->int_opt_given)
            {
              fprintf (stderr, "%s: `--int-opt' (`-i') option given more than once\n", PACKAGE);
              clear_args ();
              print_help ();
              exit (1);
            }
          args_info->int_opt_given = 1;
          args_info->int_opt_arg = atoi (optarg);
          break;

        case 'F':	/* A function option.  */
          if (args_info->funct_opt_given)
            {
              fprintf (stderr, "%s: `--funct-opt' (`-F') option given more than once\n", PACKAGE);
              clear_args ();
              print_help ();
              exit (1);
            }
          args_info->funct_opt_given = 1;
          break;

        case 'x':	/* A flag option.  */
          args_info->flag_opt_flag = !(args_info->flag_opt_flag);
          break;

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          exit (1);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */

  if (! args_info->int_opt_given)
    {
      fprintf (stderr, "%s: `--int-opt' (`-i') option required!\n", PACKAGE);
      missing_required_options = 1;
    }

  if ( missing_required_options )
    exit (1);

  if (optind < argc)
    {
      int i = 0 ;

      args_info->inputs_num = argc - optind ;
      args_info->inputs = 
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = strdup (argv[optind++]) ; 
    }

  return 0;
}