.\" Copyright (c) 1993, 1994  X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall not
.\" be used in advertising or otherwise to promote the sale, use or other
.\" dealing in this Software without prior written authorization from the
.\" X Consortium.
.TH LNDIR 1 "Release 6" "X Version 11"
.SH NAME
lndir \- create a shadow directory of symbolic links to another directory tree
.SH SYNOPSIS
.B lndir
fromdir [todir]
.SH DESCRIPTION
.I Lndir
makes a shadow copy
.I todir
of a directory tree
.I fromdir,
except that the shadow is not
populated with real files but instead with symbolic links pointing at
the real files in the
.I fromdir
directory tree.  This is usually useful for maintaining source code for
different machine architectures.  You create a shadow directory
containing links to the real source which you will have usually NFS
mounted from a machine of a different architecture, and then recompile
it.  The object files will be in the shadow directory, while the
source files in the shadow directory are just symlinks to the real
files.
.PP
This has the advantage that if you update the source, you need not
propagate the change to the other architectures by hand, since all
source in shadow directories are symlinks to the real thing: just cd
to the shadow directory and recompile away.
.PP
The
.I todir
argument is optional and defaults to the current directory.  The
.I fromdir
argument may be relative (e.g., ../src) and is relative to
.I todir
(not the current directory).
.PP
.ft B
.\" CVS.adm is used by the Concurrent Versions System.
Note that RCS, SCCS, and CVS.adm directories are not shadowed.
.ft
.PP
If you add files, simply run
.I lndir
again.  Deleting files is a more painful problem; the symlinks will
just point into never never land.
.SH BUGS
.I Patch
gets upset if it cannot change the files.  You should never run
.I patch
from a shadow directory anyway.
.PP
You need to use something like
.nf
	find todir \-type l \-print | xargs rm
.fi
to clear out all files before you can relink (if fromdir moved, for instance).
Something like
.nf
	 find . \\! \-type d \-print
.fi
will find all files that are not directories.
