# ifndef lint
static char SccsId[] =  "@(#)ttystatus.c	1.1\t10/1/88" ;
# endif

# include       "sps.h"
# include       "flags.h"
# include       <stdio.h>
# include       <h/ioctl.h>
# ifdef SUNOS40
# include       <h/stream.h>
# else
# include       <h/tty.h>
# endif
# ifdef CHAOS
# include       <chunix/chsys.h>
# include       <chaos/chaos.h>
# endif

/*
** TTYSTATUS - Reads the kernel memory for tty structures of active processes.
** The addresses of the associated struct ttys of /dev/kmem are kept in the
** info structure. Here we use those addresses to access the structures.
** Actually, we are mostly interested just in the process group of each tty.
*/
ttystatus ()
{
	register struct ttyline *lp ;
# ifdef SUNOS40
	struct stdata           *stdata ;
	extern struct stdata    *getstdata() ;
# else
	struct tty              tty ;
# endif
	extern struct flags     Flg ;
	extern struct info      Info ;
# ifndef KVM
	extern int              Flkmem ;
# endif

# ifdef SUNOS40
	if ( !init_streams_tab() )
		fprintf( stderr, "can't read streams table\n" ) ;
# endif

	if ( Flg.flg_y )
# ifdef SUNOS40
		printf( "Ty   Dev       Addr  Pgrp\n" ) ;
# else
		printf( "Ty   Dev       Addr Rawq Canq Outq  Pgrp\n" ) ;
# endif
	lp = Info.i_ttyline ;
# ifdef CHAOS
	while ( lp->l_name[0] && lp->l_name[0] != 'C' )
# else
	while ( lp->l_name[0] )
# endif
	{
# ifdef SUNOS40 
		if ( stdata = getstdata ( lp->l_addr, lp->l_dev ) )
		{
			lp->l_stdata = stdata ;
			lp->l_pgrp = stdata->sd_pgrp ;
			prstr( lp, stdata ) ;
		}
		else
			lp->l_pgrp = 0 ;
		lp++ ;
# else
		if ( getkmem( (long)lp->l_addr, (char*)&tty, sizeof( tty ) )
		!= sizeof( struct tty ) )
		{
			fprintf( stderr,
				"sps - Can't read struct tty for tty%.2s\n",
				lp->l_name ) ;
			lp->l_pgrp = 0 ;
			lp++ ;
			continue ;
		}
		lp->l_pgrp = tty.t_pgrp ;
		prtty( lp, &tty ) ;
		lp++ ;
# endif
	}
# ifdef CHAOS
	chaosttys( lp ) ;               
# endif
}

# ifdef SUNOS40

/* PRSTR - Print out the stdata structure */
prstr ( lp, stdata )

register struct ttyline         *lp ;
register struct stdata          *stdata ;

{
	extern struct flags     Flg ;

	if ( !Flg.flg_y )
		return ;
	printf( "%-2.2s %2d,%2d 0x%08x %5d\n",
		lp->l_name,
		major( lp->l_dev ),
		minor( lp->l_dev ),
		lp->l_addr,
		stdata->sd_pgrp ) ;
}

# else

/* PRTTY - Print out the tty structure */
prtty ( lp, tty )

register struct ttyline         *lp ;
register struct tty             *tty ;

{
	extern struct flags     Flg ;

	if ( !Flg.flg_y )
		return ;
	printf( "%-2.2s %2d,%2d 0x%08x %4d %4d %4d %5d\n",
		lp->l_name,
		major( lp->l_dev ),
		minor( lp->l_dev ),
		lp->l_addr,
		tty->t_rawq.c_cc,
		tty->t_canq.c_cc,
		tty->t_outq.c_cc,
		tty->t_pgrp ) ;
}

# endif

# ifdef CHAOS

/* CHAOSTTYS - Finds ttys attached to the Chaos net */
chaosttys ( lp )

register struct ttyline         *lp ;

{
	register struct connection      **cnp ;
	register int                    i ;
	struct tty                      tty ;
	struct connection               *conntab[CHNCONNS] ;
	struct connection               conn ;
	extern struct info              Info ;
	extern int                      Flkmem ;

	(void)getkmem( (long)Info.i_Chconntab, (char*)conntab,
		sizeof( conntab ) ) ;
	for ( i = 0, cnp = conntab ; cnp < &conntab[CHNCONNS] ; i++, cnp++ )
	{
		if ( !*cnp )
			continue ;
		(void)getkmem( (long)*cnp, (char*)&conn, sizeof( conn ) ) ;
		if ( !(conn.cn_flags & CHTTY) )
			continue ;
		(void)getkmem( (long)conn.cn_ttyp, (char*)&tty, sizeof( tty ) ) ;
		if ( lp >= &Info.i_ttyline[MAXTTYS] )
			prexit( "sps - Too many chaos ttys\n" ) ;
		lp->l_addr = conn.cn_ttyp ;
		lp->l_pgrp = tty.t_pgrp ;
		lp->l_dev = tty.t_dev ;
		lp->l_name[0] = 'C' ;
		lp->l_name[1] = i < 10 ? '0'+i : i-10 <= 'z'-'a' ? i-10+'a' :
				i-10-('z'-'a')+'A' ;
		prtty( lp, &tty ) ;
		lp++ ;
	}
}

# endif
