# ifndef lint
static char SccsId[] =  "@(#)stream.c	1.1\t10/1/88" ;
# endif

# ifdef SUNOS40
# include "sps.h"
# include <h/stream.h>
# include <h/vnode.h>

static struct stdata    *pstreams ;
static struct stdata    *pstreamsNSTREAMS ;

init_streams_tab()
{
	int                     len ;
	extern struct info      Info ;
	register struct stdata  *s ;
	struct vnode            *v ;
	char                    *getcore() ;

	if ( pstreams )
	{				/* reinitializing */
		for ( s = pstreams ; s <= pstreamsNSTREAMS ; s++ )
		{
			if ( s->sd_vnode != 0 )
				free( (char*)s->sd_vnode ) ;
		}
		free( (char*)pstreams ) ;
	}	    
	len = ( ( Info.i_streamsNSTREAMS - Info.i_streams ) + 1 )
		* sizeof ( struct stdata ) ;
	pstreams = (struct stdata*)getcore( len ) ;
	pstreamsNSTREAMS = pstreams + (len / sizeof( struct stdata ) ) ;
	if ( getkmem( (long)Info.i_streams, (char*)pstreams, len ) != len )
		return( 0 ) ;

	for ( s = pstreams ; s <= pstreamsNSTREAMS ; s++ )
	{
		if ( s->sd_vnode != 0 )
		{
			if ( ( v = (struct vnode*)getcore( sizeof( *v ) ) )
			&& getkmem( (long)s->sd_vnode, (char*)v, sizeof( *v ) )
			== sizeof( *v ) )
			{
				s->sd_vnode = v ;
				continue ;
			}

			s->sd_vnode = 0 ;
		}
	}
	return( 1 ) ;
}


struct stdata *getstdata ( st, dev )

struct streamtab                *st ;
dev_t                            dev ;

{
	register struct stdata  *s ;

	for ( s = pstreams ; s <= pstreamsNSTREAMS ; s++ )
		if ( s->sd_strtab == st && s->sd_vnode
		&& s->sd_vnode->v_rdev == dev )
			return( s ) ;

	return( 0 ) ;
}

/* 1 if `w' is in the address range defined by `a1' and `a2' ... */
# define        INRANGE( w, a1, a2 ) \
			( (caddr_t)(a1) <= (w) && (w) < (caddr_t)(a2) )

char *gettty ( lp, w )

register struct ttyline         *lp ;
caddr_t                         w ;

{
	struct stdata           *s ;
	struct queue            *q ;
	struct queue            qq[2] ;
	char                    *cp = 0 ;

	if ( ( s = lp->l_stdata ) == 0 )
		return( 0 ) ;

	q = s->sd_wrq ;		/* get write queue (only queue_t in stdata) */
	do
	{
		if ( INRANGE( w, RD( q ), q ) )
		{			/* check read queue */
			cp = "rtty??" ;
			break ;
		}
		if ( INRANGE( w, q, WR ( q ) ) )
		{			/* check write queue */
			cp = "wtty??" ;
			break ;
		}
		/* check queue private data structures - useful??? */
		if ( getkmem( (long)RD( q ), (char*)qq, sizeof( qq ) )
		!= sizeof( qq ) )
			break ;
		if ( INRANGE( w, qq[0].q_ptr, qq[0].q_ptr + 1 ) )
		{
			cp = "r?ty??" ;
		}
		if ( INRANGE( w, qq[1].q_ptr, qq[1].q_ptr + 1 ) )
		{
			cp = "w?ty??" ;
		}
		q = qq[1].q_next ;
	}
	while ( q ) ;

	if ( cp )
	{
		cp[4] = lp->l_name[0] ;
		cp[5] = lp->l_name[1] ;
		return( cp ) ;
	}

	return( 0 ) ;			/* chain down list? */
}
# endif

