.if n .pl 66
.TH SPS 1
.SH NAME
sps \ \ \-\ \ \ show process status
.SH SYNOPSIS
\fBsps\ \fP \ [ \fB\-cdefgijkoqrslvwyABDFNPSTUWZ\fP ]\ \ [
\fIprocess\ .\ .\ .\ | tty\ .\ .\ .\ | user\ .\ .\ .\fP ]
.SH DESCRIPTION
\fISps\fP reports information concerning system processes.
It shows the current state of any process by
listing information such as ownership, CPU time usage, memory usage
and disc activity.
.PP
\fISps\fP should be used in preference to \fIps\fP(1)
because it is faster and the output is more comprehensive and more
comprehensible.
.SH OPTIONS
By default, \fIsps\fP prints basic information about one's own processes.
The various options described below select other processes or make
\fIsps\fP more verbose.
.PP
Upper case options select processes to be described.
Lower case options specify the format of the output.
For instance, the options \fBBv\fP specify that \fIsps\fP
should list ``busy'' processes in a verbose format.
Unless there is any conflict, lower case options may be used
instead of upper case options, and vice versa.
.PP
The following options specify the format of the listed output \-
.TP 8
\fB\-c\fP
Use the system's idea of the command, rather than getting the arguments
from user space.  While somewhat less informative, this is faster and
more reliable.
.TP
\fB\-d\fP
List output reflecting how each process affects the
disc and paging activity of the system.
.TP
\fB\-e\fP
List the environment passed to each process.
.TP
\fB\-f\fP
Include the process\-id of the parent of each process.
.TP
\fB\-g\fP
Include the process group of each process.
.TP
\fB\-o\fP
Avoid looking at the swap device (\fB/dev/drum\fP). This tends to make \fIsps\fP
run faster, although no information concerning swapped processes
can be obtained.
.TP
\fB\-q\fP
By default, \fIsps\fP
lists the sum of the user plus system times under the
\fITime\fP and \fIChild\fP fields.  This option forces \fIsps\fP
to list only the user times.
.TP
\fB\-r\fP
Repeat the output indefinitely.
If the next argument is numeric, \fIsps\fP repeats the output with that
many seconds delay between each repetition.
Otherwise the output is repeated with no delay.
.TP
\fB\-l\fP
.br
.ns
.TP
\fB\-v\fP
List additional information in a verbose format. See below.
.TP
\fB\-w\fP
List output in a wide format.  This option forces \fIsps\fP
to print all the command arguments, even if doing so extends the output
beyond one line.
.TP
\fB\-y\fP
Show the status of each terminal line.
.PP
The following options specify which processes are to be described \-
.TP 8
\fB\-A\fP
List all processes.
.TP
\fB\-B\fP
List busy processes.  A process is considered to be busy
if it is immediately runnable or awaiting a fast event such as disc I/O.
.TP
\fB\-D\fP
List detached processes.
.TP
\fB\-F\fP
List foreground processes.
.TP
\fB\-N\fP
Show no processes at all. Only the summary line is printed.
.TP
\fB\-P\fP
List only processes whose identifiers are specified in the following arguments.
.TP
\fB\-S\fP
List stopped processes.
.TP
\fB\-T\fP
List only processes attached to the following specified terminals.
.TP
\fB\-U\fP
List only processes belonging to the following specified users.
.TP
\fB\-W\fP
List waiting processes.
.TP
\fB\-Z\fP
List zomby (exiting) processes.
.PP
The following are miscellaneous options \-
.TP 8
\fB\-i\fP
Initialise \fIsps\fP.
This is necessary if new users are added to the password file,
or if a new version of UNIX is installed.
Sps builds a new information file summarising pertinent information
read from the password file (\fB/etc/passwd\fP), the executable kernel image
(\fB/vmunix\fP) and the directory of tty devices (\fB/dev\fP).
See also the \fB\-j\fP and \fB\-s\fP options.
.TP
\fB\-j\fP
Specify an information file other than the default (\fB/etc/spsinfo\fP).
The next argument is taken to be the name of a suitable information file.
If the \fB\-i\fP flag is also specified, \fIsps\fP builds a
new information file with the given name.
Otherwise, \fBsps\fP reads previously created summarising information
from that file.
.TP
\fB\-k\fP
Use a specific disc file rather than the default physical
memory (\fB/dev/mem\fP)
and kernel virtual memory (\fB/dev/kmem\fP) files. The next argument is taken
to be the name of a suitable memory dump file.
This flag automatically sets the \fB\-o\fP flag.
.TP
\fB\-s\fP
This option is used in conjunction with the \fB\-i\fP option.
The next argument is taken to be the name of a suitable kernel executable
file, rather than the default (\fB/vmunix\fP).
\fISps\fP looks at the symbol table of this file to determine
the virtual addresses of various kernel structures.
.SH OUTPUT
\fISps\fP produces output in the following fields \-
.TP 8
\fITy\fP
The terminal identifier to which the process is attached.
.IP
If this is followed by an underscore, the process is detached.
If it is followed by a period, the process is running in the foreground.
Otherwise the process is running in the background but is still
attached to a terminal.
.TP
\fIUser\fP
The symbolic name of the process' effective user-id (see \fIexec\fP(2)
and \fIsetuid\fP(2)).
This name is defined by the system password file (\fB/etc/passwd\fP)
when \fIsps\fP was last initialised.
Otherwise, an asterisk (\fB*\fP) or vertical bar (\fB|\fP) appearing in this
column denotes that the process is an immediate relative of the
preceding process.
A bar is listed, rather than an asterisk, if both processes belong
to the same process group.
A user name is listed only if the effective user-id
differs from that of the preceding process or if it is a top-level
process (immediate offspring of process 1).
.TP
\fIProc#\fP
The unique process identifier.
.TP
\fIPpid#\fP
The process-id of the process' parent.
.TP
\fIPgrp#\fP
The process group to which the process belongs.
.TP
\fICommand\fP
The command arguments obtained from the process' own address space.
(If the command name appears in parentheses, \fIsps\fP
was unable to locate the arguments in user space and so reports
the system's idea of the command name.)
.PP
The following additional fields are listed when \fIsps\fP
is invoked with one of the \fB\-l\fP or \fB\-v\fP options \-
.TP 8
\fIStatus\fP
The process' current state.
If this field is listed in upper-case letters, the process is currently
loaded in real memory space ; otherwise it has been swapped out.
The status field may contain one of the following descriptions \-
.RS 8
.TP 16
\fIrun\fP
The process can be run immediately.
.TP
\fIstop\fP
The process is stopped. See \fIsigvec\fP(2).
.TP
\fIexit\fP
The process is a zomby.
.RE
.IP
Any other entry in the status field indicates the process is
waiting for some external event to occur.
This is usually for one of the reasons listed below.
(If \fIsps\fP does not know why a process is waiting, it lists
the hexadecimal address of the process' wait channel,
with the initial 80000000 trimmed off.)
A process may be waiting for one of the following reasons \-
.RS 8
.TP 16
\fIchild\fP
The process is waiting for a child to terminate. See \fIwait\fP(2).
.TP
\fIpause\fP
Waiting for a signal to be received. See \fIsigpause\fP(2).
.TP
\fIswap\fP
Waiting for a page to be swapped in.
.TP
\fIrswbuf\fP
Waiting for a read from the swap device \fB/dev/drum.\fP
.TP
\fIdiscio\fP
Waiting for a disc read or write operation.
(Actually, this means that the process is waiting for an operation
through the kernel's I/O buffering mechanism to complete, but \fIdiscio\fP
is what is generally meant here).
.TP
\fIrpipe\fP
.br
.ns
.TP
\fIwpipe\fP
Waiting for a read from an empty pipe.  Alternatively, the process
is waiting to write to a full pipe. See \fIpipe\fP(2).
.TP
\fIrsockt\fP
.br
.ns
.TP
\fIwsockt\fP
Waiting for a read from an empty socket.
Alternatively, the process is waiting to write to a full socket (4.[2\-]bsd only).
.TP
\fIaccept\fP
Waiting to accept a stream-based socket connection (4.[2\-]bsd only).
See \fIaccept\fP(2).
.TP
\fIconnct\fP
Waiting to establish a connection through a stream-based socket to a
remote process (4.[2\-]bsd only). See \fIconnect\fP(2).
.TP
\fIsocket\fP
Waiting for some other time-out event on a socket (4.[2\-]bsd only).
.TP
\fIselect\fP
Blocked by a \fIselect\fP(2) system call (4.[2\-]bsd only).
.TP
\fIrmux\fP
Waiting for a read from a multiplexor file (4.1bsd only).
.TP
\fIinode\fP
Waiting for an inode to be allocated or unlocked.
.TP
\fIexlock\fP
.br
.ns
.TP
\fIshlock\fP
Waiting for a file to become unlocked. See \fIflock\fP(2).
.TP
\fIrtty??\fP
.br
.ns
.TP
\fIwtty??\fP
.br
.ns
.TP
\fIotty??\fP
Waiting for a read or write to the specified terminal, or for the terminal
to be switched on. See \fItty\fP(4).
Alternatively, waiting for a read or write to the
specified slave pty device. See \fIpty\fP(4).
.TP
\fIitty??\fP
.br
.ns
Under SunOS, waiting perform I/O to an iconified window.
.TP
\fIrpty??\fP
.br
.ns
.TP
\fIwpty??\fP
Waiting for a read or write to the specified master pty device.
See \fIpty\fP(4).
.TP
\fIptrace\fP
This is a parent process tracing its child.
.TP
\fIvfork\fP
This is a vforking parent process waiting for its child to relinquish
memory resources. See \fIvfork\fP(2).
.TP
\fIfloppy\fP
.br
.ns
.TP
\fIprintr\fP
.br
.ns
.TP
\fIr??buf\fP
Waiting for the specified device to complete an I/O operation.
.RE
.TP 8
\fIFl\fP
Flags associated with the current state of the process.
These flags may be any of the following \-
.RS 8
.TP 16
\fIU\fP
The process is a UNIX system process.
.TP
\fIT\fP
The process is being traced or debugged.
.TP
\fIV\fP
The process is a child currently being vforked. See \fIvfork\fP(2).
.TP
\fII\fP
The process is undergoing physical I/O.
.TP
\fIA\fP
The system has detected, or the user has warned of
anomalous paging behaviour. See \fIvadvise\fP(2).
.RE
.TP 8
\fINice\fP
The ``niceness'' of the process. See \fInice\fP(2).
.TP
\fIVirtual\fP
The virtual memory size of the process in kilobytes.
The first figure indicates the sum of the data and stack segments,
the second figure that of the text segment.
.TP
\fIResident\fP
The resident memory size of the process in kilobytes, representing
the real memory devoted to the process.
.TP
\fI%M\fP
The percentage of available real memory allocated to this process.
.TP
\fITime\fP
The total CPU time accumulated by this process.
(This is the sum of the system plus user times, unless the \fB\-q\fP
flag is specified in which case only the user time is listed.)
.TP
\fIChild\fP
The total CPU time accumulated by the process' children.
(This is the sum of the system plus user times, unless the \fB\-q\fP
flag is specified.)
.TP
\fI%C\fP
The percentage of available CPU time devoted to the process.
This figure is a decaying average, computed over the past second.
.PP
The following fields are listed when \fIsps\fP is invoked with the
\fB\-d\fP option \-
.TP 8
\fIFiles\fP
The number of open files for this process.
.TP
\fIPageFaults\fP
The number of major and minor page faults incurred by the process.
.TP
\fISwap\fP
The number of swaps incurred by the process.
.TP
\fIBlockI/O\fP
The number of block read or write operations performed
on behalf of the process.
.TP
\fIKbytesecs\fP
The integral of real memory usage over time.
Thus, if a process uses 60 kilobytes of real memory for 3 seconds,
this figure is incremented by 180.
.PP
The following fields are listed when \fIsps\fP is invoked with the
\fB\-y\fP option \-
.TP 8
\fIDev\fP
The major and minor device numbers of the terminal.
.TP
\fIAddr\fP
The virtual address of the associated \fBstruct tty\fP in \fB/dev/kmem\fP.
.TP
\fIRawq\fP
.br
.ns
.TP
\fICanq\fP
.br
.ns
.TP
\fIOutq\fP
The number of characters in the terminal I/O queues.
These refer to the raw input queue, the canonical input queue
and the output queue.
.TP
\fIPgrp\fP
The process group associated with the terminal.
.PP
After listing the requested output, \fIsps\fP prints a summary line.
This indicates the number and total virtual memory size of all processes,
the number and total virtual size of busy processes,
the number and real memory size of loaded processes
and the number and real size of swapped processes.
.SH DIAGNOSTICS
\fISps\fP reports a self-explanatory message if it is given an
invalid argument list.
The program also complains if it cannot find necessary system information.
.PP
At initialisation, \fIsps\fP complains if it cannot find the addresses of
requisite system structures in the kernel symbol file.
This is usually the case because the system is rarely configured to support
all known devices.
\fISps\fP also complains if more than one user shares the same user-id
in the password file (\fB/etc/passwd\fP).
.SH EXAMPLES
\fBsps vb\fP
.PP
\fISps\fP describes all busy processes in a verbose manner.
.PP
\fBsps dtg 9 h1 co\fP
.PP
\fISps\fP lists processes associated with terminals \fB9\fP,
\fBh1\fP and the \fBconsole\fP.
The output reflects the disc activity caused by these processes.
The process group of each process is also included in the output.
.PP
\fBsps weu robert fred \-r 2\fP
.PP
\fISps\fP reports processes belonging to the specified users.
It lists the environment as well as all the command arguments in a wide format.
The output is produced indefinitely, with a delay of two seconds between
each listing.
.PP
\fBsps is /vmunix.new\fP
.PP
\fISps\fP is initialised. It reads its symbol information from the
specified file.
.SH FILES
.ta 2.5i
.nf
\fB/dev/console\fP	Console
\fB/dev/tty??\fP	Terminal and pty devices
\fB/dev/kmem\fP	Kernel virtual memory
\fB/dev/mem\fP	Physical memory
\fB/dev/drum\fP	Paging and swap device
\fB/etc/passwd\fP	Password file
\fB/etc/spsinfo\fP	Information file
\fB/vmunix\fP	Symbol file of \fB/dev/kmem\fP addresses
\fB/etc/termcap\fP	To determine the output terminal width
.fi
.ta
.SH SEE ALSO
\fIiostat\fP(1), \fIkill\fP(1), \fIps\fP(1),
\fIvmstat\fP(1), \fIexec\fP(2),
\fIflock\fP(2), \fInice\fP(2), \fIpause\fP(2), \fIselect\fP(2), \fIsetuid\fP(2),
\fIsigvec\fP(2), \fIvadvise\fP(2), \fIvfork\fP(2), \fIwait\fP(2),
\fIpty\fP(4),\fItty\fP(4), \fIpstat\fP(8).
.SH AUTHORS
Several. In particular, J. E. Kulp and J. Robert Ward,
\fB<robert@olsen.uucp>\fP.
.LP
NFS changes incorporated by Alexander Dupuy,
\fB<dupuy@amsterdam.columbia.edu>\fP
.LP
SunOS 4.0 implementation by Alexander Dupuy and
Charlie Kim \fB<cck@cunixc.cc.columbia.edu>\fP.
.LP
Ultrix 2.\fIx\fP additions incorporated by Rob Lehman at CUUCA.
.LP
Currently maintained by J. Robert Ward, \fB<robert@olsen.uucp>\fP
.SH BUGS
Because the system is continually changing, the information reported by
\fIsps\fP is only an approximation to reality.
If invoked by root, \fIsps\fP renices itself to \-20 in an attempt to run as
fast as possible.
.PP
\fISps\fP recognises the sizes and addresses of internal kernel
tables whenever it is invoked. However, it must be recompiled
if major modifications are made to the kernel.
.PP
\fISps\fP does not list all the detailed information shown by \fIps\fP(1).
Nor are all the options supported by \fIps\fP(1) available from \fIsps\fP.
.PP
\fISps\fP does not understand all the possible
reasons why a process may be sleeping.
.PP
The code of \fIsps\fP is inherently machine-dependent and non-portable.
.PP
The number of options to \fIsps\fP is ridiculous.
