# ifndef lint
static char SccsId[] =  "@(#)readstatus.c	1.1\t10/1/88" ;
# endif

# include       "sps.h"
# ifndef SUNOS40
# include       <h/text.h>
# endif

/* READSTATUS - Reads the kernel memory for current processes and texts */
# ifdef SUNOS40
readstatus ( process )

register struct process         *process ;

# else

readstatus ( process, text )

register struct process         *process ;
struct text                     *text ;

# endif
{
	register struct proc    *p ;
	register struct proc    *p0 ;
	register struct process *pr ;
	int                     size ;
	extern struct info      Info ;
	char                    *getcore() ;

# ifndef SUNOS40
	/* Read current text information */
	size = Info.i_ntext * sizeof( struct text ) ;
	if ( getkmem( (long)Info.i_text0, (char*)text, size ) != size )
		prexit( "sps - Can't read system text table\n" ) ;
# endif
	/* Read current process information */
	size = Info.i_nproc * sizeof( struct proc ) ;
	p0 = (struct proc*)getcore( size ) ;
	if ( getkmem( (long)Info.i_proc0, (char*)p0, size ) != size )
		prexit( "sps - Can't read system process table\n" ) ;
	/* Copy process information into our own array */
	for ( p = p0, pr = process ; pr < &process[ Info.i_nproc ] ; p++, pr++ )
		pr->pr_p = *p ;
	free( (char*)p0 ) ;
}
