# ifndef lint
static char SccsId[] =  "@(#)main.c	1.1\t10/1/88" ;
# endif

# include       "sps.h"
# include       "flags.h"
# ifdef KVM
# include       <kvm.h>
# include       <fcntl.h>
# endif KVM
# ifndef SUNOS40
# include       <h/text.h>
# endif
# include       <sys/stat.h>
# include       <stdio.h>


/* SPS - Show Process Status */

/* J. R. Ward - Hasler AG, Bern, Switzerland		 - 24 May 1985 */
/*				     			 - 26 Nov 1986 */
/* J. R. Ward - Olsen & Associates, Zuerich, Switzerland -  1 Oct 1988 */
/* <robert@olsen.uucp> */

/* NFS additions and SunOS4.0 support by Alexander Dupuy
   <dupuy@ncs.columbia.edu> and Charlie Kim <cck@cunixc.cc.columbia.edu>.
   Ultrix 2.x support by Rob Lehman at CUCCA. */

main ( argc,argv )

int                             argc ;
char                            **argv ;

{
	register struct process *plist ;
	register struct process *process ;
# ifndef SUNOS40
	register struct text    *text ;
# endif
	int                     flinfo ;
	char			*fileinfo, *filesymbol ;
	struct stat		sinfo, ssymbol ;
# ifdef WARNPASSWD
	struct stat		spasswd ;
# endif
	extern struct flags     Flg ;
	extern struct info      Info ;
# ifdef KVM
	extern kvm_t           *Flkvm ;
# else
	extern int              Flmem ;
	extern int              Flkmem ;
	extern int              Flswap ;
# endif
	char                    *getcore() ;
	struct process          *needed(), *mktree() ;

	/* Renice as fast as possible for root only (Suggested by Jeff Mogul,
	   gregorio!mogul) */
	if ( !getuid() )
		(void)nice( -40 ) ;
	/* Decode the flag arguments */
	flagdecode( argc, argv ) ;      
	/* Determine the terminal width */
	if ( !Flg.flg_w && !Flg.flg_N && !Flg.flg_i )
		termwidth() ;
	/* Open the cpu physical memory, kernel virtual memory and swap device*/
# ifdef KVM
	Flkvm = kvm_open( Flg.flg_s, Flg.flg_k, NULL, O_RDONLY, "sps" ) ;
# else
	if ( Flg.flg_k )
	{
		Flmem = openfile( Flg.flg_k ) ;
		Flkmem = Flmem ;
	}
	else
	{
		Flmem = openfile( FILE_MEM ) ;
		Flkmem = openfile( FILE_KMEM ) ;
		if ( !Flg.flg_o )
			Flswap = openfile( FILE_SWAP ) ;
	}
# endif
	if ( Flg.flg_i )
	{       /* -i flag for info file initialisation */
		initialise() ;          
		exit( 0 ) ;
	}
	/* Check that the information file is newer than the symbol and
	   password files, suggested by gregorio!mogul */
	fileinfo = Flg.flg_j ? Flg.flg_j : FILE_INFO ;
	filesymbol = Flg.flg_s ? Flg.flg_s : FILE_SYMBOL ;
	flinfo = openfile( fileinfo ) ;
	(void)fstat( flinfo, &sinfo ) ;
	if ( !stat( filesymbol, &ssymbol ) &&
		sinfo.st_mtime < ssymbol.st_mtime )
		fprintf( stderr,
	       "sps - WARNING: Info file `%s' is older than symbol file `%s'\n",
			fileinfo, filesymbol ) ;
# ifdef WARNPASSWD
	if ( !stat( FILE_PASSWD, &spasswd ) &&
		sinfo.st_mtime < spasswd.st_mtime )
		fprintf( stderr,
	       "sps - WARNING: Info file `%s' is older than passwd file `%s'\n",
			fileinfo, FILE_PASSWD ) ;
# endif
	/* Read the information file */
	if ( read( flinfo, (char*)&Info, sizeof( struct info ) )
	!= sizeof( struct info ) )
	{
		fprintf( stderr, "sps - Can't read info file `%s'", fileinfo ) ;
		sysperror() ;
	}
	(void)close( flinfo ) ;
	/* Find current tty status */
	ttystatus() ;                   
	/* Now that we know the available ttys, decode the flags */
	flagsetup() ;                   
	process = (struct process*)getcore(Info.i_nproc*sizeof(struct process));
# ifndef SUNOS40
	text = (struct text*)getcore( Info.i_ntext * sizeof( struct text ) ) ;
# endif
	do
	{       /* Read current process status */
# ifdef SUNOS40
		readstatus( process ) ;
		/* Select those processes to be listed */
		plist = needed( process ) ;
# else
		readstatus( process, text ) ;
		/* Select those processes to be listed */
		plist = needed( process, text ) ;
# endif
		/* Form a tree of listed processes */
		plist = mktree( process, plist ) ;
		if ( !Flg.flg_N )
		{       /* Print the processes */
			prheader() ;
			printall( plist, 0 ) ;
		}
		prsummary() ;
		(void)fflush( stdout ) ;
		if ( Flg.flg_r )        
		{       /* If repeating, again get tty status */
			ttystatus() ;
			if ( Flg.flg_rdelay )
# ifdef BSD42
				sleep( Flg.flg_rdelay ) ;
# else
				sleep( (int)Flg.flg_rdelay ) ;
# endif
		}
	} while ( Flg.flg_r ) ;
	exit( 0 ) ;
}
