# ifndef lint
static char SccsId[] =  "@(#)globals2.c	1.1\t10/1/88" ;
# endif

# include       "sps.h"

/* Read Only variables, global to the code of sps ... */

/* Null ttyline device ... */
struct ttyline                  Notty = { "  " } ;

/*
** The symbol table. For each address read from the kernel during
** initialisation, this table shows the following:
**      i.   the name of that symbol within the kernel ;
**      ii.  whether an extra indirection is needed through the kernel,
**           i.e. whether the value of that symbol should be obtained
**           rather than its address.
**      iii. where the obtained value/address is placed in the Info structure ;
**      iv.  whether the obtained value is associated with a reason for
**           a process wait state.
*/
/* The order of entries in this table is unimportant. */

extern struct info              Info ;

struct symbol   Symbollist[] =
{       
	/* Kernel addresses required in order to access process,
	   tty and upage information. All these addresses should be
	   located in the symbol file during initialisation. */
	{ "_proc",      1,  (caddr_t*)&Info.i_proc0,    (char*)0        },
	{ "_nproc",     1,  (caddr_t*)&Info.i_nproc,    (char*)0        },
# ifdef ULTRIX20
	{ "_gnode",     1,  (caddr_t*)&Info.i_inode0,   (char*)0        },
	{ "_ngnode",    1,  (caddr_t*)&Info.i_ninode,   (char*)0        },
# else
	{ "_inode",     1,  (caddr_t*)&Info.i_inode0,   (char*)0        },
	{ "_ninode",    1,  (caddr_t*)&Info.i_ninode,   (char*)0        },
# endif
# ifndef SUNOS40
	{ "_text",      1,  (caddr_t*)&Info.i_text0,    (char*)0        },
	{ "_ntext",     1,  (caddr_t*)&Info.i_ntext,    (char*)0        },
	{ "_swbuf",     1,  (caddr_t*)&Info.i_swbuf0,   (char*)0        },
	{ "_nswbuf",    1,  (caddr_t*)&Info.i_nswbuf,   (char*)0        },
	{ "_buf",       1,  (caddr_t*)&Info.i_buf0,     (char*)0        },
	{ "_nbuf",      1,  (caddr_t*)&Info.i_nbuf,     (char*)0        },
	{ "_ecmx",      1,  (caddr_t*)&Info.i_ecmx,     (char*)0        },
	{ "_Usrptmap",  0,  (caddr_t*)&Info.i_usrptmap, (char*)0        },
	{ "_usrpt",     0,  (caddr_t*)&Info.i_usrpt,    (char*)0        },
	{ "_dmmin",     1,  (caddr_t*)&Info.i_dmmin,    (char*)0        },
	{ "_dmmax",     1,  (caddr_t*)&Info.i_dmmax,    (char*)0        },
# endif
	{ "_cdevsw",    0,  (caddr_t*)&Info.i_cdevsw,   (char*)0        },
# ifdef BSD42
#  ifdef NFS
#   ifndef NOQUOTA
	{ "_dquot",     1,  (caddr_t*)&Info.i_quota0,   (char*)0        },
	{ "_ndquot",    1,  (caddr_t*)&Info.i_nquota,   (char*)0        },
#   endif
#  else
	{ "_quota",     1,  (caddr_t*)&Info.i_quota0,   (char*)0        },
	{ "_nquota",    1,  (caddr_t*)&Info.i_nquota,   (char*)0        },
#  endif NFS
	{ "_mbutl",     0,  (caddr_t*)&Info.i_mbutl,    (char*)0        },
# else
	{ "_hz",        1,  (caddr_t*)&Info.i_hz,       (char*)0        },
# endif BSD42
# ifdef CHAOS
	{ "_Chconntab", 0,  &Info.i_Chconntab,          (char*)0        },
# endif CHAOS
# ifdef SUNOS40
	{ "_maxmem",	1,  (caddr_t*)&Info.i_ecmx,	(char*)0	},
	{ "_segvn_ops",	0,  (caddr_t*)&Info.i_segvn_ops,(char*)0	},
	{ "_pty_softc",	0,  (caddr_t*)&Info.i_ptybase,	(char*)0	},
	{ "_npty",	1,  (caddr_t*)&Info.i_npty,	(char*)0	},
	{ "_streams",	0,  (caddr_t*)&Info.i_streams,	(char*)0	},
	{ "_streamsNSTREAMS",1,(caddr_t*)&Info.i_streamsNSTREAMS,(char*)0},
	{ "_Sysbase",	1,  (caddr_t*)&Info.i_sysbase,	(char*)0	},
# endif
	/* Kernel addresses associated with process wait states.
	   It is not important if some of these addresses are unresolved
	   at initialisation. */
# ifndef SUN
	{ "_fltab",     0,  &Info.i_waitstate[0],       "floppy"        },
	{ "_tu",        0,  &Info.i_waitstate[1],       "tu58"          },
	{ "_lp_softc",  0,  &Info.i_waitstate[3],       "printr"        },
# endif SUN
	{ "_bfreelist", 0,  &Info.i_waitstate[2],       "buffer"        },
	{ "_lbolt",     0,  &Info.i_waitstate[4],       "lbolt"         },
	{ "_runin",     0,  &Info.i_waitstate[5],       "runin"         },
	{ "_runout",    0,  &Info.i_waitstate[6],       "runout"        },
	{ "_ipc",       0,  &Info.i_waitstate[7],       "ptrace"        },
	{ "_u",         0,  &Info.i_waitstate[8],       "pause"         },
	{ "_freemem",   0,  &Info.i_waitstate[9],       "freemm"        },
	{ "_kernelmap", 0,  &Info.i_waitstate[10],      "kermap"        },
	{ "_cwaiting",  0,  &Info.i_waitstate[11],      "cwait"         },
# ifdef BSD42
	{ "_selwait",   0,  &Info.i_waitstate[12],      "select"        },
# endif BSD42
# ifdef CHAOS
	{ "_Chrfclist", 0,  &Info.i_waitstate[13],      "chrfc"         },
# endif
# ifndef SUN
	{ "_rhpbuf",    0,  &Info.i_waitstate[14],      "rhpbuf"        },
	{ "_rhtbuf",    0,  &Info.i_waitstate[15],      "rhtbuf"        },
	{ "_ridcbuf",   0,  &Info.i_waitstate[16],      "ridcbf"        },
	{ "_rikbuf",    0,  &Info.i_waitstate[17],      "rikbuf"        },
	{ "_rmtbuf",    0,  &Info.i_waitstate[18],      "rmtbuf"        },
	{ "_rrkbuf",    0,  &Info.i_waitstate[19],      "rrkbuf"        },
	{ "_rrlbuf",    0,  &Info.i_waitstate[20],      "rrlbuf"        },
	{ "_rrxbuf",    0,  &Info.i_waitstate[21],      "rrxbuf"        },
	{ "_rswbuf",    0,  &Info.i_waitstate[22],      "rswbuf"        },
	{ "_rtmbuf",    0,  &Info.i_waitstate[23],      "rtmbuf"        },
	{ "_rtsbuf",    0,  &Info.i_waitstate[24],      "rtsbuf"        },
	{ "_rudbuf",    0,  &Info.i_waitstate[25],      "rudbuf"        },
	{ "_rupbuf",    0,  &Info.i_waitstate[26],      "rupbuf"        },
	{ "_rutbuf",    0,  &Info.i_waitstate[27],      "rutbuf"        },
	{ "_rvabuf",    0,  &Info.i_waitstate[28],      "rvabuf"        },
	{ "_rvpbuf",    0,  &Info.i_waitstate[29],      "rvpbuf"        },
	{ "_chtbuf",    0,  &Info.i_waitstate[30],      "chtbuf"        },
	{ "_cmtbuf",    0,  &Info.i_waitstate[31],      "cmtbuf"        },
	{ "_ctmbuf",    0,  &Info.i_waitstate[32],      "ctmbuf"        },
	{ "_ctsbuf",    0,  &Info.i_waitstate[33],      "ctsbuf"        },
	{ "_cutbuf",    0,  &Info.i_waitstate[34],      "cutbuf"        },
# ifdef NFS
	{ "_async_bufhead", 0,  &Info.i_waitstate[35],  "async"		},
# endif
# else
	{ "_async_bufhead", 0,  &Info.i_waitstate[14],  "async"		},
	{ "_desktops",	0,  &Info.i_waitstate[15],	"dtops"		},
# endif SUN
# ifdef ULTRIX20
	{ "_async_bufhead", 0,  &Info.i_waitstate[35],  "async"		},
# endif
	{ (char*)0,     0,  (caddr_t*)0,                (char*)0        }
} ;
