.\"
.\" $Id: cserver.man,v 1.1 1992/05/13 02:45:38 proj Exp $
.\"
.TH CSERVER \  "13 May 1992"
.SH NAME
cserver \- To start the Chinese server.
.SH SYNOPSIS
cserver  [-f 
.I file
]  [-s 
.I file
]
.SH DEFAULT PATH
/usr/local/bin/cWnn4/cserver
.ad
.SH DESCRIPTION
During Chinese input, cserver provides the services (such as conversion 
services) and resources (such as dictionaries, grammar files etc.), 
required by the users (front-end processors).  

The input environment is provided by the front-end processor (cuum), 
which sends its request to the cserver, which subsequently performs the 
service and return the result back to the front-end processor.  

Normally, once the system is up, fork() will be executed and the server 
runs as a background process. The startup of cserver can be set in 
"/etc/rc" to be executed automatically in the Unix system.

When the "cserver" command is executed, all the settings in the 
initialization file "/usr/local/lib/wnn/zh_CN/cserverrc"  will be read 
and the corresponding initialization operations will be performed.

Besides, all resources such as dictionaries and usage frequency files of 
the clients will be maintained by the cserver.  Refer to cWnn manual 
for details on "cserverrc". 

If the user happens to start up cserver after it has already been started, 
an error message will be given.  Refer to cWnn manual for the error message.
.SH OPTIONS
.IP -f
.I file
.sp 0
.I file 
is the specified initialization file for the server.  If this 
option is not specified, the default initialization file
.sp 0
"/usr/local/lib/wnn/zh_CN/cserverrc" will be read. 
.IP -s 
.I file
.sp 0
.I file 
is the specified logfile of cserver.  All error messages will be 
directed to this specified logfile.  When 
.I file 
is specified as "-", 
(eg. cserver -s -), the error messages will be sent to the standard error 
output.
.SH NOTE
.IP 1.
The command options inside [ ] shown in the Command Format indicates that 
they are optional.   
.IP 2.
If they are not required,  "cserver" alone is sufficient to start up the 
Chinese server.

