/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
####################################################################
#
#	Below is system initialization code and tables.
#	The code builds the PRCB in memory, sets up the stack frame,
#	the interrupt, control, fault, and system procedure tables, and
# 	then vectors to a user defined routine.
#
####################################################################
	
# ------ declare the below symbols public

	.globl	start_ip
	.globl	_prcb_ram
	.globl	sys_proc_table
	.globl	_reinit_sysctl	# "reset command"

	.globl	_nindy_stack 	# used for NINDY commands
	.globl	_trap_stack	# used during fault handling
	.globl	_intr_stack	# used for interrupts
        .globl  _control_table  # 960CA control registers

	.text

        .align  4
sys_proc_table:
	.word	0			# Reserved  
	.word	0			# Reserved
	.word	0			# Reserved
	.word	(_trap_stack )		# Supervisor stack pointer      
	.word	0			# Preserved
	.word	0			# Preserved
	.word	0			# Preserved
	.word	0			# Preserved
	.word	0			# Preserved
	.word	0			# Preserved
	.word	0			# Preserved
	.word	0			# Preserved
	.word	(_console_io + 0x2)	# console I/O routines 
	.word	(_buffer_io + 0x2)	# file (buffered) I/O routines
	.word	(_lpt_io + 0x2)		# laser printer I/O routines
	.word	(_switch_stack_on_fault + 0x2)	# Fault Handler 
	.word	(_switch_stack_on_fault + 0x2)	# Trace Handler 
	.word	(_get_prcb + 0x2)	# Return PRCB 

# --- Processor starts execution at this spot after reset.
# ---
start_ip:
		mov	0, g14

# --
# --  Copy the .data area into RAM.  It has been packed
# --  in the EPROM after the code area, so call a routine to
# --  move it
		bal	_move_data_area


# --
# --   copy the interrupt table to RAM
# --
		lda	1024, g0	# load length of int. table
		lda	0, g4		# initialize offset to 0
		lda	_intr_table, g1	# load source 
		lda	intr_ram, g2	# load address of new table
		bal	move_data	# branch to move routine

# --
# --   copy the control table to RAM
# --
		lda	112, g0		# load length of int. table
		lda	0, g4		# initialize offset to 0
		lda	_rom_control_table, g1		# load source 
		lda	_control_table, g2	# load adderss of new table
		bal	move_data	# branch to move routine

# --
# -- Processor will copy PRCB to RAM space, located at _prcb_ram
# --
		lda	64, g0		# load length of PRCB
		lda	0, g4		# initialize offset to 0
		lda	rom_prcb, g1	# load source
		lda	_prcb_ram, g2	# load destination
		bal	move_data	# branch to move routine
# --
# --  fix up the PRCB to point to a new interrupt table
# --
		lda	intr_ram, g12	# load address
		st	g12,16(g2)	# store into PRCB

# --
# --  and change the PRCB to point to a new control table
# --
		lda	_control_table, g12	# load address
		st	g12,4(g2)	# store into PRCB

# 
# --  At this point, the PRCB, and interrupt table have 
# --  been moved to RAM.  It is time
# --  to issue the REINITIALIZE sysctl, which will start us anew with
# --  our RAM based PRCB.
# --  
#

_reinit_sysctl:
		ldconst 0x300, r4
		ldconst start_again_ip, r5
		ldconst _prcb_ram, r6
		sysctl	r4, r5, r6

# We should never get here....but just in case
stop:
		b	stop
# --
# --   Below is the software loop to move data
# --
move_data:	
		ldq	(g1)[g4*1], g8	  # load 4 words into g8
		stq	g8, (g2)[g4*1] 	  # store to RAM proc. block
		addi	g4,16, g4	  # increment index	
		cmpibg	g0,g4, move_data  # loop until done
		bx	(g14)

# --  The processor will begin execution here after being
# --  reinitialized.  We will now set up the stacks and continue.
start_again_ip:

#	Before call to main, we need to take the processor out
#	of the "interrupted" state.  In order to do this, we will
# 	execute a call statement, then "fix up" the stack frame
#	to cause an interrupt return to be executed.
#
		ldconst	64, g0
		addo	sp, g0, sp	# bump up stack to make
					# room for simulated
					# interrupt frame
		call	fix_stack	# routine to turn off int state
		lda	_nindy_stack,fp # set up user stack space
		lda	-0x40(fp), pfp	# load pfp (just in case)
		lda	0x40(fp), sp	# set up current stack ptr


		mov	 0, g14		# g14 used by C compiler
					# for arguement lists past
					# 13 arguements.
					# Initialize to 0
# --  CA A-step fix
		mov	g4, g4	

		call	_disable_ints	  # disable board interrupts

stack_fixed:
#
# --   call main code from here
#
# --   Note: This setup assumes a main module "main()" written in
# --   C.  Also, no opens are done for stdin, stdout, or stderr.
# --   If I/O is required, the devices would need to be opened
# --   before the call to main.

# --   CA A-step bug work around 
		mov	g0, g0	
		callx	 _main

# --   We should never get here, but just in case, a piece of 
# --	checking code
		b	stack_fixed

fix_stack:	flushreg
		or	pfp, 7, pfp	# put interrupt return
					# code into pfp
#
# 	we have reserved area on the stack before the call to this
#	routine.  We need to build a phony interrupt record here
# 	to force the processor to pick it up on return.  Also, we
# 	will take advantage of the fact that the processor will
#	restore the PC and AC to it's registers
#

		ldconst	0xd81f0002, g0  # the upper bits are for
					# the microcode interrupt
					# return
		st	g0, -16(fp)	# store contrived PC
		ldconst	0x3b001000, g0 	# set up arith. controls 
		st	g0, -12(fp)	# store contrived AC
		ret

# -- define RAM area to copy the PRCB  & interrupt table
# -- to after initial bootup
	.data
	.align 6
_prcb_ram:
	.space 64

intr_ram:
	.space 1028

        .align 6
_control_table:
        .space 112

	.align 6
_nindy_stack:			# reserved area for NINDY's stack use
	.space 0x800 		# this can be located anywhere in memory

_intr_stack:			# reserved area for the interrupt stack
	.space 0x200 		# this can be located anywhere in memory

_trap_stack:			#  Reserve stack space for 
	.space	0x800           #  fault (supervisor) stack

#
# the end
#
