/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
#include "defines.h"
#include "qt510.h"

unsigned char input_buffer[80];
unsigned char *input_ptr;

/****************************************/
/* init_console  			*/ 
/* 					*/ 
/* this routine initializes the 82510   */
/* for operation in the polled mode,    */
/* interrupts disabled.  It accepts an  */
/* integer designating the baud rate,   */
/* which is computed from the input     */
/* frequency				*/
/****************************************/
init_console(baud)
int baud;
{
unsigned char *port510;
unsigned char data;
		
	/* initialize the 82510 */
	
	output(BANK, WORK1);
	eat_time(1);
	output(ICM, 0x10);	/* software reset */
	eat_time(1);
	output(LCR, 0x03);	/* 8 bits, no parity */
	eat_time(1);
	output(MCR, 0x01);	/* enable DTR */
	eat_time(1);

	output(LCR, (input(LCR) | 0x80));	/* enable BAUD */
	eat_time(1);
	output(BAL, ((XTAL/(32*baud)) & 0xff ));	/* baud low */
	eat_time(1);
	output(BAH, (((XTAL/(32*baud)) & 0xff00) >> 8)); /* baud high */
	eat_time(1);
	output(LCR, (input(LCR) & 0x7f));	/* disable BAUD */
	eat_time(1);

	/* configure the silly BRGB port */

	output(BANK, MODM3);
	eat_time(1);
	output(CLCF, 0x50); /* source is BRGA */
	eat_time(1);
	output(BBCF, 0x00); /* tell BRGB to be a TIMER */
	eat_time(1);

	output(BANK, NAS0);	/* return to bank 0 for operation */
	eat_time(1);
	output(GER, 0x00);	/* no interrupts */
	eat_time(1);

	/* now initialize the character buffer pointer */
	input_ptr = input_buffer;
}

/****************************************/
/* Change Baud Rate                     */
/* 		           	        */
/*  for the serial device 		*/
/****************************************/
change_baud(baud)
int baud;
{
unsigned char data;
		
	output(LCR, (input(LCR) | 0x80));	/* enable BAUD */
	output(BAL, ((XTAL/(32*baud)) & 0xff ));	/* baud low */
	output(BAH, (((XTAL/(32*baud)) & 0xff00) >> 8)); /* baud high */
	output(LCR, (input(LCR) & 0x7f));	/* disable BAUD */

	/* configure the silly BRGB port */

	output(BANK, MODM3);
	output(CLCF, 0x50); /* source is BRGA */
	output(BBCF, 0x00); /* tell BRGB to be a TIMER */

	output(BANK, NAS0);	/* return to bank 0 for operation */
}

/************************************************/
/*  Csts - Character status			*/
/* 						*/
/* returns 0 if no character available at the  	*/
/* device, nonzero if a character is available	*/
/************************************************/
csts() 
{
	return (input(LSR) & 0x01); 	/* return status */ 
}

/************************************************/
/* Ci						*/
/* 						*/
/* waits for character to become available, then*/
/* returns character to calling procedure.	*/
/************************************************/
unsigned char ci()
{

/* check for input buffer empty.  If not, get character from there. */
	if (input_ptr != input_buffer)	/* compare pointers */
		return(*input_ptr--);
	else 
	/* get character from keyboard */
	{
		while (!(input(LSR) & 0x01)); 	/* wait for char */
		return(input(RXD));  		/* return data */
	}
}

/************************************************/
/* Buffered Co					*/
/* 						*/
/* waits for 82510 fifo to become available,    */
/* then xmits the character. Checks for XON/XOFF*/
/************************************************/
buffco(ch)
unsigned char ch;
{
	unsigned char temp_char;

	/* we need to check for flow control before transmitting */
	if (csts())
	{
	/* there is a character at the input queue, read it */
		temp_char = ci();
		if (temp_char != XOFF) /* somebody sent us a char,
					   buffer it */
		{
			if (((int)input_buffer + sizeof(input_buffer))
			      <= (int)input_ptr) 
				*input_ptr++ = temp_char;
		}
		else /* character is XOFF , wait for XON */
			while (ci() != XON);
	}
	/* transmit character */
	while (!(input(LSR) & 0x20)); 	/* wait for XMIT */
	output(TXD, ch);  		/* output char */
}

/************************************************/
/* Co						*/
/* 						*/
/* waits for 82510 fifo to become available,    */
/* then xmits the character.			*/
/************************************************/
co(ch)
unsigned char ch;
{
	/* transmit character */
	while (!(input(LSR) & 0x20)); 	/* wait for XMIT */
	output(TXD, ch);  		/* output char */
}

/***************************************/
/* Access                              */
/*                                     */
/* determines accessibility of a file  */
/***************************************/
f_access(path, mode)
char *path;
int mode;
{
	return (ERROR);
}

/***************************************/
/* Close                               */
/*                                     */
/* closes a file descriptor            */
/***************************************/
f_close(fd)
int fd;
{
	return (ERROR);
}

/***************************************/
/* Creat                               */
/*                                     */
/***************************************/
f_creat(path, mode)
char *path;
int mode;
{
	return (ERROR);
}

/***************************************/
/* Lseek                               */
/*                                     */
/* moves the file pointer w/in the file*/
/***************************************/
f_lseek(fd, offset, how)
int fd;
long offset;
int how;
{
	return (ERROR);
}

/***************************************/
/* Open                                */
/*                                     */
/* opens a file for read/write         */
/***************************************/
f_open(path, flag, mode)
char *path;
unsigned int flag;
int mode;
{
	return (ERROR);
}

/***************************************/
/* System                              */
/*                                     */
/***************************************/
f_systemd(string)
char *string;
{
	return (ERROR);
}

/***************************************/
/* Stat                                */
/*                                     */
/***************************************/
f_stat(path, buff)
char *path;
struct st *buff;
{
	return (ERROR);
}

/***************************************/
/* Time                                */
/*                                     */
/***************************************/
f_time()
{
	return (ERROR);
}

/***************************************/
/* Umask                               */
/*                                     */
/***************************************/
f_unmask(mode)
int mode;
{
	return (ERROR);
}

/***************************************/
/* Unlink                              */
/*                                     */
/***************************************/
f_unlink(path)
char *path;
{
	return (ERROR);
}

/***************************************/
/* Read                                */
/*                                     */
/***************************************/
f_read(fd, buff, bytes, buffnum)
int fd;
unsigned char *buff;
unsigned bytes;
int buffnum;
{
	return (ERROR);
}

/***************************************/
/* Write                               */
/*                                     */
/***************************************/
f_write(fd, buff, bytes, buffnum)
int fd;
unsigned char *buff;
unsigned bytes;
int buffnum;
{
	return (ERROR);
}
