/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
#include "defines.h"
#include "globals.h"
#include "regs.h"

/************************************************/
/* Get Command               			*/
/*                           			*/
/* This function picks up the command from the  */
/* command line, putting the command line into  */
/* linebuff[] in lower case and the first two   */
/* letters of the command in cmd[] 		*/
/************************************************/
get_cmd()
{
int count;
int valid;
unsigned char c;
int index, i, j;


	valid = FALSE;
	count = 0;
	cmd[0] = NUL;
	index = 0;

	c = ci();

/* eat leading whitespace */
	while ((c == CR) || (c == LF)) {
		co(c);
		out_prompt();
		c = ci();
	}
	while ((c == SP) || (c == TAB) || (c == BS) || (c == DEL)) {
		if ((c == BS) || (c == DEL)) {
			if (count > 0) {
				count--;
				backspace();
			}
		}
		else {
			co(c);
			count++;
		}
		while (((c = ci()) == CR) || (c == LF)) {
			count = 0;
			co(c);
		 	out_prompt();
		}
	}

/* found a non-blank character - time to begin parsing */

	while (!valid) {
		switch (c) {
#ifdef GDB
			case DLE:
				/* gdb command.  Discard anything else we may
				 * have seen to this point --  this helps us
				 * get back in sync with host in case of error.
				 */
				cmd[0] = c;
				gdb = TRUE;
				return;
#endif
			case BS:
			case DEL:
				/* remove char from buffer */
				if (index > 0) {
					index--;
					linebuff[index] = NUL;
					backspace();
					count--;
				}
				else

				/* if buffer empty but leading
				   whitespace back over that */
					if (count > 0) {
						count--;
						backspace();
					}

				/* if nothing left on input line, 
				   ignore backspace */
				c = ci();
				break;
			case SP:
			case TAB:
				co(c);
				linebuff[index++] = c;
				count++;
				c = ci();
				break;
			case CR:
			case LF:
				co(c);
				valid = TRUE;
				linebuff[index] = NUL;
				cmd[0] = linebuff[0];
				cmd[1] = linebuff[1];
				cmd[2] = NUL;
				if (cmd[0] == '?')
					cmd[1] = NUL;
				break;
			default:
				/* other character - accept as valid */
				co(c);
				linebuff[index++] = tolower(c);
				count++;
				c = ci();
				break;
		}
	} 
	/* add to history buffer if not a history command */
	if (cmd[0] != '.') {
		for (i=0; i<LINELEN; i++)
			histbuff[0][i] = linebuff[i];
	}
}

/************************************************/
/* Backspace routine            		*/
/*                           			*/
/************************************************/
backspace()
{
	co(BS);
	co(SP);
	co(BS);
}

/************************************************/
/* Get Word                       	 	*/
/*                           			*/
/* Get words from the command line which follow */
/* the command.  The position of the word is    */
/* sent in in wordnum (ie. 2nd, 3rd). The func- */
/* tion of the word is determined at the end of */
/* this routine and the proper value returned   */
/************************************************/
unsigned get_word(cycles, reg, wordnum, traceflag)
int *cycles, *reg;
int wordnum, traceflag;
{
int i, index, cnt, none, num, valid;
unsigned addr;
unsigned char c;
unsigned char *buff, *cycbuff;
unsigned char s[16], cyc[8];
int noaddress;			/* flag for no address given */

	errno = FALSE;
	buff = s;
	*buff = NUL;
	none = TRUE;
	index = 0;
	cyc[0] = NUL;
	noaddress = FALSE;

	/* read past wordnum-1 to first space or determine no address
	   is given */
	for (i=0; i<wordnum-1; i++) {
		/* read word */
		while (((c = linebuff[index++]) != NUL) && 
			(c != SP) && (c != TAB));
		if (c == NUL) break;
		/* read to next non-blank character */
		while (((c = linebuff[index++]) == SP) || (c == TAB));
	}

	if (c != NUL) {
		/* otherwise, word is given, pick it out */
		cnt = 0;
		while ((c != NUL) && (c != SP) && (c != TAB)) {
			none = FALSE;
			*buff++ = c;
			if ((cnt++ == 1) && ((c == 'x') || (c == 'X')))
				*buff-- = NUL;
			if (c == '#') {
				buff--;
				*buff = NUL;
				buff = cyc;
				if (cnt == 1) 
					noaddress = TRUE;
				/* no address was given, only a count */
			}
			c = linebuff[index++];
		}
	}
	if (!none) { /* word was there, parse it */
		*buff = NUL;

		/* check for trace control word */
		if (traceflag) {
			if ((num = checktrace(s)) == ERROR)
				errno = TRUE;
			return(num);
		}

		/* check for valid register */
		if (checkreg(s, reg) != ERROR) {
			errno = TRUE;
			return (ERROR);
		}
		*reg = FALSE;

		/* check for valid number of cycles */
		*cycles = atod(cyc);
		if ((errno == TRUE) || (*cycles == 0))
			*cycles = 1;

		if (noaddress) {
			errno = TRUE;
			return(ERROR);
		}

		/* check for valid address */
		addr = atoh(s);
		if (errno == FALSE)
			return(addr);
	}
	/* no word given */
	errno = TRUE;
	return (ERROR);
}

/************************************************/
/* Get Data                       	 	*/
/*                           			*/
/* This routine gets data from the input after  */
/* the command line has been terminated.  Used  */
/* for retrieving data to modify registers or   */
/* memory.					*/
/************************************************/
unsigned get_data(valid)
int *valid;
{
int count;
unsigned char c;
int index;
unsigned char databuff[16];
unsigned int data;

	*valid = FALSE;
	count = 0;
	index = 0;

/* if no data found, return */
	if (((c = ci()) == CR) || (c == LF)) {
		print ("data not found");
		co(c);
		return (ERROR);
	}
/* eat leading whitespace */
	while ((c == SP) || (c == TAB) || (c == BS) || (c == DEL)) {
		if ((c == BS) || (c == DEL)) {
			if (count > 0) {
				count--;
				backspace();
			}
		}
		else {
			co(c);
		 	count++;
		}
		if (((c = ci()) == CR) || (c == LF)) {
			print ("data not found");
			co(c);
			return (ERROR);
		}
	}

/* found a non-blank character - time to begin parsing */
	while (! *valid) {
		switch (c) {
			case 'x':
			case 'X':
				index = 0;
				databuff[index] = NUL;
				break;
			case BS:
			case DEL:
				/* remove char from buffer */
				if (index > 0) {
					index--;
					databuff[index] = NUL;
					backspace();
					count--;
				}
				else

				/* if buffer empty but leading
				   whitespace back over that */
					if (count > 0) {
						count--;
						backspace();
					}

				/* if nothing left on input line, 
				   ignore backspace */
				c = ci();
				break;
			case SP:
			case TAB:
				co(c);
				databuff[index] = NUL;
				count++;
				c = ci();
				break;
			case CR:
			case LF:
				co(c);
				databuff[index] = NUL;
				*valid = TRUE;
				break;
			default:
				/* other character - accept as valid */
				co(c);
				databuff[index++] = c;
				count++;
				c = ci();
				break;
		}
	} 
	data = atoh(databuff);

	return(data);
}

/************************************************/
/* Check String For Register 			*/
/*                           			*/
/************************************************/
checkreg(s, reg)
unsigned char s[];
int *reg;
{
int num;
	/* check for register set */
	if ((s[0] == 'g') || (s[0] == 'r') || (s[0] == 'p') ||
	    (s[0] == 's') || (s[0] == 't') || (s[0] == 'i') ||
	    ((s[0] == 'f') && (s[1] == 'p')) || 
	    ((s[0] == 'a') && (s[1] == 'c'))) {
		if ( (num = get_regnum(s)) == ERROR )
			return(ERROR);
		if (*reg)
			mod_register(s,num);
		else
			disp_register(s,num);
		*reg = TRUE;
		return (TRUE);
	}
	else  {
		*reg = FALSE;
		return (ERROR);
	}
}

/************************************************/
/* Check String For Trace Control Word		*/
/************************************************/
checktrace(s)
unsigned char s[];
{
unsigned char tmp[3]; 	/* so that s is not trashed */

	tmp[0] = s[0];
	tmp[1] = s[1];
	tmp[2] = '\0';
	if (!strcmp(tmp, "br"))		/* branch trace */
		return(BRANCH);
	if (!strcmp(tmp, "ca"))		/* call trace */
		return(CALL);
	if (!strcmp(tmp, "re"))		/* return trace */
		return(RET);
	if (!strcmp(tmp, "su"))		/* supervisor trace */
		return(SUP);
	if (!strcmp(tmp, "of"))		/* trace off */
		return(OFF);
	if (!strcmp(tmp, "on"))		/* trace on */
		return(ON);
	
	print ("\n\r Invalid trace option");
	return(ERROR);
}
