/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
#include "defines.h"
#include "globals.h"
#include "regs.h"
#include "version.h"

#ifdef GDB
char gdb = FALSE;   /* Set to TRUE after the first GDB command is
		     * seen.  Thereafter, NINDY operates in "gdb mode"
		     * exclusively.  Otherwise, NINDY assumes it is
		     * interacting directly with a humanoid.
		     */
#endif

/************************************************/
/* Monitor Shell             			*/
/************************************************/
monitor (monitor_flag)
int monitor_flag;
{
int x;
	while (TRUE) {
		if (monitor_flag) {
			prompt[0] = '-';
			prompt[1] = '>';
		}
		else {
			prompt[0] = '=';
			prompt[1] = '>';
		}
		out_prompt();
		get_cmd();
#ifdef GDB
		if ( cmd[0] == DLE ){
			/* Must be a GDB command */
			if ( gdb_cmd() ){
				/* Skip rest of loop if processing
				 * successfully completed
				 */
				continue;
			}
		}
#endif
		if (cmd[0] == '.')  {
			cmd[0] = histbuff[0][0];
			cmd[1] = histbuff[0][1];
			for (x=0; x<LINELEN; x++)
				linebuff[x] = histbuff[0][x];
			print_hist(0);
		}
		if (!strcmp(cmd, "st")) {
			set_trace_step();
			go(monitor_flag);
			if (monitor_flag) 
				return;
		}
		else if (!strcmp(cmd, "go")) {
			go(monitor_flag);
			if (monitor_flag) 
				return;
		}
		else if (!strcmp(cmd,"tr"))
			trace();
		else if (!strcmp(cmd,"do"))
			download(monitor_flag);
		else if (!strcmp(cmd,"ef"))
			erase_flash();
		else if (!strcmp(cmd,"cf")) {
			x = init_flash();
			check_flash(x);
		}
		else if (!strcmp(cmd,"df"))
			down_flash(monitor_flag);
		else if (!strcmp(cmd,"rs"))
			reset();
		else if (!strcmp(cmd,"ve"))
			out_message();
		else if (!strcmp(cmd,"mo"))
			modify(INT);
		else if (!strcmp(cmd,"mb"))
			modify(BYTE);
		else if (!strcmp(cmd,"fr"))
			disp_float(INT);
		else if (!strcmp(cmd,"fl"))
			disp_float(LONG);
		else if (!strcmp(cmd,"fx"))
			disp_float(EXTENDED);
		else if (!strcmp(cmd,"db"))
			display(BYTE);
		else if (!strcmp(cmd,"ds"))
			display(SHORT);
		else if (!strcmp(cmd,"di"))
			display(INT);
		else if (!strcmp(cmd,"dd"))
			display(LONG);
		else if (!strcmp(cmd,"dt"))
			display(TRIPLE);
		else if (!strcmp(cmd,"dq"))
			display(QUAD);
		else if (!strcmp(cmd,"ba"))
			baud();
		else if (!strcmp(cmd,"re"))
			display_regs();
		else if (!strcmp(cmd,"bd"))
			databreak();
		else if (!strcmp(cmd,"ed"))
			delete_data();
		else if (!strcmp(cmd,"br"))
			breakpt();
		else if (!strcmp(cmd,"de"))
			delete();
		else if (!strcmp(cmd,"da"))
			dasm();
		else if ((!strcmp(cmd,"he")) || (!strcmp(cmd,"?")))
			help();
		else if (cmd[0] == NUL);
		else 
			print("\n\r Invalid command");
	}
}

/************************************************/
/* Output Prompt             			*/
/************************************************/
out_prompt()
{
	int i;

#ifdef GDB
	if ( gdb && !gdb_debug ){
		/* No prompts if we're talking to gdb on a remote host */
		return;
	}
#endif

	print("\n\r");
	for (i=0; i<PROMPTLEN; i++) 
		co(prompt[i]);
}

/************************************************/
/* Go                        			*/
/*                           			*/
/************************************************/
go(monitor_flag)
int monitor_flag;
{
int i, reg;
long addr;

#ifdef GDB
	if ( !gdb || gdb_debug ) /* No prompts when talking to a remote host */
#endif
	print("\n\r");
	addr = get_word(&i, &reg, TWO, FALSE);

	if ( monitor_flag ){		/* continuing from fault */

		if ( errno == FALSE ){
			/* get_word() returned an address */
			register_set[REG_IP] = addr;
		}
 		/* We will now return back through the monitor
		 * entry point, the fault handler, and finally
		 * the application program.
		 */

	} else {			/* fresh start, NOT continuing */

		if ( errno == TRUE ){
			/* get_word() didn't return an address */
			addr = aoutbuf.aouthead.start_addr;
		}
		register_set[REG_IP] = addr;
		begin(addr);
	}
}

/************************************************/
/* Output the Intro message     		*/
/*                           			*/
/************************************************/
out_message()
{
#ifdef GDB
/* no greeting if we're talking to gdb on a remote host */
	if ( gdb && !gdb_debug ){
		return;
	}
#endif
 
	print ("\r\n");
	print ("                    NINDY monitor\r\n");
	print ("               	    Version ");
	print (VERSION);
	print ("\r\n\n");
 	print ("          Copyright (c) 1989, Intel Corporation\r\n");
}

/************************************************/
/* Help                         		*/
/*                           			*/
/************************************************/
help()
{
	print ("\n\r Available commands are:\r\n");
	print ("cf               - check if flash is blank\r\n");
	print ("df               - download to flash using xmodem\r\n");
	print ("ef               - erase flash\r\n");
	print ("rs		 - reset board\n\r");
	print ("do               - download using xmodem\r\n");
	print ("go (address)     - go from start, or continue from breakpoint\r\n");
	print ("tr option on/off - turn on or off one of the following trace options:\n\r");
	print ("		   branch, call, return or supervisor call\n\r");
	print ("fr address#times - display one or more real (32 bit) floating\n\r");
	print ("                   point numbers\n\r");
	print ("fl address#times - display one or more long real (64 bit)\n\r");
	print ("                   floating point numbers\n\r");
	print ("fx address#times - display one or more extended real (80 bit)\n\r");
	print ("                   floating point numbers\n\r");
	print ("da address#times - disassemble one or more instructions\n\r");
	print ("db address#bytes - display one or more bytes\n\r");
	print ("ds address#shrts - display one or more shorts\n\r");
	print ("di address#words - display one or more words\n\r");
	print ("dd address#times - display one or more sets of double words\n\r");
	print ("dt address#times - display one or more sets of triple words\n\r");
	print ("dq address#times - display one or more sets of quad words \n\r");
	print ("re               - dump contents of registers\n\r");
	print ("di reg 	         - display one register, where reg can be any register\n\r");
	print ("mo reg	         - modify a register. Reg can NOT be fp0-fp3,\n\r");
	print ("                   pc, ac, or tc\n\r");
	print ("mo address#words - modify one or more words in memory\n\r");
	print ("mb address	 - modify a byte in memory (does not read byte first)\n\r");
	print ("ba rate          - change current baud rate \n\r");
	print ("                   Choices are: 1200 2400 9600 19200 38400\n\r");
	print ("st (address)	 - single step through program\n\r");
	print ("br address       - set instruction break. If no address is given, all of \n\r");
	print ("		   the current breakpoints are displayed\n\r");
	print ("de address       - delete the specified instruction breakpoint\n\r");
	print ("bd address       - set data breakpoint. If no address is given, all of \n\r");
	print ("		   the current breakpoints are displayed\n\r");
	print ("ed address       - delete the specified data breakpoint\n\r");
	print ("ve               - print out version header\n\r");
	print (". 		 - repeat previous instruction\n\r");
}

/************************************************/
/* Print out command history			*/
/************************************************/
print_hist(flag)
int flag;
{
	print ("\n\r");
	print (histbuff[flag]);
}
