/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
#include "defines.h"
#include "globals.h"
#include "regs.h"
int flashtype;

/************************************************/
/* Download                  			*/
/*                           			*/
/************************************************/
download(monitor_flag)
int monitor_flag;
{
int term;
#ifdef GDB
	if ( gdb ){
		/* No prompts if we're talking to gdb on a remote host */
		parse_init();
		term = receive_xmodem(RAM);
		if (term != ERROR)
			parse_terminate();
		return;
	}
#endif
	if (monitor_flag) {	 /* program already running */
		print ("\n\r Already running program, new download");
		print ("\n\r not allowed. Reset board or allow program");
		print ("\n\r to complete to download new program.");
	}
	else {
		print ("\n\r Downloading");
		parse_init();
		print ("\n\r Receiving file\n\r");
		if (receive_xmodem(RAM) == ERROR)
			print ("\n\n\r Download failed\n\r");
		else
			parse_terminate();
	}
}

/****************************************/
/* COFF Parser 				*/
/* 					*/
/* The parser state is set to initial-  */
/* ization state			*/
/****************************************/
parse_init()
{
	parser_state = P_INIT;
}

/****************************************/
/* COFF Parser 				*/
/* 					*/
/* The coff file is parsed as each      */
/* packet is received.  The state of    */
/* parsing is saved between each packet */
/* so that the parser can be reentered  */
/****************************************/
parse_coff()
{
int i, j, n;

switch (parser_state) {

case P_INIT: /* transfer buffer to file header info */

	buffindex = FHDRSIZE;
	for (i=0; i<buffindex; i++)
		filebuf.buff[i] = buff[i];

	/* transfer buffer to optional info 
	   only if AOUT is present as OHDR */

	if (filebuf.filehead.opt_hdr >= AOUTSIZE)  
		for (i=0; i<AOUTSIZE; i++)
			aoutbuf.buff[i] = buff[buffindex + i];
	
	buffindex += filebuf.filehead.opt_hdr;

	/* set up start section and start word */
	current_section = 0;
	current_byte = 0;

	if (buffindex > XMODSIZE)
		/* sorry, this condition shouldn't happen */
		return(ERROR);
	else if (buffindex == XMODSIZE)	{
		parser_state = P_SECT;
		return(0);
	}
	
	/* most likely case is some section stuff in first buffer */
	
case P_SECT:
	
	/* if coming from above ... */
	if (parser_state == P_SECT) buffindex = 0;
	/* and away we go......... */

	for (i = current_section; i < filebuf.filehead.num_secs; i++) {
		for (j=current_byte; j < SHDRSIZE; j++) {
			if (buffindex == XMODSIZE) {
				/* done with packet, save state */
				current_byte = j;
				current_section = i;
				parser_state = P_SECT;
				return (0);
			}
			else {
				/* need to process byte */
				sectbuf[i].buff[j]= buff[buffindex];
				buffindex++;
			}
		}
		current_byte = 0;
	}
	/* done with headers, so continue on raw data */
	current_section = 0;
	current_byte = 0;

case P_RAWDATA:
	
	/* if code is from above, then don't reset buffer */
	if (parser_state == P_RAWDATA) buffindex = 0;

	/* transfer raw data to respective sections */
	for (i=current_section; i<filebuf.filehead.num_secs; i++) {
		if (current_byte == 0)
			secbuffptr = 
			    (unsigned char *)sectbuf[i].secthead.p_addr;
		else 
			secbuffptr = secbuffptr_holder; /* restore */

		if (sectbuf[i].secthead.data_ptr != 0) {
		 	for (j=current_byte; 
				j<sectbuf[i].secthead.sec_size; j++) {

				if (buffindex == XMODSIZE) {
				/* done with packet, save state */
					current_byte = j;
					current_section = i;
					parser_state = P_RAWDATA;
					secbuffptr_holder = secbuffptr;
					return (0);
				}
				else {
					/* need to process byte */
				      	*secbuffptr++ = 
						buff[buffindex++];
				}
			}
			current_byte = 0;
		}
	}
	parser_state = P_DONE;


case P_DONE:
	/* YEA!  we're done! */

		return (0);
		break;

}
}

/*****************************************/
/* COFF Parser Termination		 */
/* 					 */
/* The transmission of data is completed */
/* and the uninitialized data section is */
/* initialized to zeros 		 */
/*****************************************/
parse_terminate()
{
	eat_time(2);

#ifdef GDB
	if ( gdb ){
		/* No prompts if we're talking to gdb on a remote host */
		return;
	}
#endif
	print("\n\r -- Download complete --\n\r");
	print("\n\r    Start address is :");
	out_hex(aoutbuf.aouthead.start_addr, INT, FALSE);
	print("\n\r");
}

/****************************************/
/* Receive Xmodem Transmission		*/
/* 					*/
/* this function is in charge of the    */
/* handshaking protocol between the     */
/* monitor and Xmodem.			*/
/****************************************/
receive_xmodem(type)
int type;
{
int 	checksum,   	/* packet checksum */
	firstchar,  	/* first character of a packet */
	sectnum,    	/* number of last received packet */
			/* (modulo 128) */
    	sectcurr,   	/* 2nd byte of packet--should be packet */
			/* number (mod 128) */
    	sectcomp,   	/* 3rd byte of packet--should be complement */
			/* of sectcurr */
    	errors,     	/* running count of errors (reset when */
			/* 1st packet starts */
    	errorflag,  	/* set true when packet (or 1st char */
			/* of putative packet) is invalid */
    	fatalerror, 	/* set within main "read-packet" */
			/* Do-While when bad error found */
    	inchecksum, 	/* incoming checksum or CRC */
    	bufsize;    	/* packet size (128 or 1024) */
long 	recvsectcnt;   	/* running sector count (128 byte sectors) */
int 	bufctr; 	/* number of real chars in read packet */

    	fatalerror = FALSE;
    	sectnum = errors = recvsectcnt = 0;
    	bufsize = 128;

    	eat_time(4);
    	co(NAK);	/* send NAK to start sequence */


    	/* start of MAIN Do-While loop to read packets */
	do {	
		errorflag = FALSE;

        	/* start by reading first byte in packet */
        	do { 	
            		firstchar = readbyte(6);
            	} while ((firstchar != SOH) 
                	&& (firstchar != EOT) 
                	&& (firstchar != ACK || recvsectcnt > 0) 
                	&& (firstchar != TIMEOUT) 
				/* timeout returned by read */
			&& (firstchar != CAN));

        	if (firstchar == EOT) { 	/* check for REAL EOT */
            		if ((firstchar = readbyte(1)) != TIMEOUT) {
				if (firstchar != EOT) {
                			firstchar = TIMEOUT;
                			errorflag = TRUE;
				}
                	}
			else
				firstchar = EOT;
            	}

        	if (firstchar == TIMEOUT) {	/* timeout? */
                	errorflag = TRUE;
            	}

        	if (firstchar == CAN) { 	/* bailing out? */
            		if ((readbyte(3) & 0x7f) != CAN)
                		errorflag = TRUE;
            	}

        	if (firstchar == SOH) {	/* start reading packet */
            		bufsize = 128;
	    		sectcurr = readbyte(3);
	    		sectcomp = readbyte(3);

			/* is packet number checksum correct? */
			if ((sectcurr + sectcomp) == 0xff) {

			    /* is packet number correct? */
			    if (sectcurr == ((sectnum+1) & 0xff)) {

/* Read, process and calculate checksum for a buffer of data */

			    	if (readbuf(bufsize,3,&checksum,&bufctr)
				   	!= TIMEOUT) {

		    		    /* verify checksum or CRC */
				    /* get simple 8-bit checksum */
			    	    inchecksum = readbyte(3);  

				/* good checksum, hence good packet */
					if (inchecksum == checksum) {
				    	    errors = 0;
				    	    recvsectcnt += 1;
				    	    sectnum = sectcurr; 
					    if (type == FLASH) {
#ifdef QT960
				    	    if (f_parse_coff() != 0) {
					    	co(CAN); 
						co(CAN); 
						co(CAN);
						return (ERROR);
					    }
				        /* ACK the received packet */
				    	    else
						co(ACK);
#endif
					    }
					    else {
				    	    if (parse_coff() != 0) {
					    	co(CAN); 
						co(CAN); 
						co(CAN);
						return (ERROR);
					    }
				        /* ACK the received packet */
				    	    else
						co(ACK);
					    }
				        }

/* Start handling various errors and special conditions */

				else {	/* bad checksum */
				    errorflag = TRUE;
				}
                            }
			    else {	/* read timeout */
				errorflag = TRUE;
			    }
			}

			/* duplicate sector? */
			else if (sectcurr == sectnum) {
				while (readbyte(3) != TIMEOUT);
				co(ACK);
			}

			/* no, real phase error */
			else {
			    errorflag = TRUE;
			    fatalerror = TRUE;
			    co(CAN); 
			    co(CAN); 
			    co(CAN);
			    return (ERROR);
			}
		    }

		    /* bad packet number checksum */
		    else {
		    	errorflag = TRUE;
		    }
	        }           /* END reading packet loop */
    
		/* check on errors or batch transfers */
		if ((errorflag && !fatalerror) || recvsectcnt == 0) {  
	    	    	if (errorflag)
	        		errors++;
	    		if (recvsectcnt != 0)  
		    /* wait for line to settle if not beginning */
		    		while (readbyte(3) != TIMEOUT);
            	    	co(NAK);
	        }
	} while ((firstchar != EOT) && 
		(errors < ERRORMAX) && 
		(! fatalerror));   /* end of MAIN Do-While */

	/* normal exit */
	if ((firstchar == EOT) && (errors < ERRORMAX)) {
		co(ACK);
	    	return(0);
	}
	else { 	/* error exit */
		if (recvsectcnt != 0) {
			co(CAN); 
			co(CAN); 
			co(CAN);
		}
		return (ERROR);
	}
}

/************************************************/
/* read buffer                                  */
/*                                              */
/* get a buffer (length bufsize) from data      */
/* stream -- timeout if "seconds" elapses. 	*/
/************************************************/
readbuf(bufsize, seconds, checksum, bufctr)
int 	bufsize,	/* number of chars to be read */
	seconds, 	/* timeout period for each read */
	*checksum, 	/* pointer to checksum value */
	*bufctr;	/* length of actual data string in buffer */
{
int count;		 	/* characters read */
register unsigned char c;	/* character being processed */
register unsigned short chksm;	/* working copy of checksum */
int j, k;			/* loop index */

	chksm = 0;

	for (count=0; count<bufsize; count++) {

		/* read however many chars are waiting */
		if ((c=readbyte(seconds)) == TIMEOUT )
			return(TIMEOUT); /* abort operation */

		/* now process part of packet we just read */
		buff[count] = c;
	       	chksm = ((chksm+c) & 0xff);
	}

	*checksum = chksm;
	*bufctr = count;
	return(0);
}
#ifdef QT960
/****************************************/
/* COFF Parser Initialization for FLASH */
/* 					*/
/* The parser state is set to initial-  */
/* ization state.  Returns error if 	*/
/* flash not programmable  		*/
/****************************************/
f_parse_init()
{
	flashtype = init_flash ();
	if (flashtype == ERROR) 
		return (ERROR);
	if (!check_flash(flashtype)) 
		print ("\n\r Flash is not blank, programming anyway");
	parser_state = P_INIT;
	return(flashtype);
}

/****************************************/
/* COFF Parser for FLASH		*/
/* 					*/
/* Flash Programming Algorithm 		*/
/* Copyright (c) 1988, Intel Corporation*/
/* All Rights Reserved                 	*/
/* 					*/
/* The coff file is parsed as each      */
/* packet is received.  The state of    */
/* parsing is saved between each packet */
/* so that the parser can be reentered  */
/****************************************/
f_parse_coff()
{
int i, j, n, size, a, b;
unsigned char *b_ptr;

switch (parser_state) {

case P_INIT: /* transfer buffer to file header info */

	buffindex = FHDRSIZE;
	for (i=0; i<buffindex; i++)
		filebuf.buff[i] = buff[i];

	/* transfer buffer to optional info 
	   only if AOUT is present as OHDR */

	if (filebuf.filehead.opt_hdr >= AOUTSIZE)  
		for (i=0; i<AOUTSIZE; i++)
			aoutbuf.buff[i] = buff[buffindex + i];
	
	buffindex += filebuf.filehead.opt_hdr;

	/* set up start section and start word */
	current_section = 0;
	current_byte = 0;

	if (buffindex > XMODSIZE)
		/* sorry, this condition shouldn't happen */
		return(ERROR);
	else if (buffindex == XMODSIZE)	{
		parser_state = P_SECT;
		return(0);
	}
	
	/* most likely case is some section stuff in first buffer */
	
case P_SECT:
	
	/* if coming from above ... */
	if (parser_state == P_SECT) buffindex = 0;
	/* and away we go......... */

	for (i = current_section; i < filebuf.filehead.num_secs; i++) {
		for (j=current_byte; j < SHDRSIZE; j++) {
			if (buffindex == XMODSIZE) {
				/* done with packet, save state */
				current_byte = j;
				current_section = i;
				parser_state = P_SECT;
				return (0);
			}
			else {
				/* need to process byte */
				sectbuf[i].buff[j]= buff[buffindex];
				buffindex++;
			}
		}
		current_byte = 0;
	}
	/* done with headers, so continue on raw data */
	current_section = 0;
	current_byte = 0;

case P_RAWDATA:
	
	/* if code is from above, then don't reset buffer */
	if (parser_state == P_RAWDATA) buffindex = 0;

	/* transfer raw data to respective sections */
	for (i=current_section; i<filebuf.filehead.num_secs; i++) {
		if (current_byte == 0)
			secbuffptr = 
			    (unsigned char *)sectbuf[i].secthead.p_addr;
		else 
			secbuffptr = secbuffptr_holder; /* restore */

		if (sectbuf[i].secthead.data_ptr != 0) {
		 	for (j=current_byte; 
				j<sectbuf[i].secthead.sec_size; j++) {

				if (buffindex == XMODSIZE) {
				/* done with packet, save state */
					current_byte = j;
					current_section = i;
					parser_state = P_RAWDATA;
					secbuffptr_holder = secbuffptr;
					return (0);
				}
				else {	/* need to process bytes */
				    b_ptr = (unsigned char *)(buff+buffindex);
				    size = (a=XMODSIZE-buffindex) <
					 (b=sectbuf[i].secthead.sec_size
					  -current_byte) ? a : b;
				    if (download_flash(secbuffptr,b_ptr,size, flashtype) == ERROR)
					return (ERROR);
				    buffindex += size;
				    secbuffptr += size;
				    j += size - 1;
				}
			}
			current_byte = 0;
		}
	}
	parser_state = P_DONE;


case P_DONE:
	/* YEA!  we're done! */

		return (0);
		break;

}
}
#endif
