/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
#include "defines.h"
#include "globals.h"

/************************************************/
/* Integer power function			*/
/*                           			*/
/************************************************/
unsigned int int_pow(number,  power)
int number, power;
{
int i;
unsigned int result;


	if (power == 0)
		return (1);

	result = number;
	for (i=1; i<power; i++) {
		result *= number;
	}
	return (result);
}
/************************************************/
/* Ascii to Decimal Converter    		*/
/*                           			*/
/************************************************/
atod(s)
char s[];
{
int i, n;
long num;

	errno = FALSE;
	i = 0;
	num = 0;
	while(s[i] != NUL) {
		if((n = hexval(s[i])) == ERROR) {
			errno = TRUE;
			break;
		}
		num = (num * 10) + n;
		i++;
	}
	return(num);
}

/************************************************/
/* Ascii to Hex Converter    			*/
/*                           			*/
/************************************************/
unsigned atoh(s)
char s[];
{
int i, n, shift;
unsigned num;

	errno = FALSE;
	i = 0;
	shift = 0;
	num = 0;
	while(s[i] != NUL) {
		if((n = hexval(s[i])) == ERROR) {
			errno = TRUE;
			break;
		}
		num = (num << shift) + n;
		i++;
		shift = 4;
	}
	return(num);
}

/************************************************/
/* Hex value of character passed		*/
/*                           			*/
/* This is a lazy way to get the value,but it   */
/* works!                                       */
/************************************************/
hexval(c)
char c;
{
	switch (c) {
		case '0': return(0);
		case '1': return(1);
		case '2': return(2);
		case '3': return(3);
		case '4': return(4);
		case '5': return(5);
		case '6': return(6);
		case '7': return(7);
		case '8': return(8);
		case '9': return(9);
		case 'a': 
		case 'A': return(10);
		case 'b': 
		case 'B': return(11);
		case 'c': 
		case 'C': return(12);
		case 'd': 
		case 'D': return(13);
		case 'e': 
		case 'E': return(14);
		case 'f': 
		case 'F': return(15);
		default : return(ERROR);
	}
}

/************************************************/
/* Hex to ASCII Decimal Converter      		*/
/*                           			*/
/************************************************/
htoad(number, size, string, neg)
int number;			/* number to be converted */
int size;			/* size or precision of number */
unsigned char string[];		/* return string */
int neg;			/* are negatives important? */
				/* if so, no leading 0's */
{
int first,large;
int i, val;
unsigned char *strptr; 

	large = int_pow(10, (size-1));
	first = TRUE;
	strptr = string;

	if (neg) {	/* check for negative numbers if appropriate */
		if (number < 0) {
			number = -number;
			*strptr++ = '-';
		}
	}

	for (i=0; i<size; i++) {
		val = ((number / large)) % 10;  /* get digit */
		large = large / 10;

		/* strip leading 0's if appropriate */
		if (val == 0) {	
			if (first && (i != size-1) && neg) {
				continue;
			}
		}

		else 
			first = FALSE;
		*strptr++ = val + '0';
	}
	*strptr = NUL;
}

/************************************************/
/* Validate a floating point number 	 	*/
/*                           			*/
/* If anything but a Normal Finite Number,      */
/* print out the type and return ERROR    	*/
/************************************************/
validate (type)
int type;
{
	switch (type) {
		case 0: print("0.000000e 0");
			return (ERROR);
		case 1: print("Denormalized Number");
			return (ERROR);
		case 2: 
			return (0);
		case 3: print ("Infinity");
			return (ERROR);
		case 4: print ("QNaN");
			return (ERROR);
		case 5: print ("SNaN");
			return (ERROR);
		case 6: print ("Reserved Operand");
			return (ERROR);
		default:print ("    * * *   ");
			return (ERROR);
	}
}

