/*****************************************************************************
 * Definitions to target GDB to an i960 debugged over a serial line.
 *
 ******************************************************************************/

#ifndef I80960
#define I80960
#endif

#define IEEE_FLOAT

extern int dunno;	/* See printcmd.c */

#ifdef USG
	/* Include <termio.h> */
#	define HAVE_TERMIO

#else	/* BSD */

	/* Compensate for lack of `vprintf' function.  */
#	define vprintf(format, ap) _doprnt (format, ap, stdout)

	/* Get rid of system-imposed stack limit */
#	define SET_STACK_LIMIT_HUGE
#endif

/* Define this if the C compiler puts an underscore at the front
 * of external names before giving them to the linker.
 */
#define NAMES_HAVE_UNDERSCORE


/* Offset from address of function to start of its code.
 * Zero on most machines.
 */
#define FUNCTION_START_OFFSET 0

/* Advance PC across any function entry prologue instructions
 * to reach some "real" code.  (Not needed for i960.)
 */
#define SKIP_PROLOGUE(pc)   ;

/* Immediately after a function call, return the saved pc.
 * Can't always go through the frames for this because on some machines
 * (but not on i960!) the new frame is not set up until the new function
 * executes some instructions.
 */

#define SAVED_PC_AFTER_CALL(frame) FRAME_SAVED_PC(frame,0)

/* Address of end of stack space.
 *	This probably doesn't matter for the i960, because it's only used
 *	in manipulation of core files, which we don't support.
 */

#define STACK_END_ADDR (0xfe000000)

/* Stack grows upward
 */

#define INNER_THAN >

/* Sequence of bytes for breakpoint instruction
 */

#define BREAKPOINT {0x00, 0x3e, 0x00, 0x66}

/* Amount PC must be decremented by after a breakpoint.
 * This is often the number of bytes in BREAKPOINT but not always.
 */

#define DECR_PC_AFTER_BREAK 0

/* Nonzero if instruction at PC is a return instruction.
 */
#define ABOUT_TO_RETURN(pc) (read_memory_integer(pc,4) == 0x0a000000)

/* Return 1 if P points to an invalid floating point value.
 * LEN is the length in bytes.
 */
#define INVALID_FLOAT(p, len) (0)

/* How long (ordinary) registers are
 */
#define REGISTER_TYPE long

/* Number of machine registers */
#define NUM_REGS 40

/* Initializer for an array of names of registers.
 * There should be NUM_REGS strings in this initializer.
 */
#define REGISTER_NAMES { \
	/*  0 */	"pfp", "sp",  "rip", "r3",  "r4",  "r5",  "r6",  "r7", \
	/*  8 */	"r8",  "r9",  "r10", "r11", "r12", "r13", "r14", "r15",\
	/* 16 */	"g0",  "g1",  "g2",  "g3",  "g4",  "g5",  "g6",  "g7", \
	/* 24 */	"g8",  "g9",  "g10", "g11", "g12", "g13", "g14", "fp", \
	/* 32 */	"pc",  "ac",  "ip",  "tc",  "fp0", "fp1", "fp2", "fp3" \
}

/* Register numbers of various important registers (used to index
 * into arrays of register names and register values).
 */

#define FP_REGNUM  31	/* Contains address of executing stack frame */
#define SP_REGNUM   1	/* Contains address of top of stack */
#define IP_REGNUM  34	/* Instruction pointer */
#define FP0_REGNUM 36	/* First floating point register */
#define R0_REGNUM   0	/* First local register		*/
#define RIP_REGNUM  2	/* Return pointer, local r2	*/
#define R15_REGNUM 15	/* Last local register		*/
#define G0_REGNUM  16	/* First global register	*/
#define G13_REGNUM 29
#define G14_REGNUM 30

/* Some registers have more than one name
 */
#define PC_REGNUM  IP_REGNUM	/* GDB refers to ip as the Program Counter */
#define PFP_REGNUM R0_REGNUM	/* Previous frame pointer	*/

/* Not needed, because we don't support core files:
 *	#define KERNEL_U_ADDR
 *	#define REGISTER_U_ADDR(addr, blockend, regno)
 */

/* Total amount of space needed to store our copies of the machine's
 * register state, the array `registers'.
 */
#define REGISTER_BYTES ((36*4) + (4*8))

/* Index within `registers' of the first byte of the space for register N.
 */

#define REGISTER_BYTE(N) ( (N) < FP0_REGNUM ? \
				(4*(N)) : ((8*(N)) - (4*FP0_REGNUM)) )

/* Number of bytes of storage in the actual machine representation
 * for register N.  On the i960, all regs are 4 bytes except for floating
 * point, which are 10;  but NINDY only preserves and sends us 8 bytes,
 * so we'll just treat them as if that's their raw size.
 */

#define REGISTER_RAW_SIZE(N)		( (N) < FP0_REGNUM ? 4 : 8 )

/* Number of bytes of storage in the program's representation for register N.
 */

#define REGISTER_VIRTUAL_SIZE(N)	( (N) < FP0_REGNUM ? 4 : 8 )

/* Largest value REGISTER_RAW_SIZE can have.  */
#define MAX_REGISTER_RAW_SIZE 8

/* Largest value REGISTER_VIRTUAL_SIZE can have.  */
#define MAX_REGISTER_VIRTUAL_SIZE 8

/* Nonzero if register N requires conversion from raw format to virtual format.
 */
#define REGISTER_CONVERTIBLE(N) ((N) >= FP0_REGNUM)

/* Convert data from raw format for register REGNUM to virtual format for
 * register REGNUM:  no conversion necessary.
 */
#define REGISTER_CONVERT_TO_VIRTUAL(REGNUM,FROM,TO)	\
			bcopy((FROM), (TO), REGNUM < FP0_REGNUM ? 4 : 8);

/* Convert data from virtual format for register REGNUM raw format for
 * register REGNUM:  no conversion necessary.
 */
#define REGISTER_CONVERT_TO_RAW(REGNUM,FROM,TO)		\
			bcopy((FROM), (TO), REGNUM < FP0_REGNUM ? 4 : 8);

/* Return the GDB type object for the "standard" data type
 * of data in register N.
 */
#define REGISTER_VIRTUAL_TYPE(N) ((N) < FP0_REGNUM ? \
					builtin_type_int : builtin_type_double)

/* Extract from an array REGBUF containing the (raw) register state
 * a function return value of type TYPE, and copy that, in virtual format,
 * into VALBUF.
 */
#define EXTRACT_RETURN_VALUE(TYPE,REGBUF,VALBUF) \
	bcopy(REGBUF+REGISTER_BYTE(G0_REGNUM), VALBUF, TYPE_LENGTH (TYPE))

/* Write into appropriate registers a function return value
 * of type TYPE, given in virtual format.
 *
 * For 'return' command:  not (yet) implemented for i960.
 */
#define STORE_RETURN_VALUE(TYPE,VALBUF) 

/* Extract from an array REGBUF containing the (raw) register state
 * the address in which a function should return its structure value,
 * as a CORE_ADDR (or an expression that can be used as one).
 *
 * On i960, structure is returned in registers g0-g3, if it will fit.
 * if it's more than 16 bytes long, g13 pointed to it on entry, BUT WE
 * NO LONGER KNOW IF g13 IS STILL VALID!  So don't call this macro if
 * the length is > 16! (code has been #ifdef'd in values.c to accommodate
 * this constraint).
 */

#define EXTRACT_STRUCT_VALUE_ADDRESS(REGBUF) ((REGBUF)+REGISTER_BYTE(G0_REGNUM))

/* Take a frame's nominal address and produces the frame's chain-pointer
 * (pointer to previous frame).
 *
 * On the i960, this is done by getting the Previous Frame Pointer out of a
 * frame.  Be careful to clear low 6 bits, since status info is saved in them.
 */

#define FRAME_CHAIN(f) 		( read_memory_integer((f),4) & ~0x3f )

/*
 * FRAME_CHAIN_COMBINE takes the chain pointer and the frame's nominal address
 * and produces the nominal address of the caller frame.
 *
 * FRAME_CHAIN_VALID returns zero if the given frame is the outermost one
 * and has no caller.  In that case, FRAME_CHAIN_COMBINE is not used.
 */

#define FRAME_CHAIN_COMBINE(chain,thisframe)	(chain)

extern int FRAME_CHAIN_VALID();		/* See i960-pinsn.c */

#define FRAME_SAVED_PC(frame,x) (read_memory_integer(FRAME_CHAIN(frame)+8,4))
	/* Note that the return pointer is saved in the *caller's* stack frame*/

/* We use this instead of FRAME_ARGS_ADDR;  it takes a different set of
 * arguments.  See i960-pinsn.c
 */
extern unsigned int arg_addr();	

#define FRAME_LOCALS_ADDRESS(fi)	(fi).frame

/* Return number of args passed to a frame.
 * Can return -1, meaning no way to tell.
 */
#define FRAME_NUM_ARGS(numargs, fi)	(numargs = -1)

/* Return number of bytes at start of arglist that are not really args.  */

#define FRAME_ARGS_SKIP 0

extern FRAME_FIND_SAVED_REGS();			/* See i960-pinsn.c */

/***********************************************************************
 *                                                                     *
 * THINGS NEEDED FOR MAKING CALLS TO FUNCTIONS IN THE INFERIOR PROCESS *
 *                                                                     *
 ***********************************************************************/

/* Push an empty stack frame, to record the current PC, etc.
 *
 * Not (yet?) implemented for i960.
 */
#define PUSH_FRAME	

/* Discard from the stack the innermost frame, restoring all registers.
 *
 * Not (yet?) implemented for i960.
 */
#define POP_FRAME


/* This sequence of words is the instructions
 *
 *	callx 0x00000000
 *	fmark
 */

#define CALL_DUMMY { 0x86003000, 0x00000000, 0x66003e00 }

#define CALL_DUMMY_START_OFFSET 0  /* Start execution at beginning of dummy */

/* Insert the specified number of args and function address
 * into a call sequence of the above form stored at 'dummyname'.
 *
 * Ignore arg count on i960.
 */

#define FIX_CALL_DUMMY(dummyname, fun, nargs) *(((int *)dummyname)+1) = fun


/*************************************************
 *                                               *
 * INTERFACE DEFINITIONS FOR KERNEL DEBUGGER KDB *
 *                                               *
 *************************************************/

/* Not relevant */
