/* $Id: tm-i960.h,v 1.16 89/12/11 17:10:07 mcg Exp $ */
/* Definitions of target machine for GNU compiler, for Intel 80960
   Copyright (C) 1988, 1989 Intel Corp.
   Contributed by Steven McGeady (mcg@omepd.intel.com)
   Additional work by Glenn Colon-Bonet, Jonathan Shapiro, Andy Wilson
 */

/*
This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/* this is used only in out-i960.c to identify this version of the header */
#define	i960_RCS_ID_STRING "@(#) $Id: tm-i960.h,v 1.16 89/12/11 17:10:07 mcg Exp $"

#define	IDENT_DIRECTIVE
#define	SCCS_DIRECTIVE

/* Note that some other tm- files include this one and then override
   many of the definitions that relate to assembler syntax.  */

/* Names to predefine in the preprocessor for this target machine.  */

#define CPP_PREDEFINES "-Di960 -Di80960 -DI960 -DI80960"

/* tell cc1 where to find standard GNU defines - look in $G960INC first,
   then in $G960BASE/include, then in $INCDIR (ic960's include home), then
   in $I960BASE/include (ic960's default) */

#ifdef GCC960
#define	CPP_SPEC "%{!nostdinc:-nostdinc -I%[I:%[~/%[@I]:%[?I]]]}\
		%{AKA:-D__i960_KA__}%{AKB:-D__i960_KB__}%{AMC:-D__i960_MC__}\
		%{AKC:-D__i960_KC__}%{ACA:-D__i960_CA__}%{ACB:-D__i960_CB__}\
		%{!AKA:%{!AKB:%{!AMC:%{!AKC:%{!ACA:%{!ACB:-D__i960_KB__}}}}}}"
#else
#define	CPP_SPEC "%{!nostdinc:-nostdinc}\
		%{AKA:-D__i960_KA__}%{AKB:-D__i960_KB__}%{AMC:-D__i960_MC__}\
		%{AKC:-D__i960_KC__}%{ACA:-D__i960_CA__}%{ACB:-D__i960_CB__}\
		%{!AKA:%{!AKB:%{!AMC:%{!AKC:%{!ACA:%{!ACB:-D__i960_KB__}}}}}}"
#endif

/* specification for switches from command line to cc1 */

/* add in -fschedule-insns when appropriate */
/* -fforce-mem probably isn't a win, -fforce-addr needs looking at */

#define	CC1_SPEC "%{AKA:-mka -msoft-float}%{AKB:-mkb}%{AMC:-mmc}%{AKC:-mmc}\
		  %{ACA:-mca -msoft-float}%{ACB:-mcb}%{ACC:-mcc}\
		  %{!AKA:%{!AKB:%{!AMC:%{!AKC:%{!ACA:%{!ACB:-mkb}}}}}}\
		  %{sun3:}%{sun4:}%{sun386:}\
		  %{O0: -mnotail-call -mnoleaf-procedures}%{O1:-opt}\
		  %{O:-opt}%{O2:-opt -fstrength-reduce -fcombine-regs}\
		  %{O3:-opt -fstrength-reduce -fcombine-regs -finline-functions}\
		  %{g:-mnotail-call -mnoleaf-procedures}%{i:-mintel-asm}"

#define	ENV_GNUBASE	"G960BASE"
#define	ENV_GNUBIN	"G960BIN"
#define	ENV_GNULIB	"G960LIB"
#define	ENV_GNUINC	"G960INC"

#define	ENV_GNUAS	"G960AS"
#define	ENV_GNUCPP	"G960CPP"
#define	ENV_GNUCC1	"G960CC1"
#define	ENV_GNUCC1PLUS	"G960CC1PLUS"
#define	ENV_GNULD	"G960LD"
#define	ENV_GNUCRT	"G960CRT"
#define	ENV_GNUCRT_G	"G960CRT_G"
#define	ENV_GNUCRT_M	"G960CRT_M"

#define	GNUAS_DFLT	"%{!i:gas960}%{i:asm960}"
#define GNULD_DFLT	"%{!i:gld960}%{i:lnk960}"
#define	GNUCC1_DFLT	"cc1.960"
#define	GNUCPP_DFLT	"cpp.960"
#define	GNUCRT_DFLT	"crtning.o"
#define	GNUCRTM_DFLT	"crtningm.o"	/* normal profiling */
#define	GNUCRTG_DFLT	"crtningg.o"	/* gprof profiling */


#define	ASM_SPEC "%{A*}%{!A*:-AKB} "

#define LIB_SPEC "%{!nostdlib:%{!i:-lcg -lning -lqtg\
		  %{p:-lprof}%{pg:-lgprof}%{AKA:-lfpg}%{ACA:-lfpg}}\
		  %{i:%{AKA:-lcka -lfpal}%{AKB:-lckb}%{ACA:-lcca -lfpal}}}\
		  %{!i:-lgnu}"

#define	LINK_SPEC "%{A*}%{!A*:-AKB} %{!i:%{!Ttext:-Ttext 8000000}}"

#ifdef GCC960
#define STARTFILE_SPEC  \
		"%{!crt:%{pg:%[G%s:%[L/%[@G]:%[~/lib/%[@G]:%[?G]]]]}\
		 %{!pg:%{p:%[M%s:%[L/%[@M]:%[~/lib/%[@M]:%[?M]]]]}\
		 %{!p:%[S%s:%[L/%[@S]:%[~/lib/%[@S]:%[?S]]]]}}}"
#endif

/* Print subsidiary information on the compiler version in use.  */

#define TARGET_VERSION fprintf (stderr," (intel 80960)");

/* Generate DBX debugging information.  */
#define DBX_DEBUGGING_INFO

/* Generate SDB style debugging information */
#define SDB_DEBUGGING_INFO

#define	DBG_NO_INITIAL_LINENO

/* Run-time compilation parameters selecting different hardware subsets.  */

extern int target_flags;

/* Nonzero if we should generate code for the KA processor */
/* 	no FPU, no microcode instructions */
#define	TARGET_FLAG_KA	0x01
#define TARGET_KA (target_flags & TARGET_FLAG_KA)

/* Nonzero if we should generate code for the MC processor */
/*	not really different from KB for our purposes */
#define	TARGET_FLAG_MC	0x04
#define TARGET_MC (target_flags & TARGET_FLAG_MC)

/* Nonzero if we should generate code for the CA processor */
/*	different optimization strategies */
#define	TARGET_FLAG_CA	0x08
#define	TARGET_CA (target_flags & TARGET_FLAG_CA)

/* Processor has floating point instructions (MC or KB) */
/* This is set up as a seperate flag in case we would like */
/* to generate soft-float code on an MC or KB */
#define	TARGET_FLAG_FLOAT 0x10
#define TARGET_FLOAT (target_flags & TARGET_FLAG_FLOAT)

/* Nonzero if we should generate leaf-procedures when we find them */
/*	You may not want to do this because leaf-proc entries are */
/*	slower when not entered via BAL - this would be true when */
/*	a linker not supporting the optimization is used	*/
#define	TARGET_FLAG_LEAFPROC 0x20
#define	TARGET_LEAFPROC (target_flags & TARGET_FLAG_LEAFPROC)

/* Nonzero if we should performa tail-call optimizations when we find them */
/*	You may not want to do this because the detection of cases where */
/*	this is not legal is not totally complete		*/
#define	TARGET_FLAG_TAILCALL 0x40
#define	TARGET_TAILCALL (target_flags & TARGET_FLAG_TAILCALL)

/* Nonzero if use of complex addressing mode is a win on this implementation */
/*	Complex addressing modes are probably not worthwhile on the K-series */
/*	But they definitely are on the C-series */
#define	TARGET_FLAG_COMPLEX_ADDR	0x80
#define	TARGET_COMPLEX_ADDR	(target_flags & TARGET_FLAG_COMPLEX_ADDR)

#define	TARGET_FLAG_REOPT		0x100
#define	TARGET_REOPT		(target_flags & TARGET_FLAG_REOPT)

#define	TARGET_FLAG_MOVSTR		0x200
#define	TARGET_MOVSTR		(target_flags & TARGET_FLAG_MOVSTR)

#define	TARGET_FLAG_CODE_ALIGN		0x400
#define	TARGET_CODE_ALIGN	(target_flags  & TARGET_FLAG_CODE_ALIGN)

#define	TARGET_FLAG_BRANCH_PREDICT	0x800
#define	TARGET_BRANCH_PREDICT	(target_flags  & TARGET_FLAG_BRANCH_PREDICT)

#define	TARGET_FLAG_ROTATE_LOCAL	0x1000
#define	TARGET_ROTATE_LOCAL	(target_flags & TARGET_FLAG_ROTATE_LOCAL)

#define	TARGET_FLAG_ROTATE_GLOBAL	0x2000
#define	TARGET_ROTATE_GLOBAL	(target_flags & TARGET_FLAG_ROTATE_GLOBAL)

#define	TARGET_FLAG_INTEL_ASM		0x40000000
#define	TARGET_INTEL_ASM	(target_flags & TARGET_FLAG_INTEL_ASM)

#define	TARGET_EPILOGUE	(0)


/* Macro to define tables used to set the flags.
   This is a list in braces of pairs in braces,
   each pair being { "NAME", VALUE }
   where VALUE is the bits to set or minus the bits to clear.
   An empty string NAME is used to identify the default VALUE.  */

#define TARGET_SWITCHES  \
  { {"ka", (TARGET_FLAG_KA|TARGET_FLAG_COMPLEX_ADDR)},	\
    {"soft-float", -(TARGET_FLAG_FLOAT)},		\
    {"kb", (TARGET_FLAG_KA|TARGET_FLAG_FLOAT|TARGET_FLAG_COMPLEX_ADDR)},\
    {"kc", (TARGET_FLAG_MC|TARGET_FLAG_FLOAT|TARGET_FLAG_COMPLEX_ADDR)},\
    {"mc", (TARGET_FLAG_MC|TARGET_FLAG_FLOAT|TARGET_FLAG_COMPLEX_ADDR)},\
    {"ca", (TARGET_FLAG_CA|TARGET_FLAG_BRANCH_PREDICT|			\
			TARGET_FLAG_CODE_ALIGN)},\
    {"cb", (TARGET_FLAG_CA|TARGET_FLAG_FLOAT|TARGET_FLAG_BRANCH_PREDICT| \
			TARGET_FLAG_CODE_ALIGN)},\
    {"cc", (TARGET_FLAG_CA|TARGET_FLAG_FLOAT|TARGET_FLAG_BRANCH_PREDICT| \
			TARGET_FLAG_CODE_ALIGN)},\
    {"leaf-procedures", TARGET_FLAG_LEAFPROC},		\
    {"noleaf-procedures",-(TARGET_FLAG_LEAFPROC)},	\
    {"tail-call",TARGET_FLAG_TAILCALL},			\
    {"notail-call",-(TARGET_FLAG_TAILCALL)},		\
    {"complex-addr",TARGET_FLAG_COMPLEX_ADDR},		\
    {"nocomplex-addr",-(TARGET_FLAG_COMPLEX_ADDR)},	\
    {"reopt",TARGET_FLAG_REOPT},			\
    {"movstr",TARGET_FLAG_MOVSTR},			\
    {"nomovstr",-(TARGET_FLAG_MOVSTR)},			\
    {"code-align",TARGET_FLAG_CODE_ALIGN},		\
    {"nocode-align",-(TARGET_FLAG_CODE_ALIGN)},		\
    {"branch-predict",TARGET_FLAG_BRANCH_PREDICT},	\
    {"nobranch-predict",-(TARGET_FLAG_BRANCH_PREDICT)},	\
    {"rotate-local", TARGET_FLAG_ROTATE_LOCAL},		\
    {"norotate-local", -(TARGET_FLAG_ROTATE_LOCAL)},	\
    {"rotate-global", TARGET_FLAG_ROTATE_GLOBAL},	\
    {"norotate-global", -(TARGET_FLAG_ROTATE_GLOBAL)},	\
    {"intel-asm",TARGET_FLAG_INTEL_ASM},		\
    { "", TARGET_DEFAULT}}


/* Override conflicting target switch options -  */
/* #define OVERRIDE_OPTIONS */

#define TARGET_DEFAULT (TARGET_FLAG_FLOAT|TARGET_FLAG_KA|		\
			TARGET_FLAG_LEAFPROC|TARGET_FLAG_TAILCALL|	\
			TARGET_FLAG_COMPLEX_ADDR)

/* target machine storage layout */

/* Define this if most significant bit is lowest numbered
   in instructions that operate on numbered bit-fields.  */
/* #define BITS_BIG_ENDIAN */

/* Define this if most significant byte of a word is the lowest numbered.  */
/* This is not true on the 960.  */
/* #define BYTES_BIG_ENDIAN */

/* Define this if most significant word of a multiword number is numbered.  */
/* #define WORDS_BIG_ENDIAN */

/* number of bits in an addressible storage unit */
#define BITS_PER_UNIT 8

/* Width in bits of a "word", which is the contents of a machine register.
   Note that this is not necessarily the width of data type `int';
   if using 16-bit ints on a 68000, this would still be 32.
   But on a machine with 16-bit registers, this would be 16.  */
#define BITS_PER_WORD 32

/* Width of a word, in units (bytes).  */
#define UNITS_PER_WORD 4

/* Width in bits of a pointer.
   See also the macro `Pmode' defined below.  */
#define POINTER_SIZE 32

/* width in bits of a long double */
/* should this be (3*32) ??? */
#define	LONG_DOUBLE_TYPE_SIZE	(4*32)

/* Allocation boundary (in *bits*) for storing pointers in memory.  */
#define POINTER_BOUNDARY 32

/* Allocation boundary (in *bits*) for storing arguments in argument list.  */
#define PARM_BOUNDARY 32

#define	MAX_PARM_BOUNDARY (4*32)

/* Boundary (in *bits*) on which stack pointer should be aligned.  */
#define STACK_BOUNDARY 32

/* Allocation boundary (in *bits*) for the code of a function.  */
#define FUNCTION_BOUNDARY (4*32)

/* Alignment of field after `int : 0' in a structure.  */
#define EMPTY_FIELD_BOUNDARY 32

/* Every structure's size must be a multiple of this.  */
#define STRUCTURE_SIZE_BOUNDARY 32

/* No data type wants to be aligned rounder than this.  */
/* extended precision floats gets 4-word alignment */
/* #define BIGGEST_ALIGNMENT (32) */
#define BIGGEST_ALIGNMENT (4*32)

/* Specify alignment for string literals (which might be higher than the
   base type's minimnal alignment requirement -- this allows strings to be
   aligned on word boundaries, and optimizes calls to the str* and mem*
   library functions.  */
#define CONSTANT_ALIGNMENT( type, def_align ) \
  (((type) == STRING_CST) ? BIGGEST_ALIGNMENT : def_align)

/* Define this if move instructions will actually fail to work
   when given unaligned data.  */
/* 80960 will work even with unaligned data (slow) */
/*#define STRICT_ALIGNMENT*/

/* Standard register usage.  */

/* Number of actual hardware registers.
   The hardware registers are assigned numbers for the compiler
   from 0 to just below FIRST_PSEUDO_REGISTER.
   All registers that the compiler knows about must be given numbers,
   even those that are not normally considered general registers.

   80960 has 32 fullword registers and 4 floating point registers.  */

#define FIRST_PSEUDO_REGISTER 36

/* 1 for registers that have pervasive standard uses
   and are not available for the register allocator.
   On 80960, this includes the frame pointer (g15),
   the previous FP (r0), the stack pointer (r1), and the
   return instruction pointer (r2) */
/* must also declare argument pointer reg (r14) as a fixed reg */
#define FIXED_REGISTERS  \
 {0, 0, 0, 0, 0, 0, 0, 0,	\
  0, 0, 0, 0, 0, 0, 1, 1,	\
  1, 1, 1, 0, 0, 0, 0, 0,	\
  0, 0, 0, 0, 0, 0, 0, 0,	\
  0, 0, 0, 0}


/* 1 for registers not available across function calls.
   These must include the FIXED_REGISTERS and also any
   registers that can be used without being saved.
   The latter must include the registers where values are returned
   and the register where structure-value addresses are passed.
   Aside from that, you can include as many other registers as you like.  */

/* on 80960, note that:
 *	g0..g3 are used for return values
 *	g0..g7 may always be used for parameters
 *	g8..g11 may be used for parameters, but are preserved if they aren't
 *	g12 is always preserved, but otherwise unused
 *	g13 is the struct return ptr if used, or temp, but maybe trashed
 *	g14 is leaf return ptr or arg blk ptr, must be set to zero on ret
 *	r0..r15 always available
 *	fp0..fp3 never available	- changed 1/8/89 - mcg
 */
/* r0..r15 can be used without being saved */

#define CALL_USED_REGISTERS  \
 {1, 1, 1, 1, 1, 1, 1, 1,	\
  0, 0, 0, 0, 0, 1, 1, 1,	\
  1, 1, 1, 0, 0, 0, 0, 0,	\
  0, 0, 0, 0, 0, 0, 0, 0,	\
  1, 1, 1, 1}

#define	CONDITIONAL_REGISTER_USAGE	\
  if (!TARGET_FLOAT) {							\
     fixed_regs[32] = fixed_regs[33] = fixed_regs[34]  = fixed_regs[35] = 1;\
  }									\

/* Return number of consecutive hard regs needed starting at reg REGNO
   to hold something of mode MODE.
   This is ordinarily the length in words of a value of mode MODE
   but can be less for certain modes in special long registers.

   On 80960, ordinary registers hold 32 bits worth, but can be ganged
   together to hold double or extended precision floating point numbers,
   and the floating point registers hold any size floating point number */
#define HARD_REGNO_NREGS(REGNO, MODE)   \
	((REGNO) < 32							\
		? ((MODE == VOIDmode)					\
		  ? 1							\
		  : ((GET_MODE_SIZE(MODE)+UNITS_PER_WORD-1)/UNITS_PER_WORD)) \
		: ((REGNO) < FIRST_PSEUDO_REGISTER) ? 1  :  0)

/* Value is 1 if hard register REGNO can hold a value of machine-mode MODE.
   On 80960, the cpu registers can hold any mode but the float registers
   can only hold SFmode, DFmode, or TFmode.  */
/* Be sure to preserve register alignment for data types that require 
 * more than one register and live in general regs.  They must be aligned
 * on a register that is an even multiple of the number of words, except
 * extended reals (TFmode) that require alignment of four in a gen reg 
 */
#define HARD_REGNO_MODE_OK(REGNO, MODE) 				\
  (((REGNO) < 32)							\
	? ((MODE == XFmode)						\
	   ? ((REGNO % 4) == 0)						\
	   : ((REGNO % HARD_REGNO_NREGS(REGNO,MODE)) == 0))		\
	: ((TARGET_FLOAT) && ((MODE) == SFmode || (MODE) == DFmode ||	\
	   (MODE) == XFmode || (MODE) == TFmode)))

/* Value is 1 if it is a good idea to tie two pseudo registers
   when one has mode MODE1 and one has mode MODE2.
   If HARD_REGNO_MODE_OK could produce different values for MODE1 and MODE2,
   for any hard reg, then this must be 0 for correct output.  */
/* rms sez in the i860 1.36 tm.h that this doesn't apply to mere alignment */
/* restrictions, so we'll allow floating modes to tie also */

#define MODES_TIEABLE_P(MODE1, MODE2)					\
	(((MODE1) == (MODE2))						\
	  ||								\
	((((MODE1) == SImode) || ((MODE1) == HImode) || ((MODE1) == QImode))\
	  &&								\
	(((MODE2) == SImode) || ((MODE2) == HImode) || ((MODE2) == QImode)))\
	  ||								\
	((((MODE1) == SFmode) || ((MODE1) == DFmode) || ((MODE1) == XFmode)\
		|| ((MODE1) == TFmode))					\
	  &&								\
	(((MODE2) == SFmode) || ((MODE2) == DFmode) || ((MODE2) == XFmode)\
		|| ((MODE2) == TFmode))))
		

/* Specify the registers used for certain standard purposes.
   The values of these macros are register numbers.  */

/* 80960 pc isn't overloaded on a register that the compiler knows about.  */
/* #define PC_REGNUM  */

/* Register to use for pushing function arguments.  */
#define STACK_POINTER_REGNUM 17

/* Actual top-of-stack address is same as
   the contents of the stack pointer register.  */
#define STACK_POINTER_OFFSET 0

/* Base register for access to local variables of the function.  */
#define FRAME_POINTER_REGNUM 15

/* Value should be nonzero if functions must have frame pointers.
   Zero means the frame pointer need not be set up (and parms
   may be accessed via the stack pointer) in functions that seem suitable.
   This is computed in `reload', in reload1.c.  */
#define FRAME_POINTER_REQUIRED 1

/* Base register for access to arguments of the function.  */
#define ARG_POINTER_REGNUM 14

/* Register in which static-chain is passed to a function.  */
/* ??? */
#define STATIC_CHAIN_REGNUM 0
 

/* Functions which return large structures get the address
   to place the wanted value at in g13 */

#define STRUCT_VALUE_REGNUM 13 
#define STRUCT_VALUE_INCOMING_REGNUM	13


/* order in which to allocate registers */

#define	REG_ALLOC_ORDER	{	 \
	0, 1, 2, 3, 4, 5, 6, 7,	 /* g0, g1, g2, g3, g4, g5, g6, g7 */	     \
	20,21,22,23,24,25,26,27, /* r4, r5, r6, r7, r8, r9, r10, r11 */     \
	28,29,30,31,19,8,9,10, /* r12, r13, r14, r15, r3, g8, g9, g10 */  \
	11, 12,			/* g11, g12, */			     \
	32,33,34,35,  	 	/* fp0, fp1, fp2, fp3 */   	      \
	/* can't actually allocate these */				     \
	16,17,18,14,15}			/* r0, r1, r2, g14, g15 */
#if 0
/* this was marginally betteron K-series, but not on CA */
#define	REG_ALLOC_ORDER	{	 \
	0, 1, 2, 3, 4, 5, 6, 7,	 /* g0, g1, g2, g3, g4, g5, g6, g7 */	     \
	20,24,28,22,26,30,21,23, /* r4, r8, r12, r6, r10, r14, r5, r7 */     \
	25,27,29,31,19,13,	/* r9, r11, r15, r3, g13 */		     \
	8,9, 10, 11, 12,	/*  g8, g9, g10, g1, g12, */     	     \
	32,33,34,35,  	 	/* fp0, fp1, fp2, fp3 */   	      	     \
	/* can't actually allocate these */				     \
	16,17,18,14,15}			/* r0, r1, r2, g14, g15 */
#endif

#define	LAST_DESIRABLE_REG_INDEX	22

#define	LOCAL_REG_ROTATING_ALLOC(ITER,LAST)			\
		((TARGET_ROTATE_LOCAL) ?			\
		  (((ITER) == 0 && ((LAST) >= LAST_DESIRABLE_REG_INDEX)) ? \
		    (0)						\
		    : ((((LAST)+1) >= FIRST_PSEUDO_REGISTER) ?	\
		        0					\
			: (LAST)+1)) 				\
		  : (ITER))


/* Define the classes of registers for register constraints in the
   machine description.  Also define ranges of constants.

   One of the classes must always be named ALL_REGS and include all hard regs.
   If there is more than one class, another class must be named NO_REGS
   and contain no registers.

   The name GENERAL_REGS must be the name of a class (or an alias for
   another name such as ALL_REGS).  This is the class of registers
   that is allowed by "g" or "r" in a register constraint.
   Also, registers outside this class are allocated only when
   instructions express preferences for them.

   The classes must be numbered in nondecreasing order; that is,
   a larger-numbered class must never be contained completely
   in a smaller-numbered class.

   For any two classes, it is very desirable that there be another
   class that represents their union.  */
   
/* The 80960 has three kinds of registers, global, local, and floating point.*/

enum reg_class {
	NO_REGS, GLOBAL_REGS, LOCAL_REGS, LOCAL_OR_GLOBAL_REGS, FP_REGS,
	ALL_REGS, LIM_REG_CLASSES
};

#define	GENERAL_REGS	(TARGET_FLOAT ? ALL_REGS : LOCAL_OR_GLOBAL_REGS)

#define N_REG_CLASSES (int) LIM_REG_CLASSES

/* Give names of register classes as strings for dump file.   */

#define REG_CLASS_NAMES  { \
	"NO_REGS", "GLOBAL_REGS", "LOCAL_REGS", "LOCAL_OR_GLOBAL_REGS", \
	"FP_REGS", "ALL_REGS" }

/* Define which registers fit in which classes.
   This is an initializer for a vector of HARD_REG_SET
   of length N_REG_CLASSES.  */

#define REG_CLASS_CONTENTS { \
	{0, 0}, {0x0ffff, 0}, {0xffff0000, 0}, {-1,0}, {0, -1}, \
	{-1,-1}}

/* The same information, inverted:
   Return the class number of the smallest class containing
   reg number REGNO.  This could be a conditional expression
   or could index an array.  */

#define REGNO_REG_CLASS(REGNO) \
 ((REGNO) >= 32 ? FP_REGS : (REGNO) >= 16 ? LOCAL_REGS : GLOBAL_REGS)

/* The class value for index registers, and the one for base regs.  */
#define INDEX_REG_CLASS LOCAL_OR_GLOBAL_REGS
#define BASE_REG_CLASS LOCAL_OR_GLOBAL_REGS

/* Get reg_class from a letter such as appears in the machine description.  */
/* 'f' is a floating point register (fp0..fp3) */
/* 'l' is a local register (r0-r15) */
/* 'b' is a global register (g0-g15) */
/* 'd' is any local or global register */
/* 'r' or 'g' are pre-defined to the class ALL_REGS */
#define REG_CLASS_FROM_LETTER(C) \
  (((C) == 'f') && TARGET_FLOAT ? FP_REGS : ((C) == 'l' ? LOCAL_REGS :	\
    (C) == 'b' ? GLOBAL_REGS : ((C) == 'd' ? LOCAL_OR_GLOBAL_REGS : NO_REGS)))

/* The letters I, J, K, L and M in a register constraint string
   can be used to stand for particular ranges of immediate operands.
   This macro defines what the ranges are.
   C is the letter, and VALUE is a constant value.
   Return 1 if VALUE is in the range specified by C.

   For 80960:
	'I' is used for literal values 0..31
   	'J' means literal 0
	'K' means -31 .. +31
	'L' is a literal value that is a power of 2 in {1,2,4,8,16}
*/

#define CONST_OK_FOR_LETTER_P(VALUE, C)  				\
  ((C) == 'I' ? (((unsigned) (VALUE)) <= 31) :				\
	(C) == 'J' ? ((VALUE) == 0) :					\
	(C) == 'K' ? ((VALUE) > -32 && (VALUE) < 32) :			\
	(C) == 'L' ? ((VALUE) == 1 || (VALUE) == 2 || (VALUE) == 4 ||	\
		(VALUE) == 8 || (VALUE) == 16) : 0)

/* Similar, but for floating constants, and defining letters G and H.
   Here VALUE is the CONST_DOUBLE rtx itself.  */

#define CONST_DOUBLE_OK_FOR_LETTER_P(VALUE, C)  \
  (TARGET_FLOAT && \
    ((C) == 'G' && ((VALUE == dconst0_rtx) || (VALUE == fconst0_rtx))))

/* Given an rtx X being reloaded into a reg required to be
   in class CLASS, return the class of reg to actually use.
   In general this is just CLASS; but on some machines
   in some cases it is preferable to use a more restrictive class.  */
#define PREFERRED_RELOAD_CLASS(X,CLASS) (CLASS)

/* Return the maximum number of consecutive registers
   needed to represent mode MODE in a register of class CLASS.  */
/* On 80960, this is the size of MODE in words,
   except in the FP regs, where a single reg is always enough.  */
#define CLASS_MAX_NREGS(CLASS, MODE)					\
  (CLASS == FP_REGS ? 1 :						\
     HARD_REGNO_NREGS (0, MODE))

/* Stack layout; function entry, exit and calling.  */

/* Define this if pushing a word on the stack
   makes the stack pointer a smaller address.  */
/* #define STACK_GROWS_DOWNWARD */

/* Define this if the nominal address of the stack frame
   is at the high-address end of the local variables;
   that is, each additional local variable allocated
   goes at a more negative offset in the frame.  */
/* #define FRAME_GROWS_DOWNWARD */

/* Offset within stack frame to start allocating local variables at.
   If FRAME_GROWS_DOWNWARD, this is the offset to the END of the
   first local allocated.  Otherwise, it is the offset to the BEGINNING
   of the first local allocated.  */
/* On the 960, local variables are allocated after the register save area */
/* of the current stack frame.  This frame is 64 bytes long.  */
#define STARTING_FRAME_OFFSET 64 

/* If we generate an insn to push BYTES bytes,
   this says how many the stack pointer really advances by.
   On 80960, don't define this because there are no push insns.  */
/* #define PUSH_ROUNDING(BYTES) BYTES */

/* Offset of first parameter from the argument pointer register value. */
/* For the 80960, g14 will be used as the argument pointer, if needed. */
/* During a function call, the argument pointer will always be set up */
/* to point to the first argument, *of the argument block*.  Since 12 */
/* parameters are already in the registers, we start putting additional */
/* parameters beyond them, so the callee can copy the reg params into */
/* the leftover space. */

#define	ARG_BLOCK_MIN_SIZE	(48)	/* not a GCC-defined macro */

/* note that this is used in stmt.c for caller, and expr.c if CALLER_OFFSET */

#define FIRST_PARM_OFFSET(FNDECL) (0)


/* Offset from top-of-stack address to location to store the
   function parameter if it can't go in a register.
   Addresses for following parameters are computed relative to this one.*/

/* note that this is used only in 'expr.c'				*/

#define	FIRST_PARM_CALLER_OFFSET(FNDECL)	(0)

/* When a parameter is passed in a register, stack space is still
   allocated for it.  */
/* NOTE: on the 960, if any registers spill to memory, then stack space */
/* 	is allocated for ALL parameters, not just those that spill	*/
/*	- implementing this requires some changes to the standard	*/
/*	GCC 1.30 expr.c	 - mcg, 1/29/89					*/

/* note that this is used only in 'stmt.c' for callee */
/* [atw] this should NOT be defined for the i960 */
/* #define REG_PARM_STACK_SPACE */

/* special for i960 - put unnamed args (prototype has ellipses) in registers */
/* using the standard rules - gcc normally automatically starts an arg block */

#define	UNNAMED_ARGS_IN_REGISTERS

#define	STACK_ARGS_ADJUST(SIZE)					\
	{ if (args_so_far.ca_nstackparms == 0) {		\
		SIZE.constant = 0;				\
	  } else if (args_so_far.ca_nregparms < 12) {		\
		SIZE.constant -= (args_so_far.ca_nregparms*4);	\
		SIZE.constant += ARG_BLOCK_MIN_SIZE;		\
		stack_padding = ARG_BLOCK_MIN_SIZE -		\
				(args_so_far.ca_nregparms*4);	\
	  }							\
	  if (SIZE.var) abort();				\
	}


#define FUNCTION_ARG_CALLER_FIX_OFFSET(CUM,SIZE,VAR,MODE,OFF)		\
	((CUM.ca_nstackparms == 0) ?					\
		(((SIZE > 16) || VAR || (CUM.ca_cum >= 12)) ?		\
			ARG_BLOCK_MIN_SIZE : (CUM.ca_nregparms*4)) :	\
		(ARG_BLOCK_MIN_SIZE + (CUM.ca_nstackparms*4)))
#if 0
/* to be used when REG_PARM_STACK_SPACE is not set */
#define FUNCTION_ARG_CALLER_FIX_OFFSET(CUM,SIZE,VAR,MODE,OFF)		\
	((CUM.ca_nstackparms == 0) ?					\
		(((SIZE > 16) || VAR || (CUM.ca_cum >= 12)) ?		\
			ARG_BLOCK_MIN_SIZE : OFF) : ARG_BLOCK_MIN_SIZE+OFF)
#endif


/* Value is 1 if returning from a function call automatically
   pops the arguments described by the number-of-args field in the call.
   FUNTYPE is the data type of the function (as a tree),
   or for a library call it is an identifier node for the subroutine name.  */

#define RETURN_POPS_ARGS(FUNTYPE) 1

/* Define how to find the value returned by a function.
   VALTYPE is the data type of the value (as a tree).
   If the precise function being called is known, FUNC is its FUNCTION_DECL;
   otherwise, FUNC is 0.  */

/* On 80960 the value is found in the first "output" register.  */

#define FUNCTION_VALUE(VALTYPE, FUNC)  \
	gen_rtx (REG, TYPE_MODE (VALTYPE), 0)

/* Define how to find the value returned by a library function
   assuming the value has mode MODE.  */

#define LIBCALL_VALUE(MODE)	\
	gen_rtx (REG, MODE, 0)

/* 1 if N is a possible register number for a function value
   as seen by the caller.
   On 80960, returns are in r0..r3 */

#define FUNCTION_VALUE_REGNO_P(N) ((N) < 4)

/* 1 if N is a possible register number for function argument passing.
   On 80960, parameters are passed in g0..g11 */

#define FUNCTION_ARG_REGNO_P(N) ((N) < 12)

/* Define a data type for recording info about an argument list
   during the scan of that argument list.  This data type should
   hold all necessary information about the function itself
   and about the args processed so far, enough to enable macros
   such as FUNCTION_ARG to determine where the next arg should go.

   On 80960, this is a single integer, which is a number of words
   of arguments scanned so far (including the invisible argument,
   if any, which holds the structure-value-address).
   Thus 7 or more means all following args should go on the stack.  */

struct cum_args {
	int ca_cum;
	int ca_nregparms;
	int ca_nstackparms;
};

#define CUMULATIVE_ARGS struct cum_args

/* Define the number of register that can hold parameters.
   This macro is used only in other macro definitions below.  */
#define NPARM_REGS 12

/* Initialize a variable CUM of type CUMULATIVE_ARGS
   for a call to a function whose data type is FNTYPE.
   For a library call, FNTYPE is 0.

   On 80960, the offset always starts at 0: the first parm reg is g0 */

#define INIT_CUMULATIVE_ARGS(CUM,FNTYPE)				\
	(CUM.ca_cum = 0,CUM.ca_nregparms = 0,CUM.ca_nstackparms = 0)

/* rounded size of a function argument */


#define	__FUNCTION_ARG_SIZE(MODE,TYPE)					\
	((MODE) == BLKmode ? ((int_size_in_bytes(TYPE)+3)/4)		\
				: ((GET_MODE_SIZE(MODE)+3)/4))

/* return value reguired to align the data type being accessed */
#define __FUNCTION_ARG_ALIGN(OFF, MODE, TYPE) 		\
    ((FUNCTION_ARG_SIZE(MODE, TYPE) > 1) ?		\
     (FUNCTION_ARG_SIZE(MODE,TYPE) == 3) ? (4 - (OFF)%4) :	\
    ((((OFF) % FUNCTION_ARG_SIZE(MODE, TYPE)) > 0) ?		\
	FUNCTION_ARG_SIZE(MODE,TYPE) - ((OFF)%(FUNCTION_ARG_SIZE(MODE,TYPE))) \
	: 0) : 0)

#define	FUNCTION_ARG_SIZE(MODE,TYPE) i960_function_arg_size(MODE,TYPE)
#define	FUNCTION_ARG_ALIGN(OFF,MODE,TYPE) i960_function_arg_align(OFF,MODE,TYPE)

/* Update the data in CUM to advance over an argument
   of mode MODE and data type TYPE.
   CUM should be advanced to align with the data type accessed and
   also the size of that data type in # of regs.
   (TYPE is null for libcalls where that information may not be available.)  */

#define FUNCTION_ARG_ADVANCE(CUM, MODE, TYPE, NAMED)	\
    ((((NAMED) == 0 || (CUM.ca_cum >= (NPARM_REGS)) ||			\
      (FUNCTION_ARG_SIZE(MODE,TYPE) > 4)) ?				\
    	((CUM.ca_nstackparms) +=					\
		(FUNCTION_ARG_ALIGN(CUM.ca_nstackparms, MODE, TYPE) +	\
		 FUNCTION_ARG_SIZE(MODE, TYPE)))			\
	:								\
	((CUM.ca_nregparms) +=						\
		(FUNCTION_ARG_ALIGN(CUM.ca_nregparms, MODE, TYPE) +	\
		 FUNCTION_ARG_SIZE(MODE, TYPE)))			\
	),								\
	((CUM.ca_cum) += (FUNCTION_ARG_ALIGN(CUM.ca_cum, MODE, TYPE) +	\
	  FUNCTION_ARG_SIZE(MODE, TYPE))))


/* Determine where to put an argument to a function.
   Value is zero to push the argument on the stack,
   or a hard register in which to store the argument.

   MODE is the argument's machine mode.
   TYPE is the data type of the argument (as a tree).
    This is null for libcalls where that information may
    not be available.
   CUM is a variable of type CUMULATIVE_ARGS which gives info about
    the preceding args and about the function being called.
   NAMED is nonzero if this argument is a named parameter
    (otherwise it is an extra parameter matching an ellipsis).  */

/* On 80960 the first 12 args are normally in registers
   and the rest are pushed.  Any arg that is bigger than 4 words is placed
   on the stack and all subsequent arguments are placed on the stack
   Additionally, parameters wider than a single register must be aligned in
   the register set */
  
/* "(CUM) > (NPARM_REGS)" changed to ">=" because compiler was */
/* incorrectly placing an argument in register g12 - mcg, 1/7/89 */

#define FUNCTION_ARG(CUM, MODE, TYPE, NAMED)				\
	(((NAMED) == 0 || (CUM.ca_cum >= (NPARM_REGS)) ||		\
	  (FUNCTION_ARG_SIZE(MODE,TYPE) > 4)) ?				\
	    ((CUM.ca_nstackparms +=					\
		  (FUNCTION_ARG_ALIGN(CUM.ca_nstackparms,MODE,TYPE))), (rtx) 0)\
	  : gen_rtx(REG,(MODE),CUM.ca_nregparms =			\
		  CUM.ca_cum += FUNCTION_ARG_ALIGN(CUM.ca_cum, MODE, TYPE)))

/* Define where a function finds its arguments. */

/* #define FUNCTION_INCOMING_ARG(CUM, MODE, TYPE, NAMED) */

/* For an arg passed partly in registers and partly in memory,
   this is the number of registers used.
   This never happens on 80960 */
  
#define FUNCTION_ARG_PARTIAL_NREGS(CUM, MODE, TYPE, NAMED) 0


/* Output the label for a function definition.  */

#define ASM_DECLARE_FUNCTION_NAME(FILE, NAME, DECL)			\
	{ i960_function_name_declare(FILE, NAME, DECL); }

/* This macro generates the assembly code for function entry.
   FILE is a stdio stream to output the code to.
   SIZE is an int: how many units of temporary storage to allocate.
   Refer to the array `regs_ever_live' to determine which registers
   to save; `regs_ever_live[I]' is nonzero if register number I
   is ever used in the function.  This macro is responsible for
   knowing which registers should not be saved even if used.  */

#define FUNCTION_PROLOGUE(FILE, SIZE)					\
	{ i960_function_prologue(FILE,SIZE); }

/* Output assembler code to FILE to increment profiler label # LABELNO
   for profiling a function entry.  */

#define FUNCTION_PROFILER(FILE, LABELNO)  \
   {fprintf(FILE,"\tlda	LP%d,g0\n\tbal	mcount\n",LABELNO);}

/* EXIT_IGNORE_STACK should be nonzero if, when returning from a function,
   the stack pointer does not matter.  The value is tested only in
   functions that have frame pointers.
   No definition is equivalent to always zero.  */

#define	EXIT_IGNORE_STACK	1	/* never matters on 960 */

/* This macro generates the assembly code for function exit,
   on machines that need it.  If FUNCTION_EPILOGUE is not defined
   then individual return instructions are generated for each
   return statement.  Args are same as for FUNCTION_PROLOGUE.

   The function epilogue should not depend on the current stack pointer!
   It should use the frame pointer only.  This is mandatory because
   of alloca; we also take advantage of it to omit stack adjustments
   before returning.  */

/* This declaration is needed due to traditional/ANSI
   incompatibilities which cannot be #ifdefed away
   because they occur inside of macros.  Sigh.  */

extern union tree_node *current_function_decl;

#define FUNCTION_EPILOGUE(FILE, SIZE)					\
	{ i960_function_epilogue(FILE,SIZE); }

/* If the memory address ADDR is relative to the frame pointer,
   correct it to be relative to the stack pointer instead.
   This is for when we don't use a frame pointer.
   ADDR should be a variable name.  */

#define FIX_FRAME_POINTER_ADDRESS(ADDR,DEPTH)  \
{ int offset = -1;							\
  rtx regs = stack_pointer_rtx;						\
  if (ADDR == frame_pointer_rtx)					\
    offset = 0;								\
  else if (GET_CODE (ADDR) == PLUS && XEXP (ADDR, 0) == frame_pointer_rtx \
	   && GET_CODE (XEXP (ADDR, 1)) == CONST_INT)			\
    offset = INTVAL (XEXP (ADDR, 1));					\
  else if (GET_CODE (ADDR) == PLUS && XEXP (ADDR, 0) == frame_pointer_rtx) \
    { rtx other_reg = XEXP (ADDR, 1);					\
      offset = 0;							\
      regs = gen_rtx (PLUS, Pmode, stack_pointer_rtx, other_reg); }	\
  else if (GET_CODE (ADDR) == PLUS && XEXP (ADDR, 1) == frame_pointer_rtx) \
    { rtx other_reg = XEXP (ADDR, 0);					\
      offset = 0;							\
      regs = gen_rtx (PLUS, Pmode, stack_pointer_rtx, other_reg); }	\
  if (offset >= 0)							\
    { int regno;							\
      extern char call_used_regs[];					\
      for (regno = 0; regno < FIRST_PSEUDO_REGISTER; regno++)		\
        if (regs_ever_live[regno] && ! call_used_regs[regno])		\
          offset += 4;							\
      offset -= 4;							\
      ADDR = plus_constant (regs, offset + (DEPTH)); } }

/* Addressing modes, and classification of registers for them.  */

/* #define HAVE_POST_INCREMENT */
/* #define HAVE_POST_DECREMENT */

/* #define HAVE_PRE_DECREMENT */
/* #define HAVE_PRE_INCREMENT */

/* Macros to check register numbers against specific register classes.  */

/* These assume that REGNO is a hard or pseudo reg number.
   They give nonzero only if REGNO is a hard reg of the suitable class
   or a pseudo reg currently allocated to a suitable hard reg.
   Since they use reg_renumber, they are safe only once reg_renumber
   has been allocated, which happens in local-alloc.c.  */

#define REGNO_OK_FOR_INDEX_P(REGNO) \
	((REGNO) < 32 || (unsigned) reg_renumber[REGNO] < 32)
#define REGNO_OK_FOR_BASE_P(REGNO) \
	((REGNO) < 32 || (unsigned) reg_renumber[REGNO] < 32)
#define REGNO_OK_FOR_FP_P(REGNO) \
	((REGNO) < 36 || (unsigned) reg_renumber[REGNO] < 36)

/* Now macros that check whether X is a register and also,
   strictly, whether it is in a specified class.

   These macros are specific to the 960, and may be used only
   in code for printing assembler insns and in conditions for
   define_optimization.  */

/* 1 if X is an fp register.  */

#define FP_REG_P(X) (REGNO(X) >= 32 && REGNO(X) < 36)



/* Maximum number of registers that can appear in a valid memory address.  */
#define	MAX_REGS_PER_ADDRESS	2	/* base,index*/

#define CONSTANT_ADDRESS_P(X)  CONSTANT_P (X)

/* Nonzero if the constant value X is a legitimate general operand.
   It is given that X satisfies CONSTANT_P or is a CONST_DOUBLE.

   Anything but a CONST_DOUBLE can be made to work.  */

#define LEGITIMATE_CONSTANT_P(X)		\
	((GET_CODE (X) != CONST_DOUBLE) && (X != dconst0_rtx))

/* The macros REG_OK_FOR..._P assume that the arg is a REG rtx
   and check its validity for a certain class.
   We have two alternate definitions for each of them.
   The usual definition accepts all pseudo regs; the other rejects
   them unless they have been allocated suitable hard regs.
   The symbol REG_OK_STRICT causes the latter definition to be used.

   Most source files want to accept pseudo regs in the hope that
   they will get allocated to the class that the insn wants them to be in.
   Source files for reload pass need to be strict.
   After reload, it makes no difference, since pseudo regs have
   been eliminated by then.  */

#ifndef REG_OK_STRICT

/* Nonzero if X is a hard reg that can be used as an index
   or if it is a pseudo reg.  */
#define REG_OK_FOR_INDEX_P(X) (REGNO (X) >= 0)
/* Nonzero if X is a hard reg that can be used as a base reg
   or if it is a pseudo reg.  */
#define REG_OK_FOR_BASE_P(X) (REGNO (X) >= 0)

#define REG_OK_FOR_INDEX_P_STRICT(X) REGNO_OK_FOR_INDEX_P (REGNO (X))
#define REG_OK_FOR_BASE_P_STRICT(X) REGNO_OK_FOR_BASE_P (REGNO (X))

#else

/* Nonzero if X is a hard reg that can be used as an index.  */
#define REG_OK_FOR_INDEX_P(X) REGNO_OK_FOR_INDEX_P (REGNO (X))
/* Nonzero if X is a hard reg that can be used as a base reg.  */
#define REG_OK_FOR_BASE_P(X) REGNO_OK_FOR_BASE_P (REGNO (X))

#endif

/* GO_IF_LEGITIMATE_ADDRESS recognizes an RTL expression
   that is a valid memory address for an instruction.
   The MODE argument is the machine mode for the MEM expression
   that wants to use this address.

	On 80960, legitimate addresses are:
		disp	(12 or 32 bit)		ld	foo,r0
		base				ld	(g0),r0
		base + displ			ld	0xf00(g0),r0
		index*scale + displ		ld	0xf00[g1*4],r0
		base + index*scale		ld	(g0)[g1*4],r0
		base + index*scale + displ	ld	0xf00(g0)[g1*4],r0

	in each case, scale can be 1,2,4,8, or 16

   We can also treat a SYMBOL_REF as legitimate if it is part of this
   function's constant-pool, because such addresses can actually
   be output as REG+SMALLINT.  */


/* Returns 1 if the scale factor of an index term is valid. */
#define SCALE_TERM_P(X) \
  (INTVAL (X) == 1 || INTVAL (X) == 2 || INTVAL (X) == 4 		\
    || INTVAL(X) == 8 || INTVAL (X) == 16)


#ifdef REG_OK_STRICT
#define GO_IF_LEGITIMATE_ADDRESS(MODE, X, ADDR)  			\
	{ if (legitimate_address_p(MODE,X,1)) goto ADDR; }
#else
#define GO_IF_LEGITIMATE_ADDRESS(MODE, X, ADDR)  			\
	{ if (legitimate_address_p(MODE,X,0)) goto ADDR; }
#endif

/* Try machine-dependent ways of modifying an illegitimate address
   to be legitimate.  If we find one, return the new, valid address.
   This macro is used in only one place: `memory_address' in explow.c.

   OLDX is the address as it was before break_out_memory_refs was called.
   In some cases it is useful to look at this to decide what needs to be done.

   MODE and WIN are passed so that this macro can use
   GO_IF_LEGITIMATE_ADDRESS.

   It is always safe for this macro to do nothing.  It exists to recognize
   opportunities to optimize the output.  */

/* On 80960, change REG+N into REG+REG, and REG+(X*Y) into REG+REG.  */

#define LEGITIMIZE_ADDRESS(X,OLDX,MODE,WIN)	\
	{ extern rtx legitimize_address();			\
	(X) = legitimize_address(X,OLDX,MODE);			\
	if (memory_address_p(MODE,X))				\
		goto WIN; }

/* Go to LABEL if ADDR (a legitimate address expression)
   has an effect that depends on the machine mode it is used for.
   On the 960 this is never true.  */

#define GO_IF_MODE_DEPENDENT_ADDRESS(ADDR,LABEL)

/* Specify the machine mode that this machine uses
   for the index in the tablejump instruction.  */
#define CASE_VECTOR_MODE SImode

/* Define this if the tablejump instruction expects the table
   to contain offsets from the address of the table.
   Do not define this if the table should contain absolute addresses.  */
/* #define CASE_VECTOR_PC_RELATIVE */

/* Specify the tree operation to be used to convert reals to integers.  */
#define IMPLICIT_FIX_EXPR FIX_ROUND_EXPR

/* This is the kind of divide that is easiest to do in the general case.  */
#define EASY_DIV_EXPR TRUNC_DIV_EXPR

/* Define this as 1 if `char' should by default be signed; else as 0.  */
#define DEFAULT_SIGNED_CHAR 0

/* Max number of bytes we can move from memory to memory
   in one reasonably fast instruction.  */
#define MOVE_MAX 16

/* Nonzero if access to memory by bytes is slow and undesirable.  */
#define SLOW_BYTE_ACCESS 0

/* On Sun 4, this limit is 2048.  We use 2000 to be safe.  */
#define DBX_CONTIN_LENGTH 2000

/* We assume that the store-condition-codes instructions store 0 for false
   and some other value for true.  This is the value stored for true.  */

#define STORE_FLAG_VALUE 1

/* Define if shifts truncate the shift count
   which implies one can omit a sign-extension or zero-extension
   of a shift count.  */
#define SHIFT_COUNT_TRUNCATED

/* Value is 1 if truncating an integer of INPREC bits to OUTPREC bits
   is done just by pretending it is already truncated.  */
#define TRULY_NOOP_TRUNCATION(OUTPREC, INPREC) 1

/* Specify the machine mode that pointers have.
   After generation of rtl, the compiler makes no further distinction
   between pointers and any other objects of this machine mode.  */
#define Pmode SImode

/* Specify the widest mode that BLKmode objects can be promoted to */
#define	WIDEST_AGGREGATE_MODE	TImode	/* i960 specific (old) */
#define	MAX_FIXED_MODE_SIZE	GET_MODE_BITSIZE(TImode)	/* post 1.35 version */

/* A function address in a call instruction
   is a byte address (for indexing purposes)
   so give the MEM rtx a byte's mode.  */
#define FUNCTION_MODE SImode

/* Define this if addresses of constant functions
   shouldn't be put through pseudo regs where they can be cse'd.
   Desirable on machines where ordinary constants are expensive
   but a CALL with constant address is cheap.  */
#define NO_FUNCTION_CSE

/* use memcpy, etc instead of bcopy */

#ifndef WIND_RIVER
#define	TARGET_MEM_FUNCTIONS	1
#endif

/* promote char and short arguments to ints */

#define	PROMOTE_PROTOTYPES	1

/* Compute the cost of computing a constant rtl expression RTX
   whose rtx-code is CODE.  The body of this macro is a portion
   of a switch statement.  If the code is computed here,
   return it with a return statement.  Otherwise, break from the switch.  */

#define CONST_COSTS(RTX,CODE) \
	case CONST_INT:							\
		if (INTVAL (RTX) >= 0 && INTVAL (RTX) < 32)		\
			return 0; 					\
		if (power2_operand(RTX,VOIDmode))			\
			return 0;					\
		if (mask_operand(RTX,VOIDmode))				\
			return 0;					\
		if (INTVAL(RTX) < 0 && INTVAL(RTX) > -32)		\
			return 1;					\
		if (INTVAL (RTX) <= 62) 				\
			return 2;					\
	case CONST:							\
	case LABEL_REF:							\
	case SYMBOL_REF:						\
		return 3;						\
	case CONST_DOUBLE:						\
		return 4;

/* Costs for different instruction classes on the i960. These costs
 * assume a bypass hit.  The cost on most of them for a bypass miss
 * is one more, or so many more as not to be worth trying to recover
 * from.  These times are a condensation of the information found in
 * Appendix C of the 80960MC manual.
 *
 * The presence of C_ALU overrides the costs given in the sched.h file.
 */

#define C_ALU		1	/* 1 cycle ALU/logical instructions */
#define C_ALU2		2	/* 2 cycle ALU+logical instructions */
/* kludge to get around a kludge in the machine definition: */
#define C_ALUSEQ	3	/* 3 cycle ALU sequence instructions */

#define C_MEM		2	/* move single word (1 cycle) */
#define C_MEM2		2	/* move seq. of words (2 cycles) */
#define C_MEM3		3	/* move triple (3 cycles) */
#define C_MEM4		4	/* move quad (4 cycles) */

#define C_CMP		1	/* 1 cycle compare instructions */

#define C_MUL		5	/* this probably isn't recoverable... */
#define C_DIV		15	/* this probably isn't recoverable... */
#define C_FLOAT10	10	/* cheaper FP ops */
#define C_FLOAT25	25	/* expensive FP ops */
#define C_FCMP		10	/* cheaper FP ops */
#define C_FLTCMPLX	31	/* probably hopeless */

#define C_EXTRACT	7	/* extract instr */
#define C_BITMODSCAN	8	/* bit modify, scan, or span */

#define C_BR		1	/* these aren't reorderable anyway */
#define C_RET		1
#define C_NOP		1
#define C_CALL		1

#include "sched.h"

/* Tell final.c how to eliminate redundant test instructions.  */

/* Here we define machine-dependent flags and fields in cc_status
   (see `conditions.h').  */

#define	CC_T_OR_F	0x4000	/* condition code is true of false */
#define	CC_BITTEST	(CC_T_OR_F|CC_NOT_POSITIVE|CC_NOT_NEGATIVE|CC_NO_OVERFLOW)
#define CC_STATUS_AT_LABEL(INSN) CC_STATUS_INIT

/* Store in cc_status the expressions
   that the condition codes will describe
   after execution of an instruction whose pattern is EXP.
   Do not alter them if the instruction would not alter the cc's.  */

#define NOTICE_UPDATE_CC(EXP, INSN) \
{ 									\
	if (GET_CODE (EXP) == SET) { 					\
		if (GET_CODE (SET_DEST (EXP)) == CC0) { 		\
			cc_status.flags = 0;				\
			cc_status.value1 = SET_DEST (EXP);		\
			cc_status.value2 = SET_SRC (EXP);		\
		} else if (GET_CODE (SET_DEST (EXP)) == REG) { 		\
			if ((cc_status.value1 &&			\
			     reg_overlap_mentioned_p(SET_DEST (EXP),	\
			      cc_status.value1)))			\
				cc_status.value1 = 0;			\
			if ((cc_status.value2 &&			\
			     reg_overlap_mentioned_p (SET_DEST (EXP),	\
			      cc_status.value2)))			\
				cc_status.value2 = 0;			\
		} else if (GET_CODE (SET_DEST (EXP)) == MEM) { 		\
			CC_STATUS_INIT; 				\
		}							\
	} else if (GET_CODE (EXP) == PARALLEL				\
	     && GET_CODE (XVECEXP (EXP, 0, 0)) == SET) { 		\
		if (GET_CODE (SET_DEST (XVECEXP (EXP, 0, 0))) == CC0) {	\
			cc_status.flags = 0;				\
			cc_status.value1 = SET_DEST (XVECEXP (EXP, 0, 0));\
			cc_status.value2 = SET_SRC (XVECEXP (EXP, 0, 0));\
		} else if (GET_CODE (SET_DEST (XVECEXP (EXP, 0, 0))) == REG) {\
			if ((cc_status.value1 &&			\
			     reg_overlap_mentioned_p(SET_DEST(XVECEXP(EXP,0,0)),\
			     cc_status.value1)))			\
				cc_status.value1 = 0;			\
			if ((cc_status.value2 &&			\
			     reg_overlap_mentioned_p(SET_DEST(XVECEXP(EXP,0,0)),\
			      cc_status.value2)))			\
				cc_status.value2 = 0;			\
		} else if (GET_CODE (SET_DEST (XVECEXP (EXP, 0, 0))) == MEM) {\
			CC_STATUS_INIT; 				\
		}							\
	} else if (GET_CODE (EXP) == CALL) { /* all bets are off */	\
		CC_STATUS_INIT; 					\
	}								\
	if (cc_status.value1 && GET_CODE (cc_status.value1) == REG	\
	     && cc_status.value2					\
	     && reg_overlap_mentioned_p (cc_status.value1, cc_status.value2))\
		printf ("here!\n", cc_status.value2 = 0);		\
}




/* Control the assembler format that we output.  */

/* Output at beginning of assembler file.  */

#define ASM_FILE_START(file) 					\
	i960_asm_file_start(file)

/* Output to assembler file text saying following lines
   may contain character constants, extra white space, comments, etc.  */

#define ASM_APP_ON ""

/* Output to assembler file text saying following lines
   no longer contain unusual constructs.  */

#define ASM_APP_OFF ""

/* Output before read-only data.  */

#define TEXT_SECTION_ASM_OP ".text"

/* Output before writable data.  */

#define DATA_SECTION_ASM_OP ".data"

/* How to refer to registers in assembler output.
   This sequence is indexed by compiler's hard-register-number (see above).  */
/* note that register 16 is really pfp, but we hijack it for the constant
   zero register */


#define REGISTER_NAMES {						\
	"g0", "g1", "g2",  "g3",  "g4",  "g5",  "g6",  "g7",		\
	"g8", "g9", "g10", "g11", "g12", "g13", "g14", "fp",		\
	/* pfp */ "g14","sp", "rip", "r3",  "r4",  "r5",  "r6",  "r7",	\
	"r8", "r9", "r10", "r11", "r12", "r13", "r14", "r15",		\
	"fp0","fp1","fp2", "fp3" }

/* How to renumber registers for dbx and gdb.  */
/* in 960 encoding, g0..g15 are registers 16..31 */

#define DBX_REGISTER_NUMBER(REGNO)					\
	(((REGNO) < 16) ? (REGNO)+16 :					\
		(((REGNO) > 31) ? (REGNO) : (REGNO)-16))

/* This is how to output a note to DBX telling it the line number
   to which the following sequence of instructions corresponds. */

#define ASM_OUTPUT_SOURCE_LINE(file, line)			\
  { if (write_symbols == SDB_DEBUG) {				\
	fprintf (file, "\t.ln	%d\n",				\
		sdb_begin_function_line ?			\
			line - sdb_begin_function_line : 1);	\
  } else if (write_symbols == DBX_DEBUG) {			\
	fprintf(file,"\t.stabd	68,0,%d\n",line);		\
  } else if (write_symbols == NO_DEBUG) {			\
	fprintf(file, "\t\t# \"%s\" %d\n",file,line);		\
  } }

/* This is how to output the definition of a user-level label named NAME,
   such as the label on a static function or variable NAME.  */

#define ASM_OUTPUT_LABEL(FILE,NAME)	\
  do { assemble_name (FILE, NAME); fputs (":\n", FILE); } while (0)

/* This is how to output a command to make the user-level label named NAME
   defined for reference from other files.  */

#define ASM_GLOBALIZE_LABEL(FILE,NAME)				\
	if (1) {fputs ("\t.globl ", FILE);			\
		assemble_name (FILE, NAME);			\
		fputs ("\n", FILE);} else

/* This is how to output a reference to a user-level label named NAME.
   `assemble_name' uses this.  */

#define ASM_OUTPUT_LABELREF(FILE,NAME)	\
	fprintf (FILE, "_%s", NAME)

/* This is how to output an internal numbered label where
   PREFIX is the class of label and NUM is the number within the class.  */

#define ASM_OUTPUT_INTERNAL_LABEL(FILE,PREFIX,NUM)	\
	fprintf (FILE, "%s%d:\n", PREFIX, NUM)

/* This is how to store into the string LABEL
   the symbol_ref name of an internal numbered label where
   PREFIX is the class of label and NUM is the number within the class.
   This is suitable for output with `assemble_name'.  */

#define ASM_GENERATE_INTERNAL_LABEL(LABEL,PREFIX,NUM)	\
	sprintf (LABEL, "*%s%d", PREFIX, NUM)

/* This is how to output an assembler line defining a `double' constant.  */

#define ASM_OUTPUT_DOUBLE(FILE,VALUE)  \
	fprintf (FILE, "\t.double 0d%.20e\n", (VALUE))

/* This is how to output an assembler line defining a `float' constant.  */

#define ASM_OUTPUT_FLOAT(FILE,VALUE)  \
	fprintf (FILE, "\t.float 0f%.12e\n", (VALUE))

/* This is how to output an assembler line defining an `int' constant.  */

#define ASM_OUTPUT_INT(FILE,VALUE)  \
	( fprintf (FILE, "\t.word "),			\
	  output_addr_const (FILE, (VALUE)),		\
	  fprintf (FILE, "\n"))

/* Likewise for `char' and `short' constants.  */

#define ASM_OUTPUT_SHORT(FILE,VALUE)  \
	( fprintf (FILE, "\t.short "),			\
	  output_addr_const (FILE, (VALUE)),		\
	  fprintf (FILE, "\n"))

#define ASM_OUTPUT_CHAR(FILE,VALUE)  \
	( fprintf (FILE, "\t.byte "),			\
	  output_addr_const (FILE, (VALUE)),		\
	  fprintf (FILE, "\n"))

/* This is how to output an assembler line for a numeric constant byte.  */

#define ASM_OUTPUT_BYTE(FILE,VALUE)  \
	fprintf (FILE, "\t.byte 0x%x\n", (VALUE))

#define ASM_OUTPUT_REG_PUSH(FILE,REGNO)  \
  fprintf (FILE, "\tst\t%s,(sp)\n\taddo\t4,sp,sp\n", reg_names[REGNO])

/* This is how to output an insn to pop a register from the stack.
   It need not be very fast code.  */

#define ASM_OUTPUT_REG_POP(FILE,REGNO)  \
  fprintf (FILE, "\tsubo\t4,sp,sp\n\tld\t(sp),%s\n", reg_names[REGNO])

/* This is how to output an element of a case-vector that is absolute.  */

#define ASM_OUTPUT_ADDR_VEC_ELT(FILE, VALUE)  \
	fprintf (FILE, "\t.word L%d\n", VALUE)

/* This is how to output an element of a case-vector that is relative. */

#define ASM_OUTPUT_ADDR_DIFF_ELT(FILE, VALUE, REL)  \
	fprintf (FILE, "\t.word L%d-L%d\n", VALUE, REL)

/* This is how to output an assembler line
   that says to advance the location counter
   to a multiple of 2**LOG bytes.  */

#define ASM_OUTPUT_ALIGN(FILE,LOG)	\
	if ((LOG) != 0) fprintf (FILE, "\t.align %d\n", (LOG))

#define ASM_OUTPUT_SKIP(FILE,SIZE)  \
	fprintf (FILE, "\t.space %d\n", (SIZE))

/* This says how to output an assembler line
   to define a global common symbol.  */

#define ASM_OUTPUT_COMMON(FILE, NAME, SIZE, ROUNDED)  \
	( fputs (".globl ", (FILE)),			\
	  assemble_name ((FILE), (NAME)),		\
	  fputs ("\n.comm ", (FILE)),			\
	  assemble_name ((FILE), (NAME)),		\
	  fprintf ((FILE), ",%d\n", (ROUNDED)))

/* This says how to output an assembler line
   to define a local common symbol.  */

#define ASM_OUTPUT_LOCAL(FILE, NAME, SIZE, ROUNDED)  \
	( fputs ("\n.bss\t", (FILE)),			\
	  assemble_name ((FILE), (NAME)),		\
	  fprintf ((FILE), ",%d,%d	# %d\n",ROUNDED,\
		((ROUNDED) < 2 ? 0 : ((ROUNDED) < 4 ? 1 : \
		(ROUNDED) < 8 ? 2 : (ROUNDED) < 16 ? 3 : 4)), SIZE))

#define	ASM_OUTPUT_IDENT(FILE, STR)					\
	(fputs("\t# ",FILE), fputs(STR,FILE))

extern int i960_loop_level;

#define	ASM_OUTPUT_ALIGN_CODE(FILE)		\
	if (TARGET_CODE_ALIGN) fputs("\t.align 3\n",FILE);
#define	ASM_OUTPUT_NOTE_LOOP_BEG(FILE,INSN)		\
	fprintf(FILE,"\n\t# loop begin %d {\n",++i960_loop_level)
#define	ASM_OUTPUT_NOTE_LOOP_END(FILE,INSN)		\
	fprintf(FILE,"\t# } loop end %d\n\n",i960_loop_level--)
#define	ASM_OUTPUT_NOTE_LOOP_CONT(FILE,INSN)		\
	fputs("\n\t# loop continue\n",FILE)

/* Store in OUTPUT a string (made with alloca) containing
   an assembler-name for a local static variable named NAME.
   LABELNO is an integer which is different for each call.  */

#define ASM_FORMAT_PRIVATE_NAME(OUTPUT, NAME, LABELNO)	\
	( (OUTPUT) = (char *) alloca (strlen ((NAME)) + 10),	\
	  sprintf ((OUTPUT), "%s.%d", (NAME), (LABELNO)))


/* Define the parentheses used to group arithmetic operations
   in assembler code.  */

#define ASM_OPEN_PAREN "("
#define ASM_CLOSE_PAREN ")"

/* Define results of standard character escape sequences.  */
#define TARGET_BELL	007
#define TARGET_BS	010
#define TARGET_TAB	011
#define TARGET_NEWLINE	012
#define TARGET_VT	013
#define TARGET_FF	014
#define TARGET_CR	015

/* Make a last pass over instructions before they are output
 */

#define	FINAL_PRESCAN_INSN(INSN, OPVEC, NOPERANDS) \
	i960_final_prescan_insn(INSN,OPVEC,NOPERANDS)


/* Print operand X (an rtx) in assembler syntax to file FILE.
   CODE is a letter or dot (`z' in `%z0') or 0 if no letter was specified.
   For `%' followed by punctuation, CODE is the punctuation and X is null.
*/

#define PRINT_OPERAND(FILE, X, CODE)  \
	i960_print_operand(FILE,X,CODE);


/* Print a memory address as an operand to reference that memory location.  */

#define PRINT_OPERAND_ADDRESS(FILE, ADDR)			\
	i960_print_operand_addr(FILE,ADDR)

/* Define MAX_INSNS_PER_SPLIT to be the maximum number of instructions
   that might be generated as a consequence of a define_split in the machine
   definition.  On most architectures, the value will be 1 */
#define MAX_INSNS_PER_SPLIT 1

/* Define DBR_SLOTS_AFTER to be the number of slots availible
   after INSN.  Non-zero values for this macro deliniate delayed
   branch blocks.  */
/* On the 80960, there are no delay slots, so make this 0 */
#define DBR_SLOTS_AFTER(INSN) 0

/* Define DBR_INSN_ELIGIBLE_P to return true if INSN may be put in a
   delay slot.  */
/* on the 80960, there are no delay slots, so make this 0 to be sure. */
#define DBR_INSN_ELIGIBLE_P(INSN, DINSN) 0

/* Define DBR_INSN_SLOTS to return the number of insns which INSN will
   return.  */

/* On the 80960, there aren't any delay slots, so this should be 0 */
#define	DBR_INSN_SLOTS(INSN) 0

