/* Conversion of files between different charsets and usages.
   Copyright (C) 1990 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1988.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define STEP	latin1_texte
#include <stdio.h>
#include "common.h"

static const char *translation_table[128] =
  {
    NULL,			/* \200 */
    NULL,			/* \201 */
    NULL,			/* \202 */
    NULL,			/* \203 */
    NULL,			/* \204 */
    NULL,			/* \205 */
    NULL,			/* \206 */
    NULL,			/* \207 */
    NULL,			/* \210 */
    NULL,			/* \211 */
    NULL,			/* \212 */
    NULL,			/* \213 */
    NULL,			/* \214 */
    NULL,			/* \215 */
    NULL,			/* \216 */
    NULL,			/* \217 */
    NULL,			/* \220 */
    NULL,			/* \221 */
    NULL,			/* \222 */
    NULL,			/* \223 */
    NULL,			/* \224 */
    NULL,			/* \225 */
    NULL,			/* \226 */
    NULL,			/* \227 */
    NULL,			/* \230 */
    NULL,			/* \231 */
    NULL,			/* \232 */
    NULL,			/* \233 */
    NULL,			/* \234 */
    NULL,			/* \235 */
    NULL,			/* \236 */
    NULL,			/* \237 */

    " ",			/* \240 no-break space */
    NULL,			/* \241 inverted exclamation mark */
    NULL,			/* \242 cent sign */
    NULL,			/* \243 pound sign */
    NULL,			/* \244 currency sign */
    NULL,			/* \245 yen sign */
    NULL,			/* \246 broken bar */
    NULL,			/* \247 paragraph sign, section sign */
    NULL,			/* \250 diaeresis */
    NULL,			/* \251 copyright sign */
    NULL,			/* \252 feminine ordinal indicator */
    "``",			/* \253 left angle quotation mark */
    NULL,			/* \254 not sign */
    NULL,			/* \255 soft hyphen */
    NULL,			/* \256 registered trade mark sign */
    NULL,			/* \257 macron */
    NULL,			/* \260 degree sign */
    NULL,			/* \261 plus-minus sign */
    NULL,			/* \262 superscript two */
    NULL,			/* \263 superscript three */
    NULL,			/* \264 acute accent */
    NULL,			/* \265 small greek mu, micro sign */
    NULL,			/* \266 pilcrow sign */
    NULL,			/* \267 middle dot */
    NULL,			/* \270 cedilla */
    NULL,			/* \271 superscript one */
    NULL,			/* \272 masculine ordinal indicator */
    "''",			/* \273 right angle quotation mark */
    NULL,			/* \274 vulgar fraction one quarter */
    NULL,			/* \275 vulgar fraction one half */
    NULL,			/* \276 vulgar fraction three quarters */
    NULL,			/* \277 inverted question mark */
    "A`",			/* \300 capital A with grave accent */
    NULL,			/* \301 capital A with acute accent */
    "A^",			/* \302 capital A with circumflex accent */
    NULL,			/* \303 capital A with tilde */
    "A\"",			/* \304 capital A diaeresis */
    NULL,			/* \305 capital A with ring above */
    NULL,			/* \306 capital diphthong A with E */
    "C,",			/* \307 capital C with cedilla */
    "E`",			/* \310 capital E with grave accent */
    "E\'",			/* \311 capital E with acute accent */
    "E^",			/* \312 capital E with circumflex accent */
    "E\"",			/* \313 capital E with diaeresis */
    NULL,			/* \314 capital I with grave accent */
    NULL,			/* \315 capital I with acute accent */
    "I^",			/* \316 capital I with circumflex accent */
    "I\"",			/* \317 capital I with diaeresis */
    NULL,			/* \320 capital icelandic ETH */
    NULL,			/* \321 capital N with tilde */
    "O`",			/* \322 capital O with grave accent */
    NULL,			/* \323 capital O with acute accent */
    "O^",			/* \324 capital O with circumflex accent */
    NULL,			/* \325 capital O with tilde */
    "O\"",			/* \326 capital O with diaeresis */
    NULL,			/* \327 multiplication sign */
    NULL,			/* \330 capital O with oblique stroke */
    "U`",			/* \331 capital U with grave accent */
    NULL,			/* \332 capital U with acute accent */
    "U^",			/* \333 capital U with circumflex accent */
    "U\"",			/* \334 capital U with diaeresis */
    NULL,			/* \335 capital Y with acute accent */
    NULL,			/* \336 capital icelandic THORN */
    NULL,			/* \337 small german sharp s */
    "a`",			/* \340 small a with grave accent */
    NULL,			/* \341 small a with acute accent */
    "a^",			/* \342 small a with circumflex accent */
    NULL,			/* \343 small a with tilde */
    "a\"",			/* \344 small a with diaeresis */
    NULL,			/* \345 small a with ring above */
    NULL,			/* \346 small diphthong a with e */
    "c,",			/* \347 small c with cedilla */
    "e`",			/* \350 small e with grave accent */
    "e\'",			/* \351 small e with acute accent */
    "e^",			/* \352 small e with circumflex accent */
    "e\"",			/* \353 small e with diaeresis */
    NULL,			/* \354 small i with grave accent */
    NULL,			/* \355 small i with acute accent */
    "i^",			/* \356 small i with circumflex accent */
    "i\"",			/* \357 small i with diaeresis */
    NULL,			/* \360 small icelandic eth */
    NULL,			/* \361 small n with tilde */
    "o`",			/* \362 small o with grave accent */
    NULL,			/* \363 small o with acute accent */
    "o^",			/* \364 small o with circumflex accent */
    NULL,			/* \365 small o with tilde */
    "o\"",			/* \366 small o with diaeresis */
    NULL,			/* \367 division sign */
    NULL,			/* \370 small o with oblique stroke */
    "u`",			/* \371 small u with grave accent */
    NULL,			/* \372 small u with acute accent */
    "u^",			/* \373 small u with circumflex accent */
    "u\"",			/* \374 small u with diaeresis */
    NULL,			/* \375 small y with acute accent */
    NULL,			/* \376 small icelandic thorn */
    NULL,			/* \377 small y with diaeresis */
  };

void
STEP (FILE *input_file, FILE *output_file)
{
  int input_char;		/* current character */
  const char *output_string;	/* translated characters */

  while (input_char = getc (input_file), input_char != EOF)
    if ((input_char & 0377) < 0200)
      putc (input_char, output_file);
    else
      if (output_string = translation_table[input_char & 0177], output_string)
	while (*output_string)
	  {
	    putc (*output_string, output_file);
	    output_string++;
	  }
}
