/* Conversion of files between different charsets and usages.
   Copyright (C) 1990 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1988.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define STEP	ibmpc_applemac
#include <stdio.h>
#include "common.h"

#define DOS_EOF	0x1A		/* MS-DOS old end-of-file */

static unsigned char translation_table[256] = 
  {
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11, /* 11 */ 
     12,  13,  14,  15,  16,  17,  18,  19,  20,  21,  22,  23, /* 23 */ 
     24,  25,  26,  27,  28,  29,  30,  31,  32,  33,  34,  35, /* 35 */ 
     36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, /* 47 */ 
     48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59, /* 59 */ 
     60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71, /* 71 */ 
     72,  73,  74,  75,  76,  77,  78,  79,  80,  81,  82,  83, /* 83 */ 
     84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, /* 95 */ 
     96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, /* 107 */
    108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, /* 119 */
    120, 121, 122, 123, 124, 125, 126, 127, 130, 159, 142, 137, /* 131 */
    138, 136, 140, 141, 144, 145, 143, 149, 148, 147, 128, 129, /* 143 */
    131, 190, 174, 153, 154, 152, 158, 157,   0, 133, 134, 162, /* 155 */
    163, 180,   0, 196, 135, 146, 151, 156, 150, 132, 187, 188, /* 167 */
    192, 169, 170, 171, 172, 193, 199, 200,   0,   0,   0,   0, /* 179 */
      0,   0,   0,   0, 184,   0, 186,   0,   0,   0,   0, 191, /* 191 */
      0,   0, 194, 195,   0,   0, 198,   0,   0, 201, 202, 203, /* 203 */
    204, 205, 206, 207, 208, 209, 210, 211, 212, 213,   0, 215, /* 215 */
    216, 217, 218, 219, 220, 221, 222, 223, 224, 167, 226, 185, /* 227 */
    183, 229, 181, 231, 232, 233, 189, 182, 176, 237, 238, 239, /* 239 */
    240, 177, 179, 178, 244, 245, 214, 197, 161, 249, 165, 251, /* 251 */
    252, 253, 254, 255,
  };

void
STEP (FILE *input_file, FILE *output_file)
{
  int input_char;		/* current character */
  int output_char;		/* translated character */

  input_char = getc (input_file);
  while (input_char != EOF && input_char != DOS_EOF)
    if (input_char == 0x0D)
      {
	input_char = getc (input_file);
	if (input_char == 0x0A)
	  {
	    putc ('\n', output_file);
	    input_char = getc (input_file);
	  }
	else
	  putc (0x0D, output_file);
      }
    else
      {
	if ((output_char = translation_table[input_char]) != '\0')
	  putc (output_char, output_file);
	input_char = getc (input_file);
      }
}
