/* Conversion of files between different charsets and usages.
   Copyright (C) 1990 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1988.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define STEP	ascii_cdcnos
#include <stdio.h>
#include "common.h"

static const char *translation_table[128] =
  {
    "^5",			/* \000 */
    "^6",			/* \001 */
    "^7",			/* \002 */
    "^8",			/* \003 */
    "^9",			/* \004 */
    "^+",			/* \005 */
    "^-",			/* \006 */
    "^*",			/* \007 */
    "^/",			/* \010 */
    "^(",			/* \011 */
    "^)",			/* \012 */
    "^$",			/* \013 */
    "^=",			/* \014 */
    "^ ",			/* \015 */
    "^,",			/* \016 */
    "^.",			/* \017 */
    "^#",			/* \020 */
    "^[",			/* \021 */
    "^]",			/* \022 */
    "^%",			/* \023 */
    "^\"",			/* \024 */
    "^_",			/* \025 */
    "^!",			/* \026 */
    "^&",			/* \027 */
    "^'",			/* \030 */
    "^?",			/* \031 */
    "^<",			/* \032 */
    "^>",			/* \033 */
    "^@",			/* \034 */
    "^\\",			/* \035 */
    "^^",			/* \036 */
    "^;",			/* \037 */
    " ",			/* \040 */
    "!",			/* \041 */
    "\"",			/* \042 */
    "#",			/* \043 */
    "$",			/* \044 */
    "%",			/* \045 */
    "&",			/* \046 */
    "'",			/* \047 */
    "(",			/* \050 */
    ")",			/* \051 */
    "*",			/* \052 */
    "+",			/* \053 */
    ",",			/* \054 */
    "-",			/* \055 */
    ".",			/* \056 */
    "/",			/* \057 */
    "0",			/* \060 */
    "1",			/* \061 */
    "2",			/* \062 */
    "3",			/* \063 */
    "4",			/* \064 */
    "5",			/* \065 */
    "6",			/* \066 */
    "7",			/* \067 */
    "8",			/* \070 */
    "9",			/* \071 */
    "@D",			/* \072 */
    ";",			/* \073 */
    "<",			/* \074 */
    "=",			/* \075 */
    ">",			/* \076 */
    "?",			/* \077 */
    "@A",			/* \100 */
    "A",			/* \101 */
    "B",			/* \102 */
    "C",			/* \103 */
    "D",			/* \104 */
    "E",			/* \105 */
    "F",			/* \106 */
    "G",			/* \107 */
    "H",			/* \110 */
    "I",			/* \111 */
    "J",			/* \112 */
    "K",			/* \113 */
    "L",			/* \114 */
    "M",			/* \115 */
    "N",			/* \116 */
    "O",			/* \117 */
    "P",			/* \120 */
    "Q",			/* \121 */
    "R",			/* \122 */
    "S",			/* \123 */
    "T",			/* \124 */
    "U",			/* \125 */
    "V",			/* \126 */
    "W",			/* \127 */
    "X",			/* \130 */
    "Y",			/* \131 */
    "Z",			/* \132 */
    "[",			/* \133 */
    "\\",			/* \134 */
    "]",			/* \135 */
    "@B",			/* \136 */
    "_",			/* \137 */
    "@G",			/* \140 */
    "^A",			/* \141 */
    "^B",			/* \142 */
    "^C",			/* \143 */
    "^D",			/* \144 */
    "^E",			/* \145 */
    "^F",			/* \146 */
    "^G",			/* \147 */
    "^H",			/* \150 */
    "^I",			/* \151 */
    "^J",			/* \152 */
    "^K",			/* \153 */
    "^L",			/* \154 */
    "^M",			/* \155 */
    "^N",			/* \156 */
    "^O",			/* \157 */
    "^P",			/* \160 */
    "^Q",			/* \161 */
    "^R",			/* \162 */
    "^S",			/* \163 */
    "^T",			/* \164 */
    "^U",			/* \165 */
    "^V",			/* \166 */
    "^W",			/* \167 */
    "^X",			/* \170 */
    "^Y",			/* \171 */
    "^Z",			/* \172 */
    "^0",			/* \173 */
    "^1",			/* \174 */
    "^2",			/* \175 */
    "^3",			/* \176 */
    "^4",			/* \177 */
  };

void
STEP (FILE *input_file, FILE *output_file)
{
  int input_char;		/* current character */
  const char *output_string;	/* translated characters */

  while (input_char = getc (input_file), input_char != EOF)
    if (input_char == '\n')
      putc ('\n', output_file);
    else if (input_char & 0200)
      putc (input_char, output_file);
    else if (output_string = translation_table[input_char], output_string)
      while (*output_string)
	{
	  putc (*output_string, output_file);
	  output_string++;
	}
}
