/* sub.c -- simple filter for 8 bit images or any 8 bit "smooth" data
 * Written by Arthur David Olson <ado@elsie.nci.nih.gov>
 *
 * sub can improve compression of 8 bit images or any 8 bit "smooth" data.
 * It simply emits on stdout the differences between successive bytes
 * read from stdin. For compression, use:
 *   sub < raw_data | gzip > data.sub.gz
 * For decompression, use:
 *   gunzip < data.sub.gz | add > raw_data
 *
 * This program can easily be extended to handle 24 bit images, or
 * sequences of slowly varying floating point numbers.
 */

#include "stdio.h"

main()
{
    int	c;
    int	prevc = 0;

    while ((c = getchar()) != EOF) {
	(void) putchar((c - prevc) & 0xff);
	prevc = c;
    }
    exit(0);
    return 0; /* just to avoid warnings */
}
