/* A lexical scanner generated by flex */

/* Scanner skeleton version:
 * $Header: flex.skl,v 1.2 94/01/04 14:33:15 vern Exp $
 */

#define FLEX_SCANNER

#include <stdio.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#include <unistd.h>

/* Use prototypes in function declarations. */
#define YY_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#ifdef __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */


#ifdef __TURBOC__
#define YY_USE_CONST
#endif


#ifndef YY_USE_CONST
#ifndef const
#define const
#endif
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN NXlex__start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.
 */
#define YY_START ((NXlex__start - 1) / 2)

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file".  Now included
 * only for backward compatibility with previous versions of flex.
 */
#define YY_NEW_FILE NXlex_restart( NXlex_in )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define YY_BUF_SIZE 16384

typedef struct NXlex__buffer_state *YY_BUFFER_STATE;

extern int NXlex_leng;
extern FILE *NXlex_in, *NXlex_out;

#ifdef __cplusplus
extern "C" {
#endif
	extern int NXlex_wrap YY_PROTO(( void ));
#ifdef __cplusplus
	}
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		NXlex_less( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the NXlex_less() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define NXlex_less(n) \
	do \
		{ \
		/* Undo effects of setting up NXlex_text. */ \
		*NXlex__cp = NXlex__hold_char; \
		NXlex__c_buf_p = NXlex__cp = NXlex__bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up NXlex_text again */ \
		} \
	while ( 0 )

#define unput(c) NXlex_unput( c, NXlex_text_ptr )


struct NXlex__buffer_state
	{
	FILE *NXlex__input_file;

	char *NXlex__ch_buf;		/* input buffer */
	char *NXlex__buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int NXlex__buf_size;

	/* Number of characters read into NXlex__ch_buf, not including EOB
	 * characters.
	 */
	int NXlex__n_chars;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int NXlex__is_interactive;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int NXlex__fill_buffer;

	/* Whether we've seen an EOF on this buffer. */
	int NXlex__eof_status;
#define EOF_NOT_SEEN 0
	/* "Pending" happens when the EOF has been seen but there's still
	 * some text to process.  Note that when we actually see the EOF,
	 * we switch the status back to "not seen" (via NXlex_restart()), so
	 * that the user can continue scanning by just pointing NXlex_in at
	 * a new input file.
	 */
#define EOF_PENDING 1
	};

static YY_BUFFER_STATE NXlex__current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER NXlex__current_buffer


/* NXlex__hold_char holds the character lost when NXlex_text is formed. */
static char NXlex__hold_char;

static int NXlex__n_chars;		/* number of characters read into NXlex__ch_buf */


int NXlex_leng;

/* Points to current character in buffer. */
static char *NXlex__c_buf_p = (char *) 0;
static int NXlex__init = 1;		/* whether we need to initialize */
static int NXlex__start = 0;	/* start state number */

/* Flag which is used to allow NXlex_wrap()'s to do buffer switches
 * instead of setting up a fresh NXlex_in.  A bit of a hack ...
 */
static int NXlex__did_buffer_switch_on_eof;

static void NXlex_unput YY_PROTO(( int c, char *buf_ptr ));
void NXlex_restart YY_PROTO(( FILE *input_file ));
void NXlex__switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void NXlex__load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE NXlex__create_buffer YY_PROTO(( FILE *file, int size ));
void NXlex__delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void NXlex__init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));

static int NXlex__start_stack_ptr = 0;
static int NXlex__start_stack_depth = 0;
static int *NXlex__start_stack = 0;
static void NXlex__push_state YY_PROTO(( int new_state ));
static void NXlex__pop_state YY_PROTO(( void ));
static int NXlex__top_state YY_PROTO(( void ));

#ifndef NXlex_text_ptr
static void NXlex__flex_strcpy YY_PROTO(( char *, const char * ));
#endif

static void *NXlex__flex_alloc YY_PROTO(( unsigned int ));
static void *NXlex__flex_realloc YY_PROTO(( void *ptr, unsigned int ));
static void NXlex__flex_free YY_PROTO(( void * ));

#define NXlex__new_buffer NXlex__create_buffer

#define INITIAL 0
#define parse 1
#define comment 2
#define token 3
typedef unsigned char YY_CHAR;
typedef int NXlex__state_type;
FILE *NXlex_in = (FILE *) 0, *NXlex_out = (FILE *) 0;
extern char *NXlex_text;
#define NXlex_text_ptr NXlex_text

#ifdef __cplusplus
static int NXlex_input YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif

static NXlex__state_type NXlex__get_previous_state YY_PROTO(( void ));
static NXlex__state_type NXlex__try_NUL_trans YY_PROTO(( NXlex__state_type current_state ));
static int NXlex__get_next_buffer YY_PROTO(( void ));
static void NXlex__fatal_error YY_PROTO(( const char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up NXlex_text.
 */
#define YY_DO_BEFORE_ACTION \
	NXlex_text_ptr = NXlex__bp; \
	NXlex_leng = NXlex__cp - NXlex__bp; \
	NXlex__hold_char = *NXlex__cp; \
	*NXlex__cp = '\0'; \
	NXlex__c_buf_p = NXlex__cp;

#define YY_END_OF_BUFFER 18
static const short int NXlex__accept[36] =
    {   0,
        0,    0,    8,    8,    2,    2,    0,    0,   18,   17,
        8,    9,   10,   17,    7,    6,   11,    2,    4,    3,
       16,   13,   12,   17,    8,    1,   11,    2,    3,    3,
        5,   16,   15,   14,    0
    } ;

static const int NXlex__ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    4,    1,    1,    1,    1,    1,    1,
        1,    5,    1,    1,    1,    1,    6,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    7,    1,
        8,    1,    1,    1,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        1,   10,    1,    1,    1,    1,   11,   11,    9,    9,

        9,   11,    9,    9,    9,    9,    9,    9,    9,   11,
        9,    9,    9,   11,    9,   11,    9,   11,    9,    9,
        9,    9,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static const int NXlex__meta[12] =
    {   0,
        1,    1,    2,    3,    4,    1,    1,    1,    5,    3,
        5
    } ;

static const short int NXlex__base[44] =
    {   0,
        0,    0,    0,    0,    9,   12,   15,   23,   23,   75,
       20,   75,   75,   16,   75,   75,    0,    0,   75,   29,
        0,   75,   75,    9,   14,   75,    0,    0,   31,   33,
       75,    0,   75,   75,   75,   39,   44,   49,    8,   54,
       59,   64,   69
    } ;

static const short int NXlex__def[44] =
    {   0,
       36,   36,   35,    3,   37,   37,   38,   38,   35,   35,
       35,   35,   35,   35,   35,   35,   39,   40,   35,   41,
       42,   35,   35,   43,   35,   35,   39,   40,   41,   41,
       35,   42,   35,   35,    0,   35,   35,   35,   35,   35,
       35,   35,   35
    } ;

static const short int NXlex__nxt[87] =
    {   0,
       10,   11,   12,   13,   10,   14,   15,   16,   17,   10,
       17,   19,   27,   20,   19,   25,   20,   22,   23,   34,
       26,   25,   35,   35,   24,   22,   23,   35,   35,   35,
       35,   35,   24,   30,   31,   35,   35,   30,   31,   10,
       10,   10,   10,   10,   18,   18,   18,   18,   18,   21,
       21,   21,   21,   21,   28,   35,   28,   35,   28,   29,
       35,   29,   29,   29,   32,   35,   35,   32,   32,   33,
       33,   33,   33,   33,    9,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35
    } ;

static const short int NXlex__chk[87] =
    {   0,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    5,   39,    5,    6,   25,    6,    7,    7,   24,
       14,   11,    9,    0,    7,    8,    8,    0,    0,    0,
        0,    0,    8,   20,   20,   29,   29,   30,   30,   36,
       36,   36,   36,   36,   37,   37,   37,   37,   37,   38,
       38,   38,   38,   38,   40,    0,   40,    0,   40,   41,
        0,   41,   41,   41,   42,    0,    0,   42,   42,   43,
       43,   43,   43,   43,   35,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35
    } ;

static NXlex__state_type NXlex__last_accepting_state;
static char *NXlex__last_accepting_cpos;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define NXlex_more() NXlex_more_used_but_not_detected
#define YY_MORE_ADJ 0
char *NXlex_text;
# line 1 "NXStringTable_scan.l"
# line 2 "NXStringTable_scan.l"

#ifdef HAVE_FLEX
#define YY_DECL int NXtable_scan(FILE *NXscan_in, \
		FILE *NXscan_out, const char **buffer)
#endif
#define MAX_STRINGTABLE_LENGTH	1024
#define KEY	1
#define VALUE	2

#define NXlex_terminate() {got = 0; line = 1; return YY_NULL;}
#define return_err() {got = 0; line = 1; return -1;}
#define return_ok() {return 1;}


/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( NXlex_text, NXlex_leng, 1, NXlex_out )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( NXlex__current_buffer->NXlex__is_interactive ) \
		{ \
		int c = getc( NXlex_in ); \
		result = c == EOF ? 0 : 1; \
		buf[0] = (char) c; \
		} \
	else if ( ((result = fread( buf, 1, max_size, NXlex_in )) == 0) \
		  && ferror( NXlex_in ) ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "NXlex_terminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef NXlex_terminate
#define NXlex_terminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) NXlex__fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int NXlex_lex YY_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after NXlex_text and NXlex_leng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

YY_DECL
	{
	register NXlex__state_type NXlex__current_state;
	register char *NXlex__cp, *NXlex__bp;
	register int NXlex__act;

# line 21 "NXStringTable_scan.l"

    /* Lexical initialization - This gets executed before any analysis */
    char string_buf[MAX_STRINGTABLE_LENGTH];
    char *string_buf_ptr;
    static int  got;		/* Holds the type of token we just got */
    static int  line;
    #ifndef HAVE_FLEX
      extern FILE *NXscan_in;
      extern FILE *NXscan_out;
      extern char *NXscan_string;
    #endif
    if (NXlex_in != NXscan_in) {	/* Reset */
	got = 0;
	line= 1;
    	NXlex_in  = NXscan_in;
    }
    NXlex_out = NXscan_out;
    #ifdef HAVE_FLEX
      *buffer = string_buf;
    #else
      NXscan_string = string_buf;
    #endif
    BEGIN(parse);


	if ( NXlex__init )
		{
#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! NXlex__start )
			NXlex__start = 1;	/* first start state */

		if ( ! NXlex_in )
			NXlex_in = stdin;

		if ( ! NXlex_out )
			NXlex_out = stdout;

		if ( NXlex__current_buffer )
			NXlex__init_buffer( NXlex__current_buffer, NXlex_in );
		else
			NXlex__current_buffer =
				NXlex__create_buffer( NXlex_in, YY_BUF_SIZE );

		NXlex__load_buffer_state();

		NXlex__init = 0;
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		NXlex__cp = NXlex__c_buf_p;

		/* Support of NXlex_text. */
		*NXlex__cp = NXlex__hold_char;

		/* NXlex__bp points to the position in NXlex__ch_buf of the start of
		 * the current run.
		 */
		NXlex__bp = NXlex__cp;

		NXlex__current_state = NXlex__start;
NXlex__match:
		do
			{
			register YY_CHAR NXlex__c = NXlex__ec[YY_SC_TO_UI(*NXlex__cp)];
			if ( NXlex__accept[NXlex__current_state] )
				{
				NXlex__last_accepting_state = NXlex__current_state;
				NXlex__last_accepting_cpos = NXlex__cp;
				}
			while ( NXlex__chk[NXlex__base[NXlex__current_state] + NXlex__c] != NXlex__current_state )
				{
				NXlex__current_state = (int) NXlex__def[NXlex__current_state];
				if ( NXlex__current_state >= 36 )
					NXlex__c = NXlex__meta[(unsigned int) NXlex__c];
				}
			NXlex__current_state = NXlex__nxt[NXlex__base[NXlex__current_state] + (unsigned int) NXlex__c];
			++NXlex__cp;
			}
		while ( NXlex__base[NXlex__current_state] != 75 );

NXlex__find_action:
		NXlex__act = NXlex__accept[NXlex__current_state];

		YY_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( NXlex__act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*NXlex__cp = NXlex__hold_char;
			NXlex__cp = NXlex__last_accepting_cpos;
			NXlex__current_state = NXlex__last_accepting_state;
			goto NXlex__find_action;

case 1:
YY_USER_ACTION
# line 45 "NXStringTable_scan.l"
BEGIN(comment);
	YY_BREAK
case 2:
YY_USER_ACTION
# line 47 "NXStringTable_scan.l"
/* eat anything that's not a '*' */;
	YY_BREAK
case 3:
YY_USER_ACTION
# line 48 "NXStringTable_scan.l"
/* eat up '*'s not followed by '/'s */;
	YY_BREAK
case 4:
YY_USER_ACTION
# line 49 "NXStringTable_scan.l"
line++;
	YY_BREAK
case 5:
YY_USER_ACTION
# line 50 "NXStringTable_scan.l"
BEGIN(parse);
	YY_BREAK
case YY_STATE_EOF(comment):
# line 51 "NXStringTable_scan.l"
{
			    /* error - unterminated comment */
			    fprintf(stderr, "ERROR (NXStringTable): Unterminated comment\n");
			    return_err();
			}
	YY_BREAK
case 6:
YY_USER_ACTION
# line 57 "NXStringTable_scan.l"
{
			    if (!got) {
			    	fprintf(stderr, "\nERROR (NXStringTable): Improper use of = (Expected a key, line %d)\n", line);
			    	return_err();
			    }
			    if (got == VALUE) {
			    	fprintf(stderr, "\nERROR (NXStringTable): Improper use of = (Expected a ;, line %d)\n", line);
			    	return_err();
			     }
			 }
	YY_BREAK
case 7:
YY_USER_ACTION
# line 68 "NXStringTable_scan.l"
{
			    if (!got) {
			        fprintf(stderr, "\nERROR (NXStringTable): Improper use of ; (Expected a key, line %d)\n", line);
			        return_err();
			}
			    if (got == KEY) {
			        got = 0;
			    	return_ok();
			    }
			    got  = 0;
			}
	YY_BREAK
case 8:
YY_USER_ACTION
# line 80 "NXStringTable_scan.l"
/* Eat up white space between tokens */;
	YY_BREAK
case 9:
YY_USER_ACTION
# line 82 "NXStringTable_scan.l"
line++;
	YY_BREAK
case 10:
YY_USER_ACTION
# line 84 "NXStringTable_scan.l"
{string_buf_ptr = string_buf; BEGIN(token);}
	YY_BREAK
case 11:
YY_USER_ACTION
# line 86 "NXStringTable_scan.l"
{
			    fprintf(stderr, "ERROR (NXStringTable): Extra characters in table (line %d)\n", line);
			    return_err();
			}
	YY_BREAK
case 12:
YY_USER_ACTION
# line 91 "NXStringTable_scan.l"
{   /* saw closing quote - all done */
			    BEGIN(parse);
			    *string_buf_ptr = '\0';
			    /* return string constant token type and
			    * value to parser
			    */
			    got++;
			    if (got == KEY || got == VALUE) {
			    	return_ok();
			    } else {
			    	fprintf(stderr, "ERROR (NXStringTable): Parse error, line %d \n", line);
				return_err();
			    }
			}
	YY_BREAK
case 13:
YY_USER_ACTION
# line 106 "NXStringTable_scan.l"
{
			    /* error - unterminated string constant */
			    fprintf(stderr, "ERROR (NXStringTable): Unterminated string (line %d)\n", line);
			    return_err();
			}
	YY_BREAK
case YY_STATE_EOF(token):
# line 112 "NXStringTable_scan.l"
{
			    /* error - unterminated string constant */
			    fprintf(stderr, "ERROR (NXStringTable): Unterminated string (line %d)\n", line);
			    return_err();
			}
	YY_BREAK
case 14:
YY_USER_ACTION
# line 118 "NXStringTable_scan.l"
{*string_buf_ptr++='\\';*string_buf_ptr++ = NXlex_text[1];}
	YY_BREAK
case 15:
YY_USER_ACTION
# line 120 "NXStringTable_scan.l"
*string_buf_ptr++ = NXlex_text[1];
	YY_BREAK
case 16:
YY_USER_ACTION
# line 122 "NXStringTable_scan.l"
{
			    char *text_ptr = NXlex_text;
			    if (!text_ptr) {
			    	fprintf(stderr, "ERROR (NXStringTable): internal parse error\n");
				break;
			    }
			    while ( *text_ptr )
				*string_buf_ptr++ = *text_ptr++;
			}
	YY_BREAK
case 17:
YY_USER_ACTION
# line 132 "NXStringTable_scan.l"
ECHO;
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(parse):
	NXlex_terminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int NXlex__amount_of_matched_text = NXlex__cp - NXlex_text_ptr - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*NXlex__cp = NXlex__hold_char;

		if ( NXlex__current_buffer->NXlex__input_file != NXlex_in )
			{
			/* This can happen if we scan a file, NXlex_wrap() returns
			 * 1, and then later the user points NXlex_in at a new
			 * file to resume scanning.  We have to assure
			 * consistency between NXlex__current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input file.
			 */
			NXlex__current_buffer->NXlex__input_file = NXlex_in;
			NXlex__n_chars = NXlex__current_buffer->NXlex__n_chars;
			}

		/* Note that here we test for NXlex__c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since NXlex__c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( NXlex__c_buf_p <= &NXlex__current_buffer->NXlex__ch_buf[NXlex__n_chars] )
			{ /* This was really a NUL. */
			NXlex__state_type NXlex__next_state;

			NXlex__c_buf_p = NXlex_text_ptr + NXlex__amount_of_matched_text;

			NXlex__current_state = NXlex__get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * NXlex__get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			NXlex__next_state = NXlex__try_NUL_trans( NXlex__current_state );

			NXlex__bp = NXlex_text_ptr + YY_MORE_ADJ;

			if ( NXlex__next_state )
				{
				/* Consume the NUL. */
				NXlex__cp = ++NXlex__c_buf_p;
				NXlex__current_state = NXlex__next_state;
				goto NXlex__match;
				}

			else
				{
				goto NXlex__find_action;
				}
			}

		else switch ( NXlex__get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				NXlex__did_buffer_switch_on_eof = 0;

				if ( NXlex_wrap() )
					{
					/* Note: because we've taken care in
					 * NXlex__get_next_buffer() to have set up
					 * NXlex_text, we can now set up
					 * NXlex__c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					NXlex__c_buf_p = NXlex_text_ptr + YY_MORE_ADJ;

					NXlex__act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! NXlex__did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				NXlex__c_buf_p =
					NXlex_text_ptr + NXlex__amount_of_matched_text;

				NXlex__current_state = NXlex__get_previous_state();

				NXlex__cp = NXlex__c_buf_p;
				NXlex__bp = NXlex_text_ptr + YY_MORE_ADJ;
				goto NXlex__match;

			case EOB_ACT_LAST_MATCH:
				NXlex__c_buf_p =
				&NXlex__current_buffer->NXlex__ch_buf[NXlex__n_chars];

				NXlex__current_state = NXlex__get_previous_state();

				NXlex__cp = NXlex__c_buf_p;
				NXlex__bp = NXlex_text_ptr + YY_MORE_ADJ;
				goto NXlex__find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of NXlex_lex */


/* NXlex__get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int NXlex__get_next_buffer()
	{
	register char *dest = NXlex__current_buffer->NXlex__ch_buf;
	register char *source = NXlex_text_ptr - 1; /* copy prev. char, too */
	register int number_to_move, i;
	int ret_val;

	if ( NXlex__c_buf_p > &NXlex__current_buffer->NXlex__ch_buf[NXlex__n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( NXlex__current_buffer->NXlex__fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( NXlex__c_buf_p - NXlex_text_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a singled characater, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = NXlex__c_buf_p - NXlex_text_ptr;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( NXlex__current_buffer->NXlex__eof_status != EOF_NOT_SEEN )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		NXlex__n_chars = 0;

	else
		{
		int num_to_read =
			NXlex__current_buffer->NXlex__buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = NXlex__current_buffer;

			int NXlex__c_buf_p_offset = NXlex__c_buf_p - b->NXlex__ch_buf;

			b->NXlex__buf_size *= 2;
			b->NXlex__ch_buf = (char *)
				NXlex__flex_realloc( (void *) b->NXlex__ch_buf,
						 b->NXlex__buf_size );

			if ( ! b->NXlex__ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			NXlex__c_buf_p = &b->NXlex__ch_buf[NXlex__c_buf_p_offset];

			num_to_read = NXlex__current_buffer->NXlex__buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&NXlex__current_buffer->NXlex__ch_buf[number_to_move]),
			NXlex__n_chars, num_to_read );
		}

	if ( NXlex__n_chars == 0 )
		{
		if ( number_to_move - YY_MORE_ADJ == 1 )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			NXlex_restart( NXlex_in );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			NXlex__current_buffer->NXlex__eof_status = EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	NXlex__n_chars += number_to_move;
	NXlex__current_buffer->NXlex__ch_buf[NXlex__n_chars] = YY_END_OF_BUFFER_CHAR;
	NXlex__current_buffer->NXlex__ch_buf[NXlex__n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	/* NXlex_text begins at the second character in NXlex__ch_buf; the first
	 * character is the one which preceded it before reading in the latest
	 * buffer; it needs to be kept around in case it's a newline, so
	 * NXlex__get_previous_state() will have with '^' rules active.
	 */

	NXlex_text_ptr = &NXlex__current_buffer->NXlex__ch_buf[1];

	return ret_val;
	}


/* NXlex__get_previous_state - get the state just before the EOB char was reached */

static NXlex__state_type NXlex__get_previous_state()
	{
	register NXlex__state_type NXlex__current_state;
	register char *NXlex__cp;

	NXlex__current_state = NXlex__start;

	for ( NXlex__cp = NXlex_text_ptr + YY_MORE_ADJ; NXlex__cp < NXlex__c_buf_p; ++NXlex__cp )
		{
		register YY_CHAR NXlex__c = (*NXlex__cp ? NXlex__ec[YY_SC_TO_UI(*NXlex__cp)] : 1);
		if ( NXlex__accept[NXlex__current_state] )
			{
			NXlex__last_accepting_state = NXlex__current_state;
			NXlex__last_accepting_cpos = NXlex__cp;
			}
		while ( NXlex__chk[NXlex__base[NXlex__current_state] + NXlex__c] != NXlex__current_state )
			{
			NXlex__current_state = (int) NXlex__def[NXlex__current_state];
			if ( NXlex__current_state >= 36 )
				NXlex__c = NXlex__meta[(unsigned int) NXlex__c];
			}
		NXlex__current_state = NXlex__nxt[NXlex__base[NXlex__current_state] + (unsigned int) NXlex__c];
		}

	return NXlex__current_state;
	}


/* NXlex__try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = NXlex__try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static NXlex__state_type NXlex__try_NUL_trans( NXlex__state_type NXlex__current_state )
#else
static NXlex__state_type NXlex__try_NUL_trans( NXlex__current_state )
NXlex__state_type NXlex__current_state;
#endif
	{
	register int NXlex__is_jam;
	register char *NXlex__cp = NXlex__c_buf_p;

	register YY_CHAR NXlex__c = 1;
	if ( NXlex__accept[NXlex__current_state] )
		{
		NXlex__last_accepting_state = NXlex__current_state;
		NXlex__last_accepting_cpos = NXlex__cp;
		}
	while ( NXlex__chk[NXlex__base[NXlex__current_state] + NXlex__c] != NXlex__current_state )
		{
		NXlex__current_state = (int) NXlex__def[NXlex__current_state];
		if ( NXlex__current_state >= 36 )
			NXlex__c = NXlex__meta[(unsigned int) NXlex__c];
		}
	NXlex__current_state = NXlex__nxt[NXlex__base[NXlex__current_state] + (unsigned int) NXlex__c];
	NXlex__is_jam = (NXlex__current_state == 35);

	return NXlex__is_jam ? 0 : NXlex__current_state;
	}


#ifdef YY_USE_PROTOS
static void NXlex_unput( int c, register char *NXlex__bp )
#else
static void NXlex_unput( c, NXlex__bp )
int c;
register char *NXlex__bp;
#endif
	{
	register char *NXlex__cp = NXlex__c_buf_p;

	/* undo effects of setting up NXlex_text */
	*NXlex__cp = NXlex__hold_char;

	if ( NXlex__cp < NXlex__current_buffer->NXlex__ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = NXlex__n_chars + 2;
		register char *dest = &NXlex__current_buffer->NXlex__ch_buf[
					NXlex__current_buffer->NXlex__buf_size + 2];
		register char *source =
				&NXlex__current_buffer->NXlex__ch_buf[number_to_move];

		while ( source > NXlex__current_buffer->NXlex__ch_buf )
			*--dest = *--source;

		NXlex__cp += dest - source;
		NXlex__bp += dest - source;
		NXlex__n_chars = NXlex__current_buffer->NXlex__buf_size;

		if ( NXlex__cp < NXlex__current_buffer->NXlex__ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	if ( NXlex__cp > NXlex__bp && NXlex__cp[-1] == '\n' )
		NXlex__cp[-2] = '\n';

	*--NXlex__cp = (char) c;


	/* Note: the formal parameter *must* be called "NXlex__bp" for this
	 * macro to now work correctly.
	 */
	YY_DO_BEFORE_ACTION; /* set up NXlex_text again */
	}


#ifdef __cplusplus
static int NXlex_input()
#else
static int input()
#endif
	{
	int c;

	*NXlex__c_buf_p = NXlex__hold_char;

	if ( *NXlex__c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* NXlex__c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( NXlex__c_buf_p < &NXlex__current_buffer->NXlex__ch_buf[NXlex__n_chars] )
			/* This was really a NUL. */
			*NXlex__c_buf_p = '\0';

		else
			{ /* need more input */
			NXlex_text_ptr = NXlex__c_buf_p;
			++NXlex__c_buf_p;

			switch ( NXlex__get_next_buffer() )
				{
				case EOB_ACT_END_OF_FILE:
					{
					if ( NXlex_wrap() )
						{
						NXlex__c_buf_p =
						NXlex_text_ptr + YY_MORE_ADJ;
						return EOF;
						}

					YY_NEW_FILE;
#ifdef __cplusplus
					return NXlex_input();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					NXlex__c_buf_p = NXlex_text_ptr + YY_MORE_ADJ;
					break;

				case EOB_ACT_LAST_MATCH:
#ifdef __cplusplus
					YY_FATAL_ERROR(
					"unexpected last match in NXlex_input()" );
#else
					YY_FATAL_ERROR(
					"unexpected last match in input()" );
#endif
				}
			}
		}

	c = *NXlex__c_buf_p;
	*NXlex__c_buf_p = '\0';	/* preserve NXlex_text */
	NXlex__hold_char = *++NXlex__c_buf_p;

	return c;
	}


#ifdef YY_USE_PROTOS
void NXlex_restart( FILE *input_file )
#else
void NXlex_restart( input_file )
FILE *input_file;
#endif
	{
	if ( ! NXlex__current_buffer )
		NXlex__current_buffer = NXlex__create_buffer( NXlex_in, YY_BUF_SIZE );

	NXlex__init_buffer( NXlex__current_buffer, input_file );
	NXlex__load_buffer_state();
	}


#ifdef YY_USE_PROTOS
void NXlex__switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void NXlex__switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif
	{
	if ( NXlex__current_buffer == new_buffer )
		return;

	if ( NXlex__current_buffer )
		{
		/* Flush out information for old buffer. */
		*NXlex__c_buf_p = NXlex__hold_char;
		NXlex__current_buffer->NXlex__buf_pos = NXlex__c_buf_p;
		NXlex__current_buffer->NXlex__n_chars = NXlex__n_chars;
		}

	NXlex__current_buffer = new_buffer;
	NXlex__load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (NXlex_wrap()) processing, but the only time this flag
	 * is looked at is after NXlex_wrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	NXlex__did_buffer_switch_on_eof = 1;
	}


#ifdef YY_USE_PROTOS
void NXlex__load_buffer_state( void )
#else
void NXlex__load_buffer_state()
#endif
	{
	NXlex__n_chars = NXlex__current_buffer->NXlex__n_chars;
	NXlex_text_ptr = NXlex__c_buf_p = NXlex__current_buffer->NXlex__buf_pos;
	NXlex_in = NXlex__current_buffer->NXlex__input_file;
	NXlex__hold_char = *NXlex__c_buf_p;
	}


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE NXlex__create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE NXlex__create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) NXlex__flex_alloc( sizeof( struct NXlex__buffer_state ) );

	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in NXlex__create_buffer()" );

	b->NXlex__buf_size = size;

	/* NXlex__ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->NXlex__ch_buf = (char *) NXlex__flex_alloc( b->NXlex__buf_size + 2 );

	if ( ! b->NXlex__ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in NXlex__create_buffer()" );

	NXlex__init_buffer( b, file );

	return b;
	}


#ifdef YY_USE_PROTOS
void NXlex__delete_buffer( YY_BUFFER_STATE b )
#else
void NXlex__delete_buffer( b )
YY_BUFFER_STATE b;
#endif
	{
	if ( b == NXlex__current_buffer )
		NXlex__current_buffer = (YY_BUFFER_STATE) 0;

	NXlex__flex_free( (void *) b->NXlex__ch_buf );
	NXlex__flex_free( (void *) b );
	}


#ifdef YY_USE_PROTOS
void NXlex__init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void NXlex__init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif
	{
	b->NXlex__input_file = file;

	/* We put in the '\n' and start reading from [1] so that an
	 * initial match-at-newline will be true.
	 */

	b->NXlex__ch_buf[0] = '\n';
	b->NXlex__n_chars = 1;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->NXlex__ch_buf[1] = YY_END_OF_BUFFER_CHAR;
	b->NXlex__ch_buf[2] = YY_END_OF_BUFFER_CHAR;

	b->NXlex__buf_pos = &b->NXlex__ch_buf[1];

	b->NXlex__is_interactive = file ? isatty( fileno(file) ) : 0;

	b->NXlex__fill_buffer = 1;

	b->NXlex__eof_status = EOF_NOT_SEEN;
	}


#ifdef YY_USE_PROTOS
static void NXlex__push_state( int new_state )
#else
static void NXlex__push_state( new_state )
int new_state;
#endif
	{
	if ( NXlex__start_stack_ptr >= NXlex__start_stack_depth )
		{
		int new_size;

		NXlex__start_stack_depth += YY_START_STACK_INCR;
		new_size = NXlex__start_stack_depth * sizeof( int );

		if ( ! NXlex__start_stack )
			NXlex__start_stack = (int *) NXlex__flex_alloc( new_size );

		else
			NXlex__start_stack = (int *) NXlex__flex_realloc(
					(void *) NXlex__start_stack, new_size );

		if ( ! NXlex__start_stack )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	NXlex__start_stack[NXlex__start_stack_ptr++] = YY_START;

	BEGIN(new_state);
	}


static void NXlex__pop_state()
	{
	if ( --NXlex__start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(NXlex__start_stack[NXlex__start_stack_ptr]);
	}


static int NXlex__top_state()
	{
	return NXlex__start_stack[NXlex__start_stack_ptr - 1];
	}


#ifdef YY_USE_PROTOS
static void NXlex__fatal_error( const char msg[] )
#else
static void NXlex__fatal_error( msg )
char msg[];
#endif
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( 1 );
	}



/* Redefine NXlex_less() so it works in section 3 code. */

#undef NXlex_less
#define NXlex_less(n) \
	do \
		{ \
		/* Undo effects of setting up NXlex_text. */ \
		NXlex_text[NXlex_leng] = NXlex__hold_char; \
		NXlex__c_buf_p = NXlex_text + n - YY_MORE_ADJ; \
		NXlex__hold_char = *NXlex__c_buf_p; \
		*NXlex__c_buf_p = '\0'; \
		NXlex_leng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef NXlex_text_ptr
#ifdef YY_USE_PROTOS
static void NXlex__flex_strcpy( char *s1, const char *s2 )
#else
static void NXlex__flex_strcpy( s1, s2 )
char *s1;
const char *s2;
#endif
	{
	while ( (*(s1++) = *(s2++)) )
		;
	}
#endif


#ifdef YY_USE_PROTOS
static void *NXlex__flex_alloc( unsigned int size )
#else
static void *NXlex__flex_alloc( size )
unsigned int size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef YY_USE_PROTOS
static void *NXlex__flex_realloc( void *ptr, unsigned int size )
#else
static void *NXlex__flex_realloc( ptr, size )
void *ptr;
unsigned int size;
#endif
	{
	return (void *) realloc( ptr, size );
	}

#ifdef YY_USE_PROTOS
static void NXlex__flex_free( void *ptr )
#else
static void NXlex__flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}
# line 132 "NXStringTable_scan.l"


int
NXlex_wrap()
{
    return 1;
}

#ifdef NEED_MAIN
#ifndef HAVE_FLEX
    FILE *NXscan_in;
    FILE *NXscan_out;
    char *NXscan_string;
#endif
int
main(int argc, char *argv[])
{
    FILE *input;
    const char *str;
    int  ok, value = 0;
    
    if (argc > 1) {
    	if ((input = fopen(argv[1], "r")) == NULL) {
	    fprintf(stderr, "Error: Couldn't open %s\n", argv[1]);
	    exit (1);
	}
    } else
	exit(1);
    
#ifdef HAVE_FLEX
    ok = NXtable_scan( input, stdout, &str);
#else
    NXscan_in = input;
    NXscan_out = stdout;
    ok = NXlex_lex();
    str = NXscan_string;
#endif
    while (ok > 0) {
	if (value)
	    printf("Value: %s\n", str);
	else
	    printf("Key:   %s\n", str);
	value = ~value;
#ifdef HAVE_FLEX
	ok = NXtable_scan( input, stdout, &str);
#else
        ok = NXlex_lex();
#endif
    }
	
    return 0;
}
#endif
