/* $Id: gutil.c%v 1.1 1993/08/06 05:15:40 woo Exp woo $ */
/* GPLOTLIB - gutil.c */
/*
 * Copyright (C) 1986 - 1993   Thomas Williams, Colin Kelley
 *
 * Permission to use, copy, and distribute this software and its
 * documentation for any purpose with or without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and 
 * that both that copyright notice and this permission notice appear 
 * in supporting documentation.
 *
 * Permission to modify the software is granted, but not the right to
 * distribute the modified code.  Modifications are to be distributed 
 * as patches to released version.
 *  
 * This software is provided "as is" without express or implied warranty.
 * 
 *
 * AUTHORS
 * 
 *   Original Software:
 *     Thomas Williams,  Colin Kelley.
 * 
 *   Gnuplot 2.0 additions:
 *       Russell Lang, Dave Kotz, John Campbell.
 *
 *   Gnuplot 3.0 additions:
 *       Gershon Elber and many others.
 * 
 */
/* $Log: gutil.c%v $
 * Revision 1.1  1993/08/06  05:15:40  woo
 * Initial revision
 *
 * Revision 1.2  1993/06/14  19:22:41  jack
 * Modified for gnuplot 3.4
 *
 * Revision 1.1  1993/05/28  18:58:41  jack
 * Initial revision
 *
 * Revision 1.1  1993/05/20  16:47:16  jack
 * Initial revision
 *
 */

#include <ctype.h>
#include <setjmp.h>
#include <stdio.h>
#include <errno.h>
#include "plot.h"

TBOOLEAN screen_ok;
	/* TRUE if command just typed; becomes FALSE whenever we
		send some other output to screen.  If FALSE, the command line
		will be echoed to the screen before the ^ error message. */

#ifndef vms
#if !defined(__ZTC__) && !defined(__PUREC__)
#if !defined(__MSC__)
extern int errno;
#endif
extern int sys_nerr;
extern char *sys_errlist[];
#endif
#endif /* vms */

extern char input_line[];
extern struct lexical_unit token[];
#ifdef _Windows
extern jmp_buf far env;	/* from plot.c */
#else
extern jmp_buf env;	/* from plot.c */
#endif
extern int inline_num;		/* from command.c */
extern TBOOLEAN interactive;	/* from plot.c */
extern char *infile_name;	/* from plot.c */
extern int c_token, num_tokens;

#ifdef sequent
extern char *index();
#else
extern char *strchr();
#endif

#ifndef AMIGA_AC_5
extern double sqrt(), atan2();
#endif

/*
 * equals() compares string value of token number t_num with str[], and
 *   returns TRUE if they are identical.
 */
equals(t_num, str)
int t_num;
char *str;
{
register int i;

	if (!token[t_num].is_token)
		return(FALSE);				/* must be a value--can't be equal */
	for (i = 0; i < token[t_num].length; i++) {
		if (input_line[token[t_num].start_index+i] != str[i])
			return(FALSE);
		}
	/* now return TRUE if at end of str[], FALSE if not */
	return(str[i] == '\0');
}



/*
 * almost_equals() compares string value of token number t_num with str[], and
 *   returns TRUE if they are identical up to the first $ in str[].
 */
almost_equals(t_num, str)
int t_num;
char *str;
{
register int i;
register int after = 0;
register start = token[t_num].start_index;
register length = token[t_num].length;

	if (!token[t_num].is_token)
		return(FALSE);				/* must be a value--can't be equal */
	for (i = 0; i < length + after; i++) {
		if (str[i] != input_line[start + i]) {
			if (str[i] != '$')
				return(FALSE);
			else {
				after = 1;
				start--;	/* back up token ptr */
				}
			}
		}

	/* i now beyond end of token string */

	return(after || str[i] == '$' || str[i] == '\0');
}



isstring(t_num)
int t_num;
{
	
	return(token[t_num].is_token &&
		   (input_line[token[t_num].start_index] == '\'' ||
		   input_line[token[t_num].start_index] == '\"'));
}

/*
 * quote_str() does the same thing as copy_str, except it ignores the
 *   quotes at both ends.  This seems redundant, but is done for
 *   efficency.
 */
quote_str(str, t_num)
char str[];
int t_num;
{
register int i = 0;
register int start = token[t_num].start_index + 1;
register int count;

	if ((count = token[t_num].length - 2) > MAX_ID_LEN)
		count = MAX_ID_LEN;
	if (count>0) {
		do {
			str[i++] = input_line[start++];
			} while (i != count);
	}
	str[i] = '\0';
}

/*
 *	capture() copies into str[] the part of input_line[] which lies between
 *	the begining of token[start] and end of token[end].
 */
capture(str,start,end)
char str[];
int start,end;
{
register int i,e;

	e = token[end].start_index + token[end].length;
	for (i = token[start].start_index; i < e && input_line[i] != '\0'; i++)
		*str++ = input_line[i];
	*str = '\0';
}


convert(val_ptr, t_num)
struct value *val_ptr;
int t_num;
{
	*val_ptr = token[t_num].l_val;
}

static char *num_to_str(r)
double r;
{
	static i = 0;
	static char s[4][20];
	int j = i++;

	if ( i > 3 ) i = 0;

	sprintf( s[j], "%g", r );
#ifdef sequent
	if ( index( s[j], '.' ) == NULL &&
	     index( s[j], 'e' ) == NULL &&
	     index( s[j], 'E' ) == NULL )
#else
	if ( strchr( s[j], '.' ) == NULL &&
	     strchr( s[j], 'e' ) == NULL &&
	     strchr( s[j], 'E' ) == NULL )
#endif
		strcat( s[j], ".0" );

	return s[j];
} 

double
real(val)		/* returns the real part of val */
struct value *val;
{
	switch(val->type) {
		case INTGR:
			return((double) val->v.int_val);
		case CMPLX:
			return(val->v.cmplx_val.real);
	}
	int_error("unknown type in real()",NO_CARET);
	/* NOTREACHED */
	return((double)0.0);
}

struct value *
const_express(valptr)
struct value *valptr;
{
	if (END_OF_COMMAND)
		int_error("constant expression required",c_token);

/* Cheap imitation, assume there is a well-formed value to avoid evaluate_at */
	convert(valptr, c_token);

	return(valptr);
}
