#ifndef INCgtplot
#define INCgtplot
/*  This file is a part of RLaB ("Our"-LaB)
    Copyright (C) 1993  Jack Dunn

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file ./COPYING
 ***********************************************************************/


/*
   gnuplot Graphics Terminal header file.  This file is required by
   all users of the gnuplot Graphics Terminal library: gterm.c
*/
#include "plot.h"


/* Some key global variables */
#ifdef GT_OWNER
/* GTterm_tbl[] is "extern" only in the sense that it is defined later... */
extern struct termentry GTterm_tbl[];
FILE *GToutfile=NULL;
TBOOLEAN GTterm_init=0;
TBOOLEAN GTinteractive=0;  /* Not used correctly yet--who can set it? */
TBOOLEAN GTcolor=0;  /* Not used yet */
int GTterm=0;
float GTxsize = 1.0, GTysize = 1.0, GTzsize = 1.0;  /* z's not used yet */
#ifdef RLAB
char *plot_filename;
#endif
#else

/* 
   Globals available when using gterm.c:

   GTterm_tbl[]    -  table containing function pointers, etc. for all
                      terminal drivers in the gnuplot package.

   GToutfile       -  Output file pointer where all plotting activity is
                      written out.

   GTterm_init     -  Indicates if the terminal has been initialized yet.

   GTinteractive   -  Indicates if we are an interactive terminal or not.

   GTcolor         -  Not used yet, someday it would be nice to know if we
                      are working on a color terminal or not.

   GTterm          -  Index into GTterm_tbl describing the current terminal.
                      Generally gt_init_teminal() will set this to match the
                      GNUTERM environment variable.  The terminal can be
                      changed, however, with gt_change_term().
   
   GTxsize,        -  scaling factors currently only the LaTeX driver can
   GTysize            and the postscript driver make use of these.
*/

extern struct termentry GTterm_tbl[];
extern FILE *GToutfile;
extern TBOOLEAN GTterm_init;
extern TBOOLEAN GTinteractive;
extern TBOOLEAN GTcolor;  /* Not used yet */
extern int GTterm;
extern float GTxsize, GTysize;
extern char *plot_filename;

#endif
#endif
