From info-gnuplot-people-request@wildcat.dartmouth.edu Thu May 13 13:13:27 1993
Return-Path: <info-gnuplot-people-request@wildcat.dartmouth.edu>
Received:  by playfair.Stanford.EDU (5.57/25-eef) id AA01231; Thu, 13 May 93 13:13:26 -0700
Received: by wildcat.dartmouth.edu (5.65D1/4.1)
	id AA06533; Thu, 13 May 93 16:13:04 -0400
Received: from dartvax.dartmouth.edu by wildcat.dartmouth.edu (5.65D1/4.1)
	id AA06529; Thu, 13 May 93 16:13:02 -0400
Received: from rodan.UU.NET by dartvax.dartmouth.edu (5.65+D4/4.5HUB)
	id AA18675; Thu, 13 May 93 16:12:51 -0400
Received: from info-gnuplot@dartmouth.edu (list exploder) by rodan.UU.NET 
	(5.61/UUNET-mail-drop) id AA14223; Thu, 13 May 93 16:12:46 -0400
Received: from news.UU.NET (via [153.39.128.70]) by rodan.UU.NET with SMTP 
	(5.61/UUNET-mail-drop) id AA14218; Thu, 13 May 93 16:12:45 -0400
Newsgroups: comp.graphics.gnuplot
Path: uunet!caen!uwm.edu!wupost!cs.utexas.edu!hermes.chpc.utexas.edu!jonathan
From: jonathan@chpc.utexas.edu (Jonathan Thornburg)
Subject: Re: Non-interactive gnuplot usage
Message-Id: <1993May13.195115.645@chpc.utexas.edu>
Summary: how to run gnuplot from a shell script
Keywords: gnuplot interactive non-interactive batch script redirect input output
Organization: U of Texas at Austin / Physics Dept / Center for Relativity
References: <kencham.737254099@centi>
Date: Thu, 13 May 93 19:51:15 GMT
Lines: 58
Xref: uunet comp.graphics.gnuplot:1251
Sender: info-gnuplot-request@dartmouth.edu
To: info-gnuplot@dartmouth.edu
Status: R

In article <kencham.737254099@centi> kencham@centi.cs.umn.edu
(deepak kenchammana-hosekote) writes:
>    Wondering if there is a way to use gnuplot non-interactively. The
>man pages here state that:
>
>     Gnuplot is a command-driven  interactive  function  plotting
>     program.
>
>    Is there a way to just execute gnuplot with a couple of command
>line flags to generate the appropriate PS files. (Better still, could
>some one send me the rule for MAKE to convert data files to the
>plotted ps files?)

At least on Unix systems, this is easy, just run it from a shell script
with input and output redirected.  Here's an example taken (with some
simplifications to remove irrelevant details) from my thesis:

	% cat doit.gnuplot
	gnuplot <<EOF >r_of_y.ps
	set terminal postscript portrait 12 #pt
	load "r_of_y.gnuplot"
	EOF
	% cat r_of_y.gnuplot
	# gnuplot script for fig-m210 of my thesis, $r(y)$ part
	#
	set size 0.70, 0.55
	set logscale y
	#
	set xrange [-0.1:2.1]
	set xtics 0.0, 0.5
	#
	set yrange [1:300]
	#
	set nokey
	set noyzeroaxis
	#
	plot "m210-15-deg.02.info"                              \
		using "y=%f r=%f delta_r/r=%*f delta_r=%*f"     \
	%

Given these two files, and given the appropriate data files, typing
the command

	% csh doit.gnuplot

causes gnuplot to be run, and the postscript output sent to the file
"r_of_y.ps"

The reason I split off the "set terminal" into the shell script, rather
than putting it directly into the gnuplot script, is so that I can say
   load "r_of_y.ps"   when running gnuplot interactively, to see the
same plots displayed on my screen.

- Jonathan Thornburg
  <jonathan@einstein.ph.utexas.edu> or <jonathan@hermes.chpc.utexas.edu>
  [until 31/Aug/93] U of Texas at Austin / Physics Dept / Center for Relativity
  [thereafter] U of British Columbia / {Astronomy,Physics}
  "One million Americans have two homes; four million Americans have no homes."

