.TH TextBlock 3I "13 December 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
TextBlock \- an interactor for structured text
.SH SYNOPSIS
.B #include <InterViews/Text/textblock.h>
.SH DESCRIPTION
A TextBlock is an interactor used in conjunction with a Layout(3I) to compose
structured text in a multi-block document.  TextBlocks are constructed with
a specified natural shape, and are ``moderately'' stretchable and
shrinkable.
A TextBlock will have its input sensor and output painter assigned by the
Layout in which it is chained.
Event handling is performed by an interactor passed to the constructor,
typically an enclosing scene.
.SH PUBLIC OPERATIONS
.TP
.B "TextBlock(int width, int height, Interactor * handler = nil)"
Create a new TextBlock, with natural width \fIwidth\fP, natural height
\fIheight\fP and event handler \fIhandler\fP.
.TP
.B "void Handle(Event&)"
Delegate the Handle call to the handler specified in the constructor, if not
nil.
.TP
.B "void Wait()"
.ns
.TP
.B "void Done()"
\fIWait\fP sets the TextBlock's cursor to an hourglass, \fIDone\fP restores
it to the default arrow.
.SH SEE ALSO
Interactor(2I), Layout(3I)
