.TH Resource 3I "15 June 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
Resource \- InterViews shared object
.SH SYNOPSIS
.B #include <InterViews/resource.h>
.SH DESCRIPTION
.B Resource
is a class that provides a simple form of reference counting for
shared objects.
Every resource has a reference count that is initially set to one and
must be explicitly incremented through a call to Reference.
When a resource is deleted, the reference count is decremented and
if still non-zero the object is not actually destroyed.
.SH PUBLIC OPERATIONS
.TP
.B "Resource()"
Create a new resource object with reference count one.
.TP
.B "~Resource()"
Decrement the reference count and destroy the object only if the count
is now zero.
.TP
.B "void Reference()"
Increment the resource's reference count.
.TP
.B "boolean LastRef()"
Check if the resource only has a single reference.
This operation is useful in a subclass destructor to decide
whether to destroy components of an object.
