.TH ObjectSpace 3I "29 May 1989" "InterViews" "InterViews Reference Manual"
.SH NAME
ObjectSpace \- distributed objects
.SH SYNOPSIS
.B #include <InterViews/space.h>
.SH DESCRIPTION
ObjectSpace is a class that represents a tightly-coupled cluster of objects.
It is analogous to an address space, with objects instead of bytes or words.
The ObjectSpace class allows remote access to objects through Unix IPC.
.PP
An object space is a kind of server process.
It runs a top-level loop that receives messages
from other object spaces (processes) and delivers them
to the appropriate object.
.PP
Clients connect to object spaces through
the name server process \fIspaceman\fP(1).
Object names have two parts: a string that identifies
the object space and is known to spaceman, and
a string that is resolved by the object space itself.
.SH PUBLIC OPERATIONS
.TP
.B "ObjectSpace(const char*)"
Create a space and register it under the given name with the space manager.
.TP
.B "void StartServer(Connection* local, Connection* remote)"
Start listening to the given connections for object messages.
This routine is not necessary in general because as the constructor
will connect to the space manager and establish connections
on which to listen.  However, some applications, such as the space manager
itself, must specify the connections explicitly.
.TP
.B "void UsePath(const char* path)"
Tell the space manager to prepend the given path when searching
for other known spaces.
.TP
.B "Connection* Find(const char* name, boolean wait = false)"
Ask the space manager to look for an object space with the given name.
If \fIwait\fP is true, then wait until a space is created
with the given name if none currently exists.
Find returns a connection to the named object space or \fInil\fP
is none is defined an \fIwait\fP was false.
.TP
.B "void Dispatch()"
Wait for a single message from a client and deliver it to the target object.
.TP
.B "void Deliver(Connection*, ObjectTag, int op, void*, int len)"
Send an untyped message of a given length to a target object by
mapping the tag and calls Message on the target object stub.
.TP
.B "virtual void Message(Connection*, ObjectTag, int op, void*, int len)"
Handle a message to the object space itself.
Messages with a zero tag in the target field are handled
by the object space.
These are used to find an object by name with a space, create
a new instance of an existing object, or destroy an object.
If an object is found or created, the tag specified by the sender
should be associated with the object for use in subsequent messages.
.TP
.B "ObjectStub* Map(Connection*, ObjectTag)"
Translate a client's tag to a stub.
The client is identified by the connection.
.TP
.B "void AddChannel(int, ObjectStub*)"
.ns
.TP
.B "void RemoveChannel(int)"
Add or remove an additional channel on which to receive data.
This channel is treated as a stream instead of interpreting packets
with tags identifying target objects.
When data is pending on the channel, the object space
calls ChannelReady on the stub.
.TP
.B "void Attach(int)"
.ns
.TP
.B "void Detach(int)"
Start or stop listening to a channel added by an earlier call
to AddChannel.
.SH "SEE ALSO"
spaceman(1), Connection(3i), ObjectStub(3i)
.br
Linton,\ M.A., ``Distributed Management of a Software Database'',
\fIIEEE Software\fP, Vol.\ 4, No.\ 6, November\ 1987, pp.\ 70-76.
