.TH Canvas 3I "15 June 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
Canvas \- region for graphics output
.SH SYNOPSIS
.B #include <InterViews/canvas.h>
.SH DESCRIPTION
A canvas is an area for graphics output associated with an interactor.
Most interactors do not need to perform any operations on a canvas;
they simply pass a canvas as an argument to graphics operations.
In this case, it is not necessary to include ``canvas.h''.
.SH PUBLIC OPERATIONS
.TP
.B "Canvas(int width, int height)"
Create an offscreen canvas with the given size and height.
.TP
.B "void Clip(Coord, Coord, Coord, Coord)"
Clip drawing to the canvas to the given rectangle.
.TP
.B "void ClipOn()"
.ns
.TP
.B "void ClipOff()"
Temporarily turn use of a canvas' clipping rectangle on or off.
.TP
.B "int Height()"
Return the height of a canvas in pixels.
.TP
.B "boolean IsClipped()"
Return whether output to the canvas is currently clipped.
.TP
.B "void NoClip()"
Delete the clipping rectangle for with a canvas.
.TP
.B "void SetBackground(Color*)"
Associate a background color with the canvas.
.TP
.B "CanvasStatus Status()"
Return the current status of a canvas, which is one
of CanvasMapped (assigned an area on the display),
CanvasUnmapped (not assigned an area), and CanvasOffscreen
(assigned an area in offscreen memory).
.TP
.B "int Width()"
Return the width of a canvas in pixels.
.SH SEE ALSO
Interactor(3I), Painter(3I)
