.TH pages 1 "1 January 1988" "InterViews" "InterViews Reference Manual"
.SH NAME
pages \- structured text demo program
.SH SYNOPSIS
\fBpages\fP [ textfile ]
.SH DESCRIPTION
\fIPages\fP is a simple program that demonstrates many of the features of
InterViews structured text objects.  The program displays a view of several
pages of formatted text including prose, headings, and program source code.
Resizing the view illustrates the way the text is automatically
composed to fill the available space.
.PP
Simple interaction with the text is also demonstrated.  Clicking on various
parts of the text selects different text objects.  For example, clicking on a
word in a sentence selects that word, clicking between words selects
the whole sentence, and clicking between sentences selects the whole
paragraph.  Clicking in the source code text selects a syntactically
meaningful unit such as a statement, a declaration, or a parameter.
.PP
Limited editing of the text can be performed, with dynamic
recomposition of the text objects.  When an object is selected, the
backspace or delete key will delete the object, while the space or return
key will insert a new editable word and enter character editing
mode.  In character editing mode, characters entered from
the keyboard will be added
to the selected word, and simple editing of the word can be
performed.  The backspace and delete keys erase the previous character, and
the ^F and ^B keys move the insertion point forwards and backwards.  A space
or return character begins a new word.  Selecting a different
object exits character edit mode.
.PP
Editing the text is a good way to see how text composition objects operate.
For example, editing text in a list object demonstrates the automatic
insertion of separators and the way the list is broken across multiple lines.
.PP
The \fIpages\fP source code is also an example of the way InterViews structured
text objects can be used in an application.  The code is separated into
several files.  In particular, \fIpages.c\fP contains the
user interface code, and \fIaux.c\fP contains the code that builds the
hierarchy of text objects.
.PP
The specific text displayed is read from the file \fIpages.text\fP in the
current directory.  Alternatively, the file can be specified as an
option on the command line or in the environment variable \fIPAGESTEXT\fP.
Examine the default file \fIpages.text\fP
in the pages source directory to see the
structure of the file.
.SH SEE ALSO
Text(3I), Layout(3I), TextBlock(3I)
