.TH idraw 1 "3 Apr 1989" "InterViews" "InterViews Reference Manual"
.SH NAME
idraw \- drawing editor
.SH SYNOPSIS
.B idraw
.RI [ options ]
.RI [ file ]
.SH DESCRIPTION
.I Idraw
creates and edits drawings composed from graphics like text, lines,
splines, rectangles, polygons, and ellipses.  It provides some of the
same functionality as MacDraw.
.PP
.I Idraw
can open an existing drawing when starting up or display a blank
unnamed drawing.  It displays a single portrait or landscape view of
an 8.5 by 11 inch page with a set of tools on the left side of the
view and a set of pulldown menus along the top of the view.  You can
pan and zoom the view with a sliding knob or adjuster in
.IR idraw 's
lower left corner.
.I Idraw
can save a modified drawing and open another drawing or spool a
drawing to be printed on a Postscript printer.  It can undo and then
redo a user-settable number of the last changes made to the drawing.
You can also set the fonts, brushes, patterns, and colors displayed in
the pulldown menus.
.I Idraw
stores drawings in Postscript files which you can print at any time,
not just when you run
.IR idraw .
.PP
.I Idraw
accepts all of the standard InterViews library options along with the
additional options listed below:
.TP 8
.B \-s
Create a small view showing about half of the 8.5x11 drawing area.
.TP
.B \-l
Create a large view showing the entire 8.5x11 drawing area (the
default). 
.TP
.I file
Open this drawing after creating the view.
.PP
You probably will use these three standard InterViews library options
as well (see
.I World(3i)
for the rest of the options):
.TP 8
.BI \-display " display"
Create a view on the specified display instead of using the
environment variable ``DISPLAY''.
.TP
.BI \-geometry " geometry"
Create a view shaped by an X geometry specification (see
.IR X(1) ).
.TP
.BI \-xrm " resourcestring"
Set a resource which does not have a separate command line option.
.SH "X DEFAULTS"
.I Idraw
allows you to set resources in a customization file named by the
environment variable ``XENVIRONMENT'' or
.B ~/.Xdefaults
if ``XENVIRONMENT'' is undefined.  Each string of the form
``idraw.resource:definition'' sets a resource.  You can set the number
of undoable changes or customize the font, brush, pattern, or color
menus.
.PP
If you want to customize any of the paint menus, you set a resource
given by the concatenation of the menu's name and the entry's number,
such as ``idraw.pattern8'', for each entry that you want to override.
All menus use the number 1 for the first entry.  You have to set
resources only for the entries that you want to override, not all of
them.  If you want to add entries to the menus, you simply set
resources for them, but don't skip any numbers after the end of the
menu because the menu will stop growing at the first undefined
resource it finds.  If you want to shorten a menu instead of extending
it, defining a blank string as the resource for an entry will truncate
the menu before that entry.
.PP
.I Idraw
understands the following resources:
.TP 15
.B history
Set the maximum number of undoable changes (20 by default).
.TP
.B initialfont
Set which font will be the initial font when
.I idraw
starts up.  Give a number which identifies the font by its position in
the Font menu starting from 1 for the first entry.
.TP
.BI font i
Define a custom font to use for the
.IR i th
entry in the Font menu.  Give three strings separated by whitespace.
The first string defines the font's name, the second string the
corresponding print font, and the third string the print size.  For
example, ``idraw.font3:8x13bold Courier-Bold 13'' defines the third
font entry.
.TP
.B initialbrush
Set which brush will be the initial brush when
.I idraw
starts up.  Give a number which identifies the brush by its position
in the Brush menu starting from 1 for the first entry.
.TP
.BI brush i
Define a custom brush to use for the
.IR i th
entry in the Brush menu.  You usually give two numbers and two
booleans: a 16-bit hexadecimal number to define the brush's line style
(each 1 bit draws a dash and each 0 bit a gap), a decimal integer to
define the brush's width in pixels, either 0 or 1 to determine whether
lines start from an arrowhead, and either 0 or 1 to determine whether
lines end in an arrowhead.  If you give only the string ``none'', it
defines the nonexistent brush.  For example, ``idraw.brush2:ffff 1 0
0'' defines a single pixel wide solid line without any arrowheads.
.TP
.B initialpattern
Set which pattern will be the initial pattern when
.I idraw
starts up.  Give a number which identifies the pattern by its position
in the Pattern menu starting from 1 for the first entry.
.TP
.BI pattern i
Define a custom pattern to use for the
.IR i th
entry in the Pattern menu.  You can specify the pattern from a 16x16
bitmap, a 8x8 bitmap, a 4x4 bitmap, a grayscale number, or the string
``none''.  You specify the 16x16 bitmap with sixteen 16-bit
hexadecimal numbers, the 8x8 bitmap with eight 8-bit hexadecimal
numbers, the 4x4 bitmap with a single 16-bit hexadecimal number, and
the grayscale number with a single floating point number.  The
floating point number must contain a period to distinguish itself from
the single hexadecimal number and lie between 0.0 and 1.0, where 0.0
corresponds to a solid pattern and 1.0 to a clear pattern.  On the
printer, the bitmap patterns appear as bitmaps, the grayscale patterns
appear as halftoned shades, and the ``none'' patterns never obscure
any underlying graphics.  For example, ``idraw.pattern8:8421'' defines
a diagonally hatched pattern.
.TP
.B initialfgcolor
Set which foreground color will be selected when
.I idraw
starts up.  Give a number which identifies the color by its position
in the FgColor menu starting from 1 for the first entry.
.TP
.BI fgcolor i
Define a custom color to use for the
.IR i th
entry in the FgColor menu.  Give a string defining the name of the
color and optionally three decimal numbers between 0 and 65535
following the name to define the red, green, and blue components of
the color's intensity.  The intensities override the name; that is,
idraw will look the name up in a window system database of common
colors only if you omit the intensities.  You can define shades of
gray by using equal proportions of each primary color.  For example,
``idraw.fgcolor8:Indigo 48896 0 65280'' defines a color which is a
mixture of red and blue.
.TP
.B initialbgcolor
Set which background color will be selected when
.I idraw
starts up.  Give a number which identifies the color by its position
in the BgColor menu starting from 1 for the first entry.
.TP
.BI bgcolor i
Define a custom color to use for the
.IR i th
entry in the BgColor menu.  The same rules apply to background colors
as to foreground colors.
.PP
Other users can edit drawings that you make with custom fonts,
brushes, patterns, or colors because
.I idraw
stores their definitions with the drawing and recreates them when it
reads the drawing back in.  However, not all definitions work across
all machines.  Thick or dashed brushes that work on one machine, for
example, may become invisible on another machine.  They will always
work in the printout, however.
.PP
N.B.: If you want to run
.I idraw
on X10, you will have to override its predefined X11 fonts with X10
fonts like the following:
.PP
.nf
idraw.font1:	6x10 Courier 8
idraw.font2:	6x13p Courier 10
idraw.font3:	vtbold Courier-Bold 13
idraw.font4:	helv10b Helvetica 12
idraw.font5:	helv12 Helvetica 14
idraw.font6:	helv12b Helvetica-Bold 14
idraw.font7:	helv12i Helvetica-Oblique 14
idraw.font8:	timrom10 Times-Roman 12
idraw.font9:	timrom12 Times-Roman 14
idraw.font10:	timrom12b Times-Bold 15
idraw.font11:	timrom12i Times-Italic 15
.fi
.SH "DRAWING TOOLS"
The drawing tools lie vertically along 
.IR idraw 's
left side.  
.BR Select ,
.BR Move ,
.BR Scale ,
.BR Stretch ,
.BR Rotate ,
and
.B Reshape
manipulate existing graphics.
.B Magnify 
makes a part of the view expand to fill the entire view.
.BR Text ,
.BR Line ,
.BR "Multi Line" ,
.BR "Open Spline" ,
.BR Ellipse ,
.BR Rectangle ,
.BR Polygon ,
and
.B Closed Spline
create new graphics.  The shift key will constrain the last group of
drawing tools if you press it at the
.I same
time you click the mouse to begin drawing.  You can set the current
drawing tool by clicking on it or typing its associated character.
The current drawing tool highlights itself with inverted colors.
Clicking the left mouse button in the drawing area invokes the current
drawing tool.
.I Idraw
provides the following drawing tools:
.TP 15
.B Select
Select a graphic whether or not it's already selected and discard all
other selections.  If you hold down the shift key,
.B Select
retains the previous selections while including an unselected graphic
or excluding a selected graphic.  If you press the button outside any
graphic, you can clear all of the selections or drag a rubberband
rectangle around a group of graphics to select all of them together.
.I Shortcut:
the right mouse button invokes
.B Select
while the mouse is in the drawing area.
.TP
.B Move
Move graphics from one spot to another.
.I Shortcut:
the middle mouse button invokes
.B Move
while the mouse is in the drawing area.
.TP
.B Scale
Scale graphics about their centers.
.TP
.B Stretch
Stretch graphics vertically or horizontally while tying down the
opposite edge.
.TP
.B Rotate
Rotate graphics about their centers according to the angle between two
radii: the one defined by the original clicking point and the one
defined by the current dragging point.
.TP
.B Reshape
Move one of a graphic's points and reshape the graphic accordingly.
Nothing happens when you try to reshape an ellipse or circle because
they don't have any points suitable for dragging.  When you try to
reshape some text, you will enter a text editing mode where you can
change the text with emacs-like keystrokes.  You will terminate the
mode when you use the mouse to do anything like pulling down a menu or
reshaping another graphic.
.TP
.B Magnify
Magnify the part of the drawing specified by dragging a rectangle to
fill the entire view.
.B Idraw
limits magnifications to powers of two between predefined minimum and
maximum magnifications.
.TP
.B Text
Create some text.  You click where you want to put the first line's
upper left corner and then type as much text as you want.  If the
caret would go off the text's canvas, the text will scroll to keep the
caret visible.  You may use emacs-style keystrokes to edit the text as
well as enter it.  You will terminate the mode and create the text
when you use the mouse to do anything.
.TP
.B Line
Create a line.  The shift key constrains the line to lie on either the
vertical or the horizontal axis.
.TP
.B "Multi Line"
Create a set of connected lines.  The shift key constrains each
segment to lie on either the vertical or the horizontal axis.  Any
button except the left mouse button terminates the line.
.TP
.B "Open Spline"
Create an open B-spline.  The shift key constrains each control point
to lie on either the vertical or the horizontal axis with the
preceding point.  Any button except the left mouse button terminates
the spline.
.TP
.B Ellipse
Create an ellipse.  The shift key constrains the ellipse to the shape
of a circle.
.TP
.B Rectangle
Create a rectangle.  The shift key constrains the rectangle to the
shape of a square.
.TP
.B Polygon
Create a polygon.  The shift key constrains each side to lie on either
the vertical or the horizontal axis.  Any button except the left mouse
button terminates the polygon.
.TP
.B "Closed Spline"
Create a closed B-spline.  The shift key constrains each control point
to lie on either the vertical or the horizontal axis with the
preceding point.  Any button except the left mouse button terminates
the spline.
.SH "PULLDOWN MENUS"
The pulldown menus 
.BR File ,
.BR Edit ,
.BR Structure ,
.BR Font ,
.BR Brush ,
.BR Pattern ,
.BR FgColor ,
.BR BgColor ,
.BR Align , 
and
.B Option
lie across 
.IR idraw 's
top.  They contain commands which you execute by pulling down the menu
and releasing the mouse button on the command or by typing the
character associated with the command.
.PP
The
.B File
menu contains the following commands to operate on files:
.TP 15
.B New
Destroy the current drawing and replace it with an unnamed blank
drawing.
.TP
.B Revert
Reread the current drawing, destroying any unsaved changes.
.TP
.B Open...
Open an existing drawing whose name you type.  The ellipses after the
command remind you that it will require additional input.
.TP
.B Save As...
Save the current drawing in a file whose name you type.
.TP
.B Save
Save the current drawing in the file it came from.
.TP
.B Print...
Print the current drawing by sending it through a pipe to a command
which you type, such as ``lpr.''
The bold rectangular outline (called the
.IR "page boundary" )
appearing in the drawing area indicates the portion of the drawing
that will appear on the printed page.
.TP
.B Directory...
Change the current working directory to a directory that you type in a
dialog box.
.PP
The
.B Edit
menu contains the following commands to edit graphics:
.TP 15
.B Undo
Undo the last done change to the drawing.  Successive
.B Undo
commands undo earlier and earlier changes back to the last stored
change and then do nothing.
.TP
.B Redo
Redo the last undone change to the drawing.  Successive
.B Redo
commands redo later and later changes up to the first change undone by
.B Undo
and then do nothing.  Any new changes cause all undone changes to be
forgotten. 
.TP
.B Cut
Remove the selected graphics from the drawing and place them in a file
called
.B .clipboard
in your home directory for later retrieval.
.TP
.B Copy
Copy the selected graphics into the clipboard.
.TP
.B Paste
Paste copies of the graphics in the clipboard into the drawing.
Together,
.BR Cut ,
.BR Copy , 
and
.B Paste
allow you to transfer graphics between multiple instantiations of
.I idraw
simply by cutting graphics out of one view and pasting them into
another.
.TP
.B Duplicate
Duplicate the selected graphics and add the copies to the drawing.
.TP
.B Delete
Destroy the selected graphics.
.TP
.B Select All
Select every graphic within the drawing.
.TP
.BR "Flip Horizontal" ", " "Flip Vertical"
Flip the selected graphics into their mirror images along the
horizontal or vertical axes.
.TP
.BR "90 Clockwise" ", " "90 CounterCW"
Rotate the selected graphics 90 degrees clockwise or counterclockwise.
.TP
.BR "Precise Move..." ", " "Precise Scale..." ", " "Precise Rotate..."
Move, scale, or rotate graphics by exact amounts which you type in a
dialog box.  You type movements in units of screen pixels, scalings in
terms of magnifications along the axes, and rotations in degrees.
.PP
The
.B Structure
menu contains the following commands to modify the structure of the
drawing, that is, the order in which graphics are drawn:
.TP 15
.B Group
Nest the selected graphics in a newly created picture.  A picture is
just a graphic which contains other graphics.
.B Group
allows you to build hierarchies of graphics.
.TP
.B Ungroup
Dissolve the selected pictures.
.B Ungroup
reverses a
.B Group
operation.
.TP
.B Bring To Front
Bring the selected graphics to the front of the drawing so that they
are drawn on top of (after) the other graphics in the drawing.
.TP
.B Send To Back
Send the selected graphics to the back of the drawing so that they are
drawn behind (before) the other graphics in the drawing.
.TP
.B Number of Graphics
Count and display in a popup window the number of selected graphics,
recursively adding the number of graphics nested inside pictures among
the selected graphics.
.B Select All
followed by
.B Number of Graphics
counts the total number of graphics in the drawing.
.PP
The
.B Font
menu contains a set of fonts with which to print text.  When you set
the current font from the menu, you will also set all the selected
graphics' fonts to that font.  A font indicator in the upper right
corner displays the current font.
.PP
The
.B Brush
menu contains a set of brushes with which to draw lines.  When you set
the current brush from the menu, you will also set all the selected
graphics' brushes to that brush.  The nonexistent brush draws
invisible lines and nonoutlined graphics.  The arrowhead brushes add
arrowheads to lines', multi lines', and open splines' starting point,
ending point, or both.  You can freely stretch or scale these graphics
without affecting the arrowheads' size.  A brush indicator in the
upper left corner displays the current brush.
.PP
The
.B Pattern
menu contains a set of patterns with which to fill graphics but not
text.  Text always appears solid but you can use a different color
than black to get a halftoned shade.  When you set the current pattern
from the menu, you will also set all the selected graphics' patterns
to that pattern.  The nonexistent pattern draws unfilled graphics
while the other patterns draw graphics filled with a bitmap or a
halftoned shade.
.PP
The
.B FgColor
and
.B BgColor
menus contains a set of colors with which to draw graphics and text.
When you set the current foreground or background color from the
FgColor or BgColor menu, you will also set all the selected graphics'
foreground or background colors.  The ``on'' bits in the bitmaps for
dashed lines and fill patterns appear in the foreground color while
the ``off'' bits appear in the background color.  A black and white
printer will print a halftoned shade of gray for any color other than
black or white.  The brush, pattern, and font indicators all reflect
the current colors.
.PP
The
.B Align
menu contains commands to align graphics with other graphics.  The
first graphic selected stays fixed while the other graphics move in
the order they were selected according to the type of alignment
chosen.  The last Align command, Align To Grid, aligns each selected
graphic's lower left corner with the nearest point in a grid of points
spaced every 8 printer's points (one ninth of an inch).
.PP
The
.B Option
menu contains the following commands:
.TP 15
.B Reduce
Reduce the magnification by a factor of two so the drawing's size
decreases by half.
.TP
.B Enlarge
Enlarge the magnification by a factor of two so the drawing's size
doubles.
.TP
.B Normal Size
Set the magnification to unity so the drawing appears at actual size.
.TP
.B Reduce to Fit
Reduce the magnification until the drawing fits entirely within the
view.
.TP
.B Center Page
Center the view over the center of the 8.5 by 11 inch page.
.TP
.B Gridding on/off
Toggle the grid's constraining effect on or off.  When gridding is on,
new graphics will use only grid points as their points, existing
graphics will move or scale only in grid-sized units, and so forth.
.TP
.B Grid visible/invisible
Toggle the grid's visibility on or off.  When visibility is on,
.I idraw
draws a grid of equally spaced points behind the drawing.
.TP
.B Grid spacing...
Change the grid spacing to a value (in units of printer's points of
which there are 72.07 to an inch) that you type in a dialog box.
.TP
.B Orientation
Toggle the drawing's orientation between portrait or landscape and
update the page boundary to reflect the drawing's new orientation.
.SH PANNER
.I Idraw
displays a panner, a box containing four movers, two zoomers, and a
slider, in its lower left corner to allow you to adjust the view in
any way you could want.  See Panner(1) for more information on how to
use a panner.  
.SH FILES
~/.clipboard		clipboard file for copy, cut, and paste
.SH "SEE ALSO"
pict2ps(1)
.SH BUGS
.I Idraw
can make the X10 Xqdss server mess up the display if
.I idraw
draws large polygons offscreen, such as if you move a line that goes
off the screen and ends in an arrowhead.  If the X10 server messes up
the screen, you won't be able to see anything and you will have to
kill the X10 server to use the display again.
.PP
The X10 Xqdss server cannot draw a grid of points and the X10 qvss
server draws the grid with some incorrect or missing points.
.I Idraw
can't do anything about these bugs.
.PP
If you rotate, scale, or stretch text, the text will print correctly
but 
.I idraw
will not show the text correctly on the screen.  Neither will the text
change size to correspond with the magnification when you zoom the
view.  If you must know how long some text is, you must view it at
normal magnification.  Even so, most fonts will take up more space per
character on the screen than on the paper when printed.  
