.fp 1 R
.fp 2 I
.fp 3 B
.ds f. CC.1
.TH CC 1
.SH NAME
CC \- C++ translator
.SH SYNOPSIS
.B CC
[ option ] ... file ...
.SH DESCRIPTION
.B CC
(capital CC) translates C++ source code to C source code. The command
uses \fIcpp\fR(1) for preprocessing, \fIcfront\fR for syntax and type checking,
and \fIcc\fR(1) for code generation.

.B CC
assumes arguments ending in
.TP
.B .c
are C++ source programs; they are compiled, and
each object program is left on the file
whose name is that of the source with
.B .o
substituted for
.BR .c .
.TP
.B .s
are assembly source programs; they are assembled into
.B .o
files.
.PP
.B CC
interprets the following options:
.TP
.B \-n
Print what would have been done, but don't do it.
.TP
.B \-v
Verbose mode.  Print the commands as they are called.
.TP
.B \-C
Prevent
.I cpp
and
.I cfront
from removing comments.
.TP
.B \-E
Run only
.I cpp
on the
.B .c
files and send the result to standard output.
.TP
.B \-F
Run only
.I cpp
and
.I cfront
on the
.B .c
files and send the result to standard output.
.TP
.B \-Fc
Like the
.B \-F
option, but the output is C source code suitable as a
.B .c
file for
.IR cc(1) .
.TP
.BI \-. suffix
Instead of using standard output for the
.B \-E ,
.B \-F
or
.B \-Fc
options, place the output from each
.B .c
file on a file with the corresponding
.IR .suffix .
.TP
.B \-k
Keep the files __ctdt.c and __ctdt.o.
They are used to initialize global and static
class objects.  Normally they are removed.
.TP
.B \-NOMUNCH
Do not run
.I nm
and
.I munch
on the resulting object file.  This phase is normally
needed to detect static constructors and destructors.
.TP
.B \+d
Suppress expansion of inline functions.
.TP
.B \+e1,+e0
These flags affect how the compiler handles tables for
virtual functions.
.B \+e1 
causes the tables to be external and initialized; 
.B \+e0 
causes the tables to be external and uninitialized.
If neither flag is specified (the default), the tables are
local (static) and initialized.  
One file with all virtuals known to it
should be compiled with \+e1; the rest should be compiled
with \+e0.  Having one external table may significantly
reduce compile time, link time and object file size.
.TP
.B \+I
Keep C source code produced by the front end in a ..c file.
Line number information is stripped.
.TP
.B \+V
Accept regular C function declarations; use the
.I /usr/include
directory for \fB#include\fR files.
Support for this option is not guaranteed in future releases
.TP
.B +L
Generate source line number information using the format "#line %d"
instead of "#%d".
.TP
.B +x\fIfile\fR
Read a file of sizes and alignments. Each line contains three fields:
a type name, the size (in bytes), and the alignment (in bytes). This option
is useful for cross compilation.
.TP
.B \+S
Spy on
.IR cfront ;
that is, print some information on
.IR stderr .
.sp
If the file ".CCpath" exists in the current working 
directory, the first line is assumed to be a colon
separated list of directories to be searched when
trying to find '#include' files.  If the file ".CCpath"
doesn't exist, the environment variable CCPATH is used.
All this is an alternative to the -I flag of cc(1).
.sp
If set, the environment variables
.I ccpC
(preprocessor), 
.I cfrontC
(C++ front end),
.I ccC
(c compiler),
.I assemblerC
(assembler),
.I linkerC
(linker), and
.I LIBRARY
(C++ library) override the defaults.
.sp
See
.I ld(1)
for loader options,
.I as(1)
for assembler options,
.I cc(1)
for code generation options,
and
.I cpp(1)
for preprocessor options.
.SH FILES
file.c		input file
.br
file..c		cfront output
.br
file.o		object file
.br
a.out		linked output
.br
/lib/cpp		C preprocessor
.br
cfront		C++ front end
.br
/bin/cc		C compiler
.br
/lib/libc.a	standard C library; see Section (3) in the UNIX System V Programmer Reference Manual
.br
/usr/local/lib/libC.a	C++ library
.br
/usr/include/CC		standard #include file directory
.br
/usr/include			#include file directory (+V flag)
.SH "SEE ALSO"
cc(1), monitor(3), prof(1), ld(1).
.br
Bjarne Stroustrup,
.I The C++ Programming Language,
Addison-Wesley 1986.
.br
B. W. Kernighan and D. M. Ritchie,
.I The C Programming Language,
Prentice-Hall 1978.
.br
.SH DIAGNOSTICS
The diagnostics produced by
.I CC
itself are intended to be
self-explanatory.
Occasional messages may be produced by the assembler or loader.
No messages should be produced by
.IR cc(1) .
.SH BUGS
Some ``used before set'' warnings are wrong.
.sp
There is a (temporary) hole in the C++ type system allowing C++ programs
to use C libraries. When a name is overloaded the first function of that
name (only) can be linked to a library compiled by \fIcc\fR. Thus,
the declaration
.IP
overload read(int,char*,int), read(vector*);
.LP
will allow the system call
.IR read (2)
to be used together with user defined functions
of the same name.
Use of this facility may lead to unexpected behavior. For example,
had the other
.I read()
been declared first,
or had the system's
.I read()
not been declared,
then the user's
.I read()
would have been called by library functions like
.IR scanf (3).
.br
