#!/bin/sh
#######################################################################
#
#    sh-Script <install_cid>  (by Heinz G. Seidl, hgs@cygnus.com)
#
#    -- Patch send_pr with the customer-id
#
#    This file is part of the Problem Report Management System (PRMS)
#    Copyright 1992 Cygnus Support
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public
#    License as published by the Free Software Foundation; either
#    version 2 of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
#
#    You should have received a copy of the GNU Library General Public
#    License along with this program; if not, write to the Free
#    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#    $Id: install_cid.sh,v 1.1 1992/05/28 17:56:29 zoo Exp $
#
#######################################################################

[ -n "$TRACE" ] && set -x

COM=`basename $0`
U="USAGE: $COM customer-id"

VERSION="$COM: 1.15"

BINDIR=/usr/local/bin
SEND_PR=send_pr
CUSTOMER_ID=
TEMP=/tmp/sp$$

if [ -z "$1" ]
then
	echo "$U"; exit 1
else
	CUSTOMER_ID="$1"
fi

path=`echo $0 | sed -e "s;${COM};;"`

if [ -z "$path" ] ; then path=. ; fi

if   [ -f $BINDIR/$SEND_PR ]
then
	SP_PATH=$BINDIR/$SEND_PR
elif [ -f $path/$SEND_PR ]
then
	SP_PATH=$path/$SEND_PR
else
	echo "$COM: cannot find \`$BINDIR/$SEND_PR' or \`$path/$SEND_PR'"
	exit 1
fi

trap 'rm -f $TEMP ; exit 0' 0

trap 'echo "$COM: Aborting ..."; rm -f $TEMP ; exit 1' 1 2 3 13 15

sed -e "s/^CUSTOMER_ID=.*/CUSTOMER_ID=${CUSTOMER_ID}/" $SP_PATH > $TEMP

if grep -s $CUSTOMER_ID $TEMP
then
	cp $SP_PATH $SP_PATH.orig
	rm -f $SP_PATH
	cp $TEMP $SP_PATH
	chmod a+rx $SP_PATH
	rm $TEMP
else
	echo "$COM: something went wrong when sed-ing the customer-id"
	exit 1
fi

echo "$COM: \`$CUSTOMER_ID' is now the default customer ID for send_pr"

exit 0
