
/*
FUNCTION
        <<sinh>>, <<sinhf>>---hyperbolic sine

INDEX
	sinh
INDEX
	sinhf

ANSI_SYNOPSIS
        #include <math.h>
        double sinh(double <[x]>);
        float  sinhf(float <[x]>);

TRAD_SYNOPSIS
        #include <math.h>
        double sinh(<[x]>)
        double <[x]>;

        float  sinhf(<[x]>)
        float <[x]>;

DESCRIPTION
	<<sinh>> computes the hyperbolic sine of the argument <[x]>.
	Angles are specified in radians.   <<sinh>>(<[x]>) is defined as 
	@ifinfo
	. (exp(<[x]>) - exp(-<[x]>))/2
	@end ifinfo
	@tex
	$${e^x - e^{-x}}\over 2$$
	@end tex

	<<sinhf>> is identical, save that it takes and returns <<float>> values.

RETURNS
	The hyperbolic sine of <[x]> is returned.  

	When the correct result is too large to be representable (an
	overflow),  <<sinh>> returns <<HUGE_VAL>> with the
	appropriate sign, and sets the global value <<errno>> to
	<<ERANGE>>. 

	<<sinhf>> returns <<FLT_MAX>> on overflow.

	You can modify error handling for these functions with <<matherr>>.

PORTABILITY
	<<sinh>> is ANSI C.  
	<<sinhf>> is an extension.

QUICKREF
	sinh ansi pure
	sinhf - pure
*/


#include "mathimpl.h"



#define DOUBLE
#define SNAME "sinh"
#include "sinh.h"

#undef SNAME
#define FLOAT
#define SNAME "sinhf"
#include "sinh.h"
