/*
FUNCTION
       <<frexp>>, <<frexpf>>---split floating-point number
INDEX
	frexp
INDEX
	frexpf

ANSI_SYNOPSIS
	#include <math.h>
        double frexp(double <[val]>, int *<[exp]>);
        float frexpf(float <[val]>, int *<[exp]>);

TRAD_SYNOPSIS
	#include <math.h>
        double frexp(<[val]>, <[exp]>)
        double <[val]>;
        int *<[exp]>;

        float frexpf(<[val]>, <[exp]>)
        float <[val]>;
        int *<[exp]>;


DESCRIPTION
	All non zero, normal numbers can be described as <[m]> * 2**<[p]>.
	<<frexp>> represents the double <[val]> as a mantissa <[m]>
	and a power of two <[p]>. The resulting mantissa will always
	be greater than or equal to <<0.5>>, and less than <<1.0>> (as
	long as <[val]> is nonzero). The power of two will be stored
	in <<*>><[exp]>. 

@ifinfo
<[m]> and <[p]> are calculated so that
<[val]> is <[m]> times <<2>> to the power <[p]>.
@end ifinfo
@tex
<[m]> and <[p]> are calculated so that
$ val = m \times 2^p $.
@end tex

<<frexpf>> is identical, other than taking and returning
floats rather than doubles.

RETURNS
<<frexp>> returns the mantissa <[m]>. If <[val]> is <<0>>, <<frexp>>
will set <<*>><[exp]> to <<0>> and return <<0>>. 

A DOMAIN error occurs if <[val]> is NaN. <<*>><[exp]> is set to 0 and <[val]> is
returned.  A user matherr function can override the return of <[val]>
but cannot influence the setting of <<*>><[exp]>.

PORTABILITY
<<frexp>> is ANSI.
<<frexpf>> is an extension.


*/
       
    

#include "mathimpl.h"

#define DOUBLE
#define NAME frexp
#define SNAME "frexp"
#include "frexp.h"
					       
#undef NAME
#undef SNAME
#define FLOAT
#define SNAME "frexpf"
#define NAME frexpf
#include "frexp.h"

					       



