#include "funcs.h"

TYPE_RET
_DEFUN(cbrt,(xa),
       TYPE_ARG xa)
{
  TYPE f;
  TYPE x = xa;
  
  int n;

  if (!finite(x)) 
   return __matherror(SNAME, x, 0.0, DOMAIN, x);
	
  if (x == 0.0)
   return x;

  f = frexp(x, &n);		/* x = f*2^n */
  f = ldexp(f, n/3);		/* f*2^(n/3) is a guess at (f*2^n)^(1/3) */

  /*
   * 	(f+e)^3 = x
   *	x/(f^2) = (f+e)^3/(f^2) = (f^3+3f^2 e+3f e^2+e^3)/(f^2) ~ f+3e
   *	(2f + (f+3e))/3 = f
   */
  f = (2*f + x/(f*f))/3;
  f = (2*f + x/(f*f))/3;
  f = (2*f + x/(f*f))/3;
  f = (2*f + x/(f*f))/3;
  f = (2*f + x/(f*f))/3;
  f = (2*f + x/(f*f))/3;
  f = (2*f + x/(f*f))/3;

  return f;
  
}
