/*
FUNCTION
	<<cbrt>>, <<cbrtf>>---cube root

INDEX
	cbrt
INDEX
	cbrtf

ANSI_SYNOPSIS
	#include <math.h>
	double cbrt(double <[x]>);
	float  cbrtf(float <[x]>);

TRAD_SYNOPSIS
	#include <math.h>
	double cbrt(<[x]>);
	float  cbrtf(<[x]>);

DESCRIPTION
	<<cbrt>> computes the cube root of the argument.
	You can modify error handling for this function with
	<<matherr>>.

RETURNS
	On success, the cube root is returned. 

PORTABILITY
	<<cbrt>> is in System V release 4.  <<cbrtf>> is an extension.
*/

#include "mathimpl.h"


#define DOUBLE
#define SNAME "cbrt"
#include "cbrt.h"
#undef SNAME

#define SNAME "cbrtf"
#define FLOAT
#include "cbrt.h"



