/*
FUNCTION
        <<asin>>, <<asinf>>---Arcsine

INDEX
   asin
INDEX
   asinf

ANSI_SYNOPSIS
        #include <math.h>
        double asin(double <[x]>);
        float asinf(float <[x]>);

TRAD_SYNOPSIS
        #include <math.h>
        double asin(<[x]>)
        double <[x]>;

        float asinf(<[x]>)
        float <[x]>;


DESCRIPTION

<<asin>> computes the inverse sine (arcsine) of the argument <[x]>.
Arguments to <<asin>> must be in the range @minus{}1 to 1.

<<asinf>> is identical to <<asin>>, other than taking and
returning floats.

You can modify error handling for these routines using <<matherr>>. 

RETURNS
@ifinfo
<<asin>> returns values in radians, in the range of -pi/2 to pi/2.
@end ifinfo
@tex
<<asin>> returns values in radians, in the range of $-\pi/2$ to $\pi/2$.
@end tex

If <[x]> is not in the range @minus{}1 to 1, <<asin>> and <<asinf>>
return NaN (not a number), set the global variable <<errno>> to
<<EDOM>>, and issue a <<DOMAIN error>> message.

You can change this error treatment using <<matherr>>.

QUICKREF ANSI SVID POSIX RENTRANT
 asin	 y,y,y,m
 asinf   n,n,n,m

MATHREF  
 asin,  -1<=arg<=1, asin(arg),,,
 asin,  NAN,  arg,EDOM, DOMAIN

MATHREF  
 asinf,  -1<=arg<=1, asin(arg),,,
 asinf,  NAN,  arg,EDOM, DOMAIN 


*/
#include "mathimpl.h"

double
_DEFUN(asin,(x),
double x)
{
  return _arcsine(x,0, "asin");
}

_FLOAT_RET
_DEFUN(asinf,(x),
       _FLOAT_ARG x)
{
  return _arcsinef(x,0, "asinf");
}
